;-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
; Toby Opferman
; _Secret/Scrat
; 3D Library
; http://www.opferman.com
; programming@opferman.com
;
; NOTICE: Make Your Floats DWORDs
;-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
.386
.387

.CODE

;-=-=-=-=-=-=-=-=-
; Scale Up Object
;   On Entry:
;     SI = X
;     DI = Y
;     BX = Z
;     ECX = Count
;     ScaleFactor = Scale
;
;   On Exit:
;     Nothing
;-=-=-=-=-=-=-=-=-

SCALEUP PROC
 PUSHA                                  ; Save Registers
 SKUP:
   FLD DWORD PTR [SI]                   ; Scale X
   FMUL ScaleFactor
   FSTP DWORD PTR [SI]

   FLD DWORD PTR [DI]                   ; Scale Y
   FMUL ScaleFactor
   FSTP DWORD PTR [DI]

   FLD DWORD PTR [BX]                   ; Scale Z
   FMUL ScaleFactor
   FSTP DWORD PTR [BX]
        
   ADD SI, 4                            ; Next Point
   ADD DI, 4
   ADD BX, 4
 LOOP SHORT SKUP                        ; Loop Back
 POPA                                   ; Restore Registers
 RET
ENDP SCALEUP


;-=-=-=-=-=-=-=-=-
; Scale Down Object
;   On Entry:
;     SI = X
;     DI = Y
;     BX = Z
;     ECX = Count
;     ScaleFactor = Scale
;
;   On Exit:
;     Nothing
;-=-=-=-=-=-=-=-=-
SCALEDOWN PROC
 PUSHA                                  ; Save Registers
 SKDN:
   FLD DWORD PTR [SI]                   ; Scale X
   FDIV ScaleFactor
   FSTP DWORD PTR [SI]

   FLD DWORD PTR [DI]                   ; Scale Y
   FDIV ScaleFactor
   FSTP DWORD PTR [DI]

   FLD DWORD PTR [BX]                   ; Scale Z
   FDIV ScaleFactor
   FSTP DWORD PTR [BX]
        
   ADD SI, 4                            ; Next Point
   ADD DI, 4
   ADD BX, 4
 LOOP SHORT SKDN                        ; Loop Back
 POPA                                   ; Restore Registers
 RET
ENDP SCALEDOWN

;-=-=-=-=-=-=-=-=-=-
; Line Drawing Procedure
; Draws a Line From
; On Entry:
;   (TempX, TempY) To (TempX2, TempY2)
;   DI = Offset Of Buffer
;   DL = Colour of Line
; On Exit:
;   Nothing
;-=-=-=-=-=-=-=-=-=-
LINE PROC
 PUSHA
  ADD DI, TempX                         ; Setting Up Starting Point
  MOV AX, TempY                         ; DI = Buffer + X + Y*320
  SHL AX, 6
  ADD DI, AX
  SHL AX, 2
  ADD DI, AX

  XOR AX, AX
  MOV Error, AX

  MOV AX, TempX2                        ; Set Delta X
  SUB AX, TempX
  MOV DeltaX, AX

  MOV AX, TempY2                        ; Set Delta Y
  SUB AX, TempY
  MOV DeltaY, AX

  MOV AX, 1                             ; Set X_INC To 1
  MOV X_INC, AX
  MOV AX, 320                           ; Set Y_INC To 320
  MOV Y_INC, AX

  XOR AX, AX                            ; Test Delta X Against 0
  CMP DeltaX, AX
  JGE SHORT SKIP1
  NEG X_INC                             ; Negate Them
  NEG DeltaX

  SKIP1:
  CMP DeltaY, AX                        ; Test DeltaY Against Zero
  JGE SHORT SKIP2
  NEG Y_INC                             ; Negate Them
  NEG DeltaY

  SKIP2:
  MOV AX, DeltaY
  CMP DeltaX, AX                        ; DeltaX > DeltaY?
  JLE SHORT ELSE1
  MOV CX, DeltaX                        ; Loop DeltaX Times
  INC CX
  THEN:
    DEC CX
    MOV BYTE PTR [DI], DL               ; Set Color

    MOV AX, DeltaY                      ; Set Error
    ADD Error, AX
    MOV AX, Error

    CMP AX, DeltaX                      ; Error>DeltaX
    JLE SHORT AGAIN
     SUB AX, DeltaX                     ; Error -= DeltaX
     MOV Error, AX
     ADD DI, Y_INC                      ; DI += Y_INC

    AGAIN:
    ADD DI, X_INC                       ; DI += X_INC
    TEST CX, CX
    JNZ SHORT THEN                      ; Loop Back

    JMP SHORT DONE_LINE
  ELSE1:
  MOV CX, DeltaY                        ; Loop DeltaY Times
  INC CX
  ELSE_LOOP:
    DEC CX
    MOV BYTE PTR [DI], DL               ; Set Color

    MOV AX, DeltaX                      ; Set Error
    ADD Error, AX
    MOV AX, Error

    CMP AX, 0                           ; Error>0
    JLE SHORT AGAIN2
     SUB AX, DeltaY                     ; Error -= DeltaY
     MOV Error, AX
     ADD DI, X_INC                      ; DI += X_INC

    AGAIN2:
    ADD DI, Y_INC                       ; DI += Y_INC
    TEST CX, CX
    JNZ SHORT ELSE_LOOP                 ; Loop Back

  DONE_LINE:
 POPA
 RET
ENDP LINE


;-=-=-=-=-=-=-=-=-=-=-
; Rotates Points Around Local
;  Axis
; On Entry:
;       ECX = Number Of Points
;
;  To Rotate Around X Axis
;       SI = Offset Y
;       DI = Offset Z
;  To Rotate Around Y Axis
;       SI = Offset X
;       DI = Offset Z
;   To Rotate Around Z Axis
;       SI = Offset X
;       DI = Offset Y
;  On Exit:
;    Nothing
;-=-=-=-=-=-=-=-=-=-=-
ROTATE_XYZ PROC
 PUSHA                                  ; Save Registers
 ROTX:
   FLD DWORD PTR [SI]                   ; SI = SI*COS-DI*SIN
   FMUL COSAngle
   FSTP Temp1

   FLD DWORD PTR [DI]
   FMUL SINAngle
   FSTP Temp2
   FLD Temp1
   FSUB Temp2
   FSTP Temp1                           ; Temporay Storage
      
   FLD DWORD PTR [DI]                   ; DI = SI*SIN+DI*COS
   FMUL COSAngle
   FSTP Temp2
   FLD DWORD PTR [SI]
   FMUL SINAngle
   FADD Temp2
   FSTP DWORD PTR [DI]                  ; Store DI

   FLD Temp1                            ; Store SI
   FSTP DWORD PTR [SI]

        
   ADD SI, 4                            ; Next Point
   ADD DI, 4
 LOOP SHORT ROTX                        ; Loop Back
 POPA                                   ; Restore Registers
 RET
ENDP ROTATE_XYZ






;-=-=-=-=-=-=-=-=-=-=-=-
; Projects 3D to 2D
; On Entry:
;    Fx = Camera X
;    Fy = Camera Y
;    Fz = Camera Z
;    
; In Tx, Ty
;-=-=-=-=-=-=-=-=-=-=-=-
PROJECT2D PROC
 PUSHA                          ; Save Regsiters

  ; Tx = X*VIEW/Z + HALFW                               
  FLD Fx                        ;   Load X
  FMUL VIEW                     ; * VIEW
  FDIV Fz                       ; / Z
  FADD HALFW                    ; Add HALFW
  FISTP Tx                      ; Store in Tx
                                
  ; Ty = HALFH - Y*VIEW/Z
  FLD Fy                        ; Load Y
  FMUL VIEW                     ; * VIEW
  FDIV Fz                       ; / Z
  FSUBR HALFH                   ; Subtract From HalfH
  FISTP Ty                      ; Store in Ty

 POPA                           ; Restore Registers
 RET
ENDP PROJECT2D

;-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
; Calculate World Coordinates
;  On Entry:
;    AX = Index Of Point in List
;    OffX = X List
;    OffY = Y List
;    OffZ = Z List
;  On Exit:
;    Fx = World X
;    Fy = World Y
;    Fz = World Z
;-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
WORLD PROC
 PUSHA
  XOR DX, DX            ; Index*4
  MOV BL, 4
  MUL BL

  MOV SI, OffX          ; Fx = X + WorldX
  ADD SI, AX
  FLD DWORD PTR [SI]
  FADD WORLDX
  FSTP Fx

  MOV SI, OffY          ; Fy = Y + WorldY
  ADD SI, AX
  FLD DWORD PTR [SI]
  FADD WORLDY
  FSTP Fy

  MOV SI, OffZ          ; Fz = Z + WorldZ
  ADD SI, AX
  FLD DWORD PTR [SI]
  FADD WORLDZ
  FSTP Fz


 POPA
 RET
ENDP WORLD



;-=-=-=-=-=-=-=-=-=-=-
; Draws a 3D Wire Frame
;  Object On The Screen
;
;  Faces should be set up as follows:
;   Colour, #Points to Face, Point1, ..., Pointn
;  On Entry:
;   CX = Number Of Faces
;   SI = 1st Face
;   DI = Offset Of DoubleBuffer
;   OffX = Address Of X Points
;   OffY = Address Of Y Points
;   OffZ = Address Of Z Points
;
;  On Exit:
;    Nothing
;-=-=-=-=-=-=-=-=-=-=-
DRAWOBJECT PROC
 PUSHA
   DRAWFACE:                  ; Draw The Face
     PUSH CX                  ; Save CX For Loop
     XOR CH, CH               ; Clear CH

     MOV CL, [SI+1]           ; Get Number of Points in Face
     DEC CX                   ; Subtract 1

     MOV DL, [SI]             ; Get Colour
     INC SI
    LINEPLOT:                 ; Plot Lines
      PUSH CX                 ; Save CX

      XOR AH, AH

      MOV BL, CL              ; Calculate Offset Of Next Face  
      NEG BL                  ; Point Number to BL
      ADD BL, [SI]            ; Convert BL (From 0-n) Instead of (n-0)
      XOR BH, BH              ; Get Rid Of High Byte


      MOV AL, DS:[SI+BX]      ; Get Point 1

      
      CALL WORLD              ; Calculate World Coordinates

      CALL PROJECT2D          ; Project It Into 2D
      MOV AX, Tx              ; Save The Point in TempX, TempY
      MOV CX, Ty
      MOV TempX, AX
      MOV TempY, CX
      

      MOV AL, DS:[SI+BX+1]    ; Get Point 2

      CALL WORLD              ; Calculate World Coordinates

      CALL PROJECT2D          ; Project Into 2D
      MOV AX, Tx
      MOV CX, Ty
      MOV TempX2, AX          ; Save The Point in TempX2, TempY2
      MOV TempY2, CX

      CALL LINE               ; Draw Line

      POP CX                  ; Restore The Line Counter
    LOOP SHORT LINEPLOT       ; Loop Next Line

    MOV AL, DS:[SI + 1]       ; Get First Point

    XOR AH, AH

    CALL WORLD                ; Calculate World Coordinates                
    CALL PROJECT2D            ; Project Into 2D
    MOV AX, Tx                ; Save Into TempX, TempY
    MOV CX, Ty
    MOV TempX, Ax
    MOV TempY, CX
        
    CALL LINE                 ; Plot Last Line

    MOV AL, [SI]
    XOR AH, AH

    ADD SI, AX                ; Next Face
    INC SI

    POP CX                    ; Restore Face Counter
   LOOP SHORT DRAWFACE        ; Next Face

 POPA
 RET
ENDP DRAWOBJECT


.DATA
 ; Screen Dimentions
 HALFW  dd 160.0
 HALFH  dd 100.0

 ; The View, You May Change.
 ;  Good Values are 100-300
 VIEW   dd 256.0

 ; The X, Y, Z World Coordinates Default = (0, 0, 300)
 ;   You May Change these in program or here as needed
 ;   This defines where the Object is put on the screen.
 WORLDX  dd 0
 WORLDY  dd 0
 WORLDZ  dd 300.0

 ; To Change The Angle, Just Punch
 ; COS(x) and SIN(x)
 ; Then put the Numbers Down Here
 ; Angle = 1 

 ; The COS(1) Angle Used
 COSAngle dd 0.9998476952

 ; The SIN(1) Angle Used
 SINAngle dd 0.0174524064


 ; Scaline Factor For 3D Objects
 ;  Change This to What You like
 ScaleFactor  dd  1.2

;-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
; These Variables used by the Engine
;   and have no ressult if you
;   modify them Unless Specified
;   as INPUT or OUTPUT from a Function.
;-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-

 ; Floats Used For Projection
 Fx      dd ?
 Fy      dd ?
 Fz      dd ?

 ; Offsets to Hold Pointers To Buffers
 OffX  dw ?
 OffY  dw ?
 OffZ  dw ?
 
 ; The Variables Used As Screen Coordinates
 TempX    dw  ?
 TempY    dw  ?
 TempX2   dw  ?
 TempY2   dw  ?
 Tx       dw  ?
 Ty       dw  ?

 ; Temproary Float Storage Locations
 Temp1    dd  ?
 Temp2    dd  ?

 ; Line Algorithm Variables
 DeltaX  dw  ?
 DeltaY  dw  ?
 Y_INC   dw  ?
 X_INC   dw  ?
 Error   dw  ?
