;-=-=-=-=-=-=-=-=-=-=-=-=-=-
; Toby Opferman
; _Secret/Scrat
; Demonstration of 3D.INC
; http://www.opferman.com
; programming@opferman.com
;-=-=-=-=-=-=-=-=-=-=-=-=-=-=-

.MODEL TINY
.386

.CODE
 ORG 100h
START:
 MOV AL, 13h
 INT 10h
 THREE_D:
   XOR EAX, EAX
   PUSH DS
   POP ES
   MOV DI, Offset Buffer
   MOV ECX, 16000
   REP STOSD                    ; Clear Double Buffer

   CMP RY, AL
   JZ SHORT R2

   MOV SI, Offset X                     
   MOV DI, Offset Z
   MOV ECX, 8

   CALL ROTATE_XYZ               ; Rotate On Y Axis

R2:
   CMP RX, AL
   JZ SHORT R3

   MOV ECX, 8
   MOV SI, Offset Y
   MOV DI, Offset Z

   CALL ROTATE_XYZ               ; Rotate On X Axis

R3:
   CMP RZ, AL
   JZ SHORT R4

   MOV ECX, 8
   MOV SI, Offset X
   MOV DI, Offset Y

   CALL ROTATE_XYZ               ; Rotate On Z Axis

R4:
   MOV SI, OFFSET Face1         ; Start at Face 1
   MOV CX, 6                   ; Loop Through The 6 Faces

   MOV DI, Offset Buffer

   MOV AX, Offset X
   MOV OffX, AX

   MOV AX, Offset Y
   MOV OffY, AX

   MOV AX, Offset Z
   MOV OffZ, AX

   CALL DrawObject

   MOV SI, Offset Buffer
   XOR DI, DI
   PUSH 0A000h
   POP ES
   MOV CX, 16000
   REP MOVSD                    ; Update Video Screen

 MOV AH, 1
 INT 16h
 JZ THREE_D
 CALL KEYS

 TEST BX, BX
 JZ THREE_D

 MOV AX, 3
 INT 10h
 RET

;-=-=-=-=-=-=-=-=-=-
; Keys
;  Tests Keyboard Input
;-=-=-=-=-=-=-=-=-=-
KEYS PROC
 XOR AH, AH
 INT 16h

 XOR BX, BX
 CMP AH, 45                     ; Scan Code For X
 JNE SHORT N1
 NOT RX                         ; Set Rotation Of X
N1:
 CMP AH, 21                     ; Scan Code For Y
 JNE SHORT N2
 NOT RY                         ; Set Rotation Of Y
N2:
 CMP AH, 44                     ; Scan Code For Z
 JNE SHORT N3
 NOT RZ                         ; Set Rotation Of Z
N3:
 CMP AH, 1                      ; Scan Code For Escape
 JNE SHORT N4
 NOT BX                         ; Set Quit
N4:
 CMP AH, 13                     ; Scale UP
 JNE SHORT N5
 MOV ECX, 8
 PUSH BX
 MOV SI, Offset X
 MOV DI, Offset Y
 MOV BX, Offset Z
 CALL SCALEUP
 POP BX
N5:
 CMP AH, 12                      ; Scale Down
 JNE SHORT N6
 MOV ECX, 8
 PUSH BX
 MOV SI, Offset X
 MOV DI, Offset Y
 MOV BX, Offset Z

 CALL SCALEDOWN
 POP BX
N6:
 RET
ENDP KEYS



.DATA

 ; The Vertices
 X dd 35.0, -35.0, -35.0,  35.0,  35.0,  35.0, -35.0, -35.0
 Y dd 35.0,  35.0, -35.0, -35.0,  35.0, -35.0, -35.0,  35.0
 Z dd 35.0,  35.0,  35.0,  35.0, -35.0, -35.0, -35.0, -35.0


 ; The Sides of the Cube
 Face1 db 1, 4, 0, 1, 2, 3
 Face2 db 2, 4, 4, 5, 6, 7
 Face3 db 3, 4, 0, 4, 7, 1
 Face4 db 4, 4, 3, 5, 6, 2
 Face5 db 5, 4, 0, 3, 5, 4
 Face6 db 6, 4, 1, 2, 6, 7


 ; The Rotation Status
 RX db 0
 RY db 0
 RZ db 0



INCLUDE 3D.INC

.DATA
 ; The Double Buffer
 Buffer db 64000 DUP(?)
END START
