/**********************************************************************
 * 
 *  Toby Opferman
 *
 *  Mutiny Driver!
 *
 *  This driver implements Operating System Mutiny!
 *
 *  This example is for educational purposes only.  I license this source
 *  out for use in learning how to write a device driver.
 *
 *     Driver Functionality Copyright (c) 2005, All Rights Reserved
 **********************************************************************/

#define _X86_
 

#include <wdm.h>
#include "mutiny.h"

/*
 * Should put this in a sharable header file.
 */
#define IOCTL_EXECUTE_64_BIT_CODE     CTL_CODE(FILE_DEVICE_UNKNOWN, 0x802, METHOD_BUFFERED, FILE_READ_DATA | FILE_WRITE_DATA)
                     

#pragma alloc_text(PAGE, Mutiny_Create) 
#pragma alloc_text(PAGE, Mutiny_DeviceControl) 
#pragma alloc_text(PAGE, Mutiny_Close)
#pragma alloc_text(PAGE, Mutiny_UnSupportedFunction)
                                
#define STATUS_CONTINUE_COMPLETION STATUS_SUCCESS

void Mutiny_TakeOverTheOperatingSystem(PVOID pCode, unsigned int uiCodeSize);

/**********************************************************************
 * 
 *  Mutiny_Create
 *
 *    This is called when an instance of this driver is created (CreateFile)
 *
 **********************************************************************/
NTSTATUS Mutiny_Create(PDEVICE_OBJECT DeviceObject, PIRP Irp)
{
    NTSTATUS NtStatus = STATUS_SUCCESS;
    PIO_STACK_LOCATION pIoStackIrp = NULL;

    DbgPrint("Mutiny_Create Called \r\n");
    

    Irp->IoStatus.Status      = NtStatus;
    Irp->IoStatus.Information = 0;

    IoCompleteRequest(Irp, IO_NO_INCREMENT);


    DbgPrint("Mutiny_Create Exit 0x%0x \r\n", NtStatus);

    return NtStatus;
}

/**********************************************************************
 * 
 *  Mutiny_DeviceControl
 *
 *    This is called when DeviceIoControl() from user mode.
 *
 **********************************************************************/
NTSTATUS Mutiny_DeviceControl(PDEVICE_OBJECT DeviceObject, PIRP Irp)
{
    NTSTATUS NtStatus = STATUS_SUCCESS;
    PIO_STACK_LOCATION pIoStackIrp = NULL;

    DbgPrint("Mutiny_DeviceControl Called \r\n");
    pIoStackIrp = IoGetCurrentIrpStackLocation(Irp);    

    if(pIoStackIrp) 
    {
        DbgPrint("Mutiny_DeviceControl Called IOCTL = 0x%0x\r\n", pIoStackIrp->Parameters.DeviceIoControl.IoControlCode);
        switch(pIoStackIrp->Parameters.DeviceIoControl.IoControlCode)
        {
            case IOCTL_EXECUTE_64_BIT_CODE:
                 Mutiny_TakeOverTheOperatingSystem(Irp->AssociatedIrp.SystemBuffer, pIoStackIrp->Parameters.DeviceIoControl.InputBufferLength);
                 break;    
        }
    }

    Irp->IoStatus.Status      = NtStatus;
    Irp->IoStatus.Information = 0;

    IoCompleteRequest(Irp, IO_NO_INCREMENT);


    DbgPrint("Mutiny_DeviceControl Exit 0x%0x \r\n", NtStatus);

    return NtStatus;
}


/**********************************************************************
 * 
 *  Mutiny_Close
 *
 *    Closes the instance (Does not need to be called in the context
 *                         of the opening process)
 *
 **********************************************************************/
NTSTATUS Mutiny_Close(PDEVICE_OBJECT DeviceObject, PIRP Irp)
{
    NTSTATUS NtStatus = STATUS_SUCCESS;
    PIO_STACK_LOCATION pIoStackIrp = NULL;

    DbgPrint("Mutiny_Close Called \r\n");

    Irp->IoStatus.Status      = NtStatus;
    Irp->IoStatus.Information = 0;

    IoCompleteRequest(Irp, IO_NO_INCREMENT);

    DbgPrint("Mutiny_Close Exit 0x%0x \r\n", NtStatus);

    
    return NtStatus;
}


                       

/**********************************************************************
 * 
 *  Mutiny_UnSupportedFunction
 *
 *    This is called when a major function is issued that isn't supported.
 *
 **********************************************************************/
NTSTATUS Mutiny_UnSupportedFunction(PDEVICE_OBJECT DeviceObject, PIRP Irp)
{
    NTSTATUS NtStatus = STATUS_NOT_SUPPORTED;
    DbgPrint("TdiExample_UnSupportedFunction Called \r\n");


    Irp->IoStatus.Status      = NtStatus;
    Irp->IoStatus.Information = 0;

    IoCompleteRequest(Irp, IO_NO_INCREMENT);

    DbgPrint("TdiExample_UnSupportedFunction Exit 0x%0x \r\n", NtStatus);    
    
    return NtStatus;
}





