;=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
;   AUTHOR: Toby Opferman
;   DATE:   September 29, 2005 
;
;   DESCRIPTION:
;           This will flip the screen upside down
;
;   MIRROR.ASM
;
;   Copyright (C) 2005 All Rights Reserved
;=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-


;

; Put the screen into 1280x1024x32bit Color and if this is the maximum resolution
;  and the memory is in the same place as my video card, this will flip the screen.
;
;  My video card has 0d8000000h as the extended linear video memory.
; NVIDIA GeForce2 MX


LOADK64 SEGMENT 
START:
   ORG 0             ; If you want to use the stack just refresh RSP so that the TOP half is correct.  ESP is fine, but
                     ; we can't trust the top 32 bits to be clear.
   MOV RDI, 0d8000000h + (1280*(512)*4)
   MOV RSI, 0d8000000h + (1280*(514)*4)
   MOV RCX, 512
MIRROR_THE_SCREEN:
   SUB RSI, (1280*8)
   MOV RDX, (1280*4)/8
   
MIRROR_THE_SCREEN_INNER_LOOP:
   MOV RAX, QWORD PTR [RSI]
   MOV QWORD PTR [RDI], RAX
   ADD RSI, 8
   ADD RDI, 8
   DEC RDX
   JNZ SHORT MIRROR_THE_SCREEN_INNER_LOOP
   
   DEC RCX
   JNZ SHORT MIRROR_THE_SCREEN
   RETF              ; RETF will return to the Operating System in this model.
LOADK64 ENDS


END START
