/***********************************************************************
 * TestAudio.C
 *  
 *    Application to test the gif library
 *
 *
 * Toby Opferman Copyright (c) 2002
 *
 ***********************************************************************/
 
 
#include <windows.h>
#include <stdio.h>
#include <stdlib.h>
#include <gif.h>
#include <gdi.h>
 
#define TGIF_CLASS_NAME "TESTGIF"
#define TGIF_TITLE      "Test Gif Display"
#define SIZE_X 500
#define SIZE_Y 500
typedef struct _IMAGE_INFO
{
	UINT Width;
	UINT Height;
	HGDI  hGDI;

} IMAGE_INFO, *PIMAGE_INFO;


 BOOL WINAPI GifTest_RegisterClass(HINSTANCE hInstance);
 LRESULT CALLBACK GifTest_WindowProc(HWND hWnd, UINT wMsg, WPARAM wParam, LPARAM lParam);
 HWND WINAPI GifTest_CreateWindow(HINSTANCE hInstance, UINT Width, UINT Height, PIMAGE_INFO pImageInfo);
 int WINAPI GifTest_MessageLoop(HINSTANCE hInstance, HWND hWnd);
void GifTest_CreateHandler(HWND hWnd, PIMAGE_INFO pImageInfo);
 void GifTest_PaintScreen(HWND hWnd);

 /***********************************************************************
  * main
  *
  *    Entry Point For console Applications
  *
  * Parameters
  *     Standard console Entry Point Parameters
  * 
  * Return Value
  *     Result of the program
  *
  ***********************************************************************/
 int __cdecl main(int argc, char **argv)
 {
	 HGIF hGif;
	 char *ScreenBuffer;
	 HINSTANCE hInstance = GetModuleHandle(NULL);	 
	 IMAGE_INFO ImageInfo;
	 HWND hWnd;

	 if(argc == 2)
	 {

		hGif = Gif_Open(argv[1]);
		
		ImageInfo.Width  = Gif_GetImageWidth(hGif, 0);
        ImageInfo.Height = Gif_GetImageHeight(hGif, 0);
        ImageInfo.hGDI   = GDI_Init(NULL, ImageInfo.Width, ImageInfo.Height);
  
		GifTest_RegisterClass(hInstance);
		hWnd = GifTest_CreateWindow(hInstance, SIZE_X, SIZE_Y, &ImageInfo);
		

		ScreenBuffer = GDI_BeginPaint(ImageInfo.hGDI);
		Gif_GetImage32bpp(hGif, 0, ScreenBuffer);
		GDI_EndPaint(ImageInfo.hGDI);

		Gif_Close(hGif);

        InvalidateRect(hWnd, NULL, FALSE);
		GifTest_MessageLoop(hInstance, hWnd);


	 }
	 else
	 {
		 printf("TestGif <giffile>\n");
	 }

	     
     return 0;
 }




                   
 /***********************************************************************
  * GifTest_RegisterClass
  *  
  *    Registers the Test Window Proc Class
  *
  * Parameters
  *     instance Handle
  * 
  * Return Value
  *     TRUE on Success, FALSE on Failure
  *
  ***********************************************************************/
 BOOL WINAPI GifTest_RegisterClass(HINSTANCE hInstance)
 {
     WNDCLASSEX WndClassEx = {0};

     WndClassEx.cbSize        = sizeof(WndClassEx);
     WndClassEx.style         = 0;
     WndClassEx.lpfnWndProc   = GifTest_WindowProc;
     WndClassEx.cbWndExtra    = 0;
     WndClassEx.hInstance     = hInstance;
     WndClassEx.hIcon         = NULL;
     WndClassEx.hCursor       = NULL;
     WndClassEx.hbrBackground = (HBRUSH)GetStockObject(BLACK_BRUSH);
     WndClassEx.lpszMenuName  = "";
     WndClassEx.lpszClassName = TGIF_CLASS_NAME;
     WndClassEx.hIconSm       = NULL;
     
     return RegisterClassEx(&WndClassEx);
 }



 /***********************************************************************
  * GifTest_CreateWindow
  *  
  *    Creates The Test Window
  *
  * Parameters
  *     instance Handle
  * 
  * Return Value
  *     Window Handle on Success, NULL on Failure
  *
  ***********************************************************************/
 HWND WINAPI GifTest_CreateWindow(HINSTANCE hInstance, UINT Width, UINT Height, PIMAGE_INFO pImageInfo)
 {
     HWND hWnd = NULL;

     if(!FindWindow(TGIF_CLASS_NAME, NULL))
     {
        if(hWnd = CreateWindowEx(0, TGIF_CLASS_NAME, TGIF_TITLE, WS_SYSMENU | WS_POPUP | WS_VISIBLE | WS_CAPTION | WS_OVERLAPPED, 0,  0, Width, Height, HWND_DESKTOP, NULL,  hInstance, (PVOID)pImageInfo))
        {
            ShowWindow(hWnd, SW_SHOWNORMAL);
            UpdateWindow(hWnd);
        }
     }

     return hWnd;
 }



 /***********************************************************************
  * GifTest_MessageLoop
  *  
  *    Handles Window Messages to be dispatched to the Cubix Window
  *
  * Parameters
  *     instance Handle, Window Handle
  * 
  * Return Value
  *     Exit Value
  *
  ***********************************************************************/
 int WINAPI GifTest_MessageLoop(HINSTANCE hInstance, HWND hWnd)
 {
     MSG Msg = {0};
     BOOL bMessageLoop = TRUE;

     while(bMessageLoop)
     {
         if(GetMessage(&Msg, 0, 0, 0))
         {
             TranslateMessage(&Msg);
             DispatchMessage(&Msg);
        }
        else
        {
            bMessageLoop = FALSE;
        }
     }

     return Msg.wParam;
 }



 

 /***********************************************************************
  * GifTest_WindowProc
  *  
  *    Handles Window Messages Send to the window
  *
  * Parameters
  *     Standard Windows Proc Handler
  * 
  * Return Value
  *     Exit Value
  *
  ***********************************************************************/
 LRESULT CALLBACK GifTest_WindowProc(HWND hWnd, UINT wMsg, WPARAM wParam, LPARAM lParam)
 {
     LRESULT dwRetValue = 0;

     switch(wMsg)
     {
         case WM_CREATE:
              GifTest_CreateHandler(hWnd, (PIMAGE_INFO)((LPCREATESTRUCT)lParam)->lpCreateParams);
              break;


         case WM_PAINT:
              GifTest_PaintScreen(hWnd);
              break;

         case WM_CLOSE:
         case WM_DESTROY:
              ShowCursor(TRUE);
              PostQuitMessage(0);
              break;

         default:
              dwRetValue = DefWindowProc(hWnd, wMsg, wParam, lParam);
     }

     return dwRetValue;
 }


 /***********************************************************************
  * GifTest_PaintScreen
  *  
  *    
  *
  * Parameters
  *     
  * 
  * Return Value
  *     None
  *
  ***********************************************************************/
 void GifTest_PaintScreen(HWND hWnd)
 {
     HDC hDC;
     PAINTSTRUCT ps;
     RECT Rect;
     PIMAGE_INFO pImageInfo = (PIMAGE_INFO)GetWindowLong(hWnd, GWL_USERDATA);
     HDC ImageDc;
	 
	 ImageDc = GDI_GetDC(pImageInfo->hGDI);

     hDC = BeginPaint(hWnd, &ps);

     GetClientRect(hWnd, &Rect);

     BitBlt(hDC, 0, 0, pImageInfo->Width, pImageInfo->Height, ImageDc, 0, 0, SRCCOPY);

     EndPaint(hWnd, &ps);

	 GDI_ReleaseDC(pImageInfo->hGDI);
 }





 /***********************************************************************
  * GifTest_CreateHandler
  *  
  *    Handles processing virtual keys
  *
  * Parameters
  *     Window Handle, Virtual Key
  * 
  * Return Value
  *     None
  *
  ***********************************************************************/
void GifTest_CreateHandler(HWND hWnd, PIMAGE_INFO pImageInfo)
{
   SetWindowLong(hWnd, GWL_USERDATA, (ULONG)pImageInfo);
}




