/*******************************************************
 *
 *  MapLoader.c
 *
 *     Map Loader
 *
 *  Copyright (c) 2007, All Rights Reserved
 *
 *******************************************************/
 
 
 
#include <windows.h>
#include <maploader.h>
#include <stdarg.h>
#include <stdio.h>

 
/*********************************************************
 * Internal Functions
 *********************************************************/
void MapLoader_Debug(char *pszFormatString, ...);
HANDLE MapLoader_OpenFile(char *pszFileName);
HANDLE MapLoader_CreateFile(char *pszFileName);

#define IS_HANDLE_VALID(x) (x != NULL && x != INVALID_HANDLE_VALUE)



 /********************************************************
  *  MapLoader_LoadMap
  *
  *     Load a MapFile
  *   
  *
  *
  ********************************************************/
BOOL WINAPI MapLoader_LoadMap(PCHAR pszMapFile, PMAP_INFO pMapInfo)
{
	BOOL FileLoaded = FALSE;
	HANDLE hMapFile;
	DWORD dwBytes;
	UINT Index;

	hMapFile = MapLoader_OpenFile(pszMapFile);

	if(IS_HANDLE_VALID(hMapFile))
	{
		
		ReadFile(hMapFile, &pMapInfo->MapResolutionX, sizeof(UINT), &dwBytes, NULL);
		ReadFile(hMapFile, &pMapInfo->MapResolutionY, sizeof(UINT), &dwBytes, NULL);

		pMapInfo->MapData = (DWORD *)LocalAlloc(LMEM_ZEROINIT, pMapInfo->MapResolutionY*pMapInfo->MapResolutionX*sizeof(DWORD));

		if(pMapInfo->MapData)
		{
			FileLoaded = TRUE;

			for(Index = 0; Index < pMapInfo->MapResolutionX*pMapInfo->MapResolutionY; Index++)
			{
				ReadFile(hMapFile, &pMapInfo->MapData[Index], sizeof(DWORD), &dwBytes, NULL);
			}
		}

		CloseHandle(hMapFile);
	}

    return FileLoaded;
}


 /********************************************************
  *  MapLoader_SaveMap
  *
  *     Save a MapFile
  *   
  *
  *
  ********************************************************/
BOOL WINAPI MapLoader_FreeMap(PMAP_INFO pMapInfo)
{
	LocalFree(pMapInfo->MapData);
	pMapInfo->MapData = NULL;
	return TRUE;
}

 /********************************************************
  *  MapLoader_SaveMap
  *
  *     Save a MapFile
  *   
  *
  *
  ********************************************************/
BOOL WINAPI MapLoader_SaveMap(PCHAR pszMapFile, PMAP_INFO pMapInfo)
{
	BOOL FileSaved = FALSE;
	HANDLE hMapFile;
	UINT Index;
	DWORD dwBytes;

	hMapFile = MapLoader_CreateFile(pszMapFile);

	if(IS_HANDLE_VALID(hMapFile))
	{
		FileSaved = TRUE;

		WriteFile(hMapFile, &pMapInfo->MapResolutionX, sizeof(UINT), &dwBytes, NULL);
		WriteFile(hMapFile, &pMapInfo->MapResolutionY, sizeof(UINT), &dwBytes, NULL);

		for(Index = 0; Index < pMapInfo->MapResolutionX*pMapInfo->MapResolutionY; Index++)
		{
			WriteFile(hMapFile, &pMapInfo->MapData[Index], sizeof(DWORD), &dwBytes, NULL);
		}

		CloseHandle(hMapFile);
	}

    return FileSaved;
}

/***********************************************************************
 * MapLoader_OpenFile
 *  
 *    Debug 
 *
 *    
 *
 * Parameters
 *     Debug
 *
 * Return Value
 *     Nothing
 *
 ***********************************************************************/
HANDLE MapLoader_OpenFile(char *pszFileName)
{
	return  CreateFile(pszFileName, GENERIC_READ, 0, NULL, OPEN_EXISTING, 0, NULL);
}

/***********************************************************************
 * MapLoader_CreateFile
 *  
 *    Debug 
 *
 *    
 *
 * Parameters
 *     Debug
 *
 * Return Value
 *     Nothing
 *
 ***********************************************************************/
HANDLE MapLoader_CreateFile(char *pszFileName)
{
	return CreateFile(pszFileName, GENERIC_WRITE, 0, NULL, CREATE_ALWAYS, 0, NULL);
}


/***********************************************************************
 * MapLoader_Debug
 *  
 *    Debug 
 *
 *    
 *
 * Parameters
 *     Debug
 *
 * Return Value
 *     Nothing
 *
 ***********************************************************************/
 void MapLoader_Debug(char *pszFormatString, ...)
 {
     char DebugString[256];
     va_list vl;

     va_start(vl, pszFormatString);
     vsprintf(DebugString, pszFormatString, vl);
     va_end(vl);

     OutputDebugStringA(DebugString);
 }
