/***********************************************************************
 * TestProgress.C
 *  
 *    Application to test the progress library
 *
 *
 * Toby Opferman Copyright (c) 2002
 *
 ***********************************************************************/
 
 
#include <windows.h>
#include <stdio.h>
#include <commctrl.h>
#include <progress.h>
 
 void Test_WorkThread(HPROGRESS hProgress, PVOID pContext);

 /***********************************************************************
  * main
  *
  *    Entry Point For console Applications
  *
  * Parameters
  *     Standard console Entry Point Parameters
  * 
  * Return Value
  *     Result of the program
  *
  ***********************************************************************/
 int __cdecl main(UINT argc, char **argv)
 {
	 DWORD ReturnValue;
	 INITCOMMONCONTROLSEX Init ={0};

	 Init.dwSize = sizeof(INITCOMMONCONTROLSEX);
	 Init.dwICC = ICC_PROGRESS_CLASS | ICC_BAR_CLASSES;

	 InitCommonControlsEx(&Init);

	 ReturnValue = (DWORD)Progress_QuickProgressBar(NULL, GetModuleHandle(NULL), 100, NULL, NULL, Test_WorkThread, 1);
	     
	 printf("Exit %i\n", ReturnValue);

	 ReturnValue = (DWORD)Progress_QuickProgressBar(NULL, GetModuleHandle(NULL), 100, NULL, NULL, Test_WorkThread, 0);
	     
	 printf("Exit %i\n", ReturnValue);

     return 0;
 }


 
 /***********************************************************************
  * Test_WorkThread
  *
  *    
  *
  ***********************************************************************/
void Test_WorkThread(HPROGRESS hProgress, PVOID pContext)
{
	 Progress_Advance(hProgress, 0, "Starting");
	 Sleep(500);
	 Progress_Advance(hProgress, 20, "Building");
	 Sleep(500);
	 Progress_Advance(hProgress, 20, NULL);
	 Sleep(500);
	 Progress_Advance(hProgress, 20, "Working");
	 Sleep(500);
	 Progress_Advance(hProgress, 0, "ReBuilding");
	 Sleep(500);
	 Progress_Advance(hProgress, 20, "Building Again");
	 Sleep(500);
	 Progress_Advance(hProgress, 20, "Finish");
	 Sleep(500);

	 Progress_CompleteAndCloseQuickWithReturn(hProgress, (PVOID)100);
}



