/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*
   Assembly Programmer's Reference
               Guide

  Copyright 1998 By Toby Opferman
 *-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/


#ifndef __ASMDEF_H__
#define __ASMDEF_H__

#define IDM_CREDIT -1
#define IDM_ABOUT 0
#define IDM_EAX   1
#define IDM_EBX   2
#define IDM_ECX   3
#define IDM_EDX   4 
#define IDM_CS    5
#define IDM_DS    6
#define IDM_ES    7
#define IDM_FS    8
#define IDM_GS    9
#define IDM_SS   10
#define IDM_EDI  11
#define IDM_ESI  12
#define IDM_EBP  13
#define IDM_ESP  14
#define IDM_CR0  15
#define IDM_CR1  16      
#define IDM_CR2  17
#define IDM_CR3  18
#define IDM_CR4  19
#define IDM_DR0  20
#define IDM_DR1  21      
#define IDM_DR2  22
#define IDM_DR3  23
#define IDM_DR4  24
#define IDM_DR5  25
#define IDM_DR6  26
#define IDM_DR7  27
#define IDM_DMCR 28
#define IDM_IDTR 29
#define IDM_EIP  30
#define IDM_FLAGS 31
#define IDM_CPUDETECT 32
#define IDM_GDTR 33
#define IDM_LDTR 34
#define IDM_WARMBOOT 35
#define IDM_KEYBOARD 36
#define IDM_JOYSTICK 37
#define IDM_MOUSE 38
#define IDM_PORTLIST 39
#define IDM_TYPEC 40
#define IDM_RESET 41


#define IDM_TILE IDM_RESET + 1
#define IDM_CASCADE IDM_TILE + 1
#define IDM_ARRANGE IDM_CASCADE + 1
#define IDM_CLOSEALL IDM_ARRANGE + 1
#define IDM_CLOSE IDM_CLOSEALL + 1



char *Title[42] = { 0, "EAX Register", "EBX Register", "ECX Register", "EDX Register",
                        "CS Register", "DS Register", "ES Register",
                        "FS Register", "GS Register", "SS Register",
                        "EDI Register", "ESI Register", "EBP Register",
                        "ESP Register", "CR0 Register", "CR1 Register",
                        "CR2 Register", "CR3 Register", "CR4 Register",
                        "DR0 Register", "DR1 Register", "DR2 Register",
                        "DR3 Register", "DR4 Register", "DR5 Register",
                        "DR6 Register", "DR7 Register", "DMCR",
                        "IDTR", "EIP Register", "EFlags Register",
                        "CPU Detection", "GDTR", "LDTR",
                        "Warm Booting", "KeyBoard", "Joystick",
                        "Mouse", "Ralf Brown's Port List",
                        "Type Casts",
                        "CPU Reset State" } ;
 

char *Files[42] = { 0, "eax.txt", "ebx.txt", "ecx.txt", "edx.txt",
                        "cs.txt", "ds.txt", "es.txt", "fs.txt",
                        "gs.txt", "ss.txt", "edi.txt", "esi.txt",
                        "ebp.txt", "esp.txt", "cr0.txt", "cr1.txt",
                        "cr2.txt", "cr3.txt", "cr4.txt", "dr0.txt",
                        "dr1.txt", "dr2.txt", "dr3.txt", "dr4.txt",
                        "dr5.txt", "dr6.txt", "dr7.txt", "dmcr.txt",
                        "idtr.txt", "eip.txt", "eflags.txt",
                        "cpud.txt", "gdtr.txt", "ldtr.txt",
                        "wboot.txt", "keyboard.txt", "joystick.txt",
                        "mouse.txt", "ports.txt", "typec.txt",
                        "reset.txt" };

#endif
