/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*
   Assembly Programmer's Reference
               Guide

  Copyright 1998 By Toby Opferman
 *-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/


 /* Header Files */
 #include <windows.h>
 #include "asmdef.h"
 #include <mem.h>
 #include <stdio.h>
 #include <string.h>
 
 /* Prototypes */
 LRESULT CALLBACK WndProc(HWND, UINT, WPARAM, LPARAM);
 LRESULT CALLBACK ChildProc(HWND, UINT, WPARAM, LPARAM);
 BOOL CALLBACK CloseEnumProc(HWND, LPARAM);
 BOOL CALLBACK AboutProc(HWND, UINT, WPARAM, LPARAM);
 BOOL CALLBACK RegProc(HWND, UINT, WPARAM, LPARAM); 
 BOOL Init(HINSTANCE);
 BOOL InitChild(HINSTANCE);
 HWND InitClass(HINSTANCE, int);
 
 HMENU hMenu, hMenuSub;
 HINSTANCE g_hInstance;
 
 typedef struct pass_type  {
      char Name[50];
      char File[50];
 } PASS;

 PASS Pass;
 
 typedef struct window_type {

    char **TextPhile;
    char WindowTitle[50];
    int MaxLines, MaxWidth, cxChar,
        cxCaps, cyChar, cyClient,
        iVscrollPos, iHscrollPos,
        iVscrollInc, iVscrollMax,
        cxClient, iHscrollInc,
        iHscrollMax, iMaxWidth;
   

 } WINDOW;


 int PASCAL WinMain(HINSTANCE hInstance, HINSTANCE hPrevhInstance, PSTR CmdStrng, int nCmdShow)
{
    MSG msg;
    HWND hwnd, hwndClient;
    HACCEL hAccel;
    g_hInstance = hInstance;
    
   /* Initialize The Window */
   if(!Init(hInstance))
     return FALSE;

   /* Initialize The Chid Window */
   if(!InitChild(hInstance))
     return FALSE;

    
   /* Create The Window */
   if(!(hwnd = InitClass(hInstance, nCmdShow)))
     return FALSE;

   /* Get Client Handle */
   hwndClient = GetWindow(hwnd, GW_CHILD);
   
   /* Display The Window */
   ShowWindow(hwnd, nCmdShow);
   UpdateWindow(hwnd);

   hMenu = LoadMenu(hInstance, "AsmMenu");
   hMenuSub = GetSubMenu(hMenu, 10);

    
   hAccel = LoadAccelerators(hInstance, "MdiAccel");
   
    /* Message Loop */
    while(GetMessage(&msg, NULL, NULL, NULL))
    {
        if(!TranslateMDISysAccel (hwndClient, &msg) &&
            !TranslateAccelerator (hwnd, hAccel, &msg))
           {
                TranslateMessage(&msg);
                DispatchMessage(&msg);
           }
    }

    return (msg.wParam);
}


 /* Define and Register The Window */
 BOOL Init(HINSTANCE hInstance)
{
    WNDCLASSEX wndclass;
     
    /* Define The Window */
    wndclass.style = 0;
    wndclass.cbSize = sizeof(wndclass);
    wndclass.lpfnWndProc = WndProc;
    wndclass.cbClsExtra = 0;
    wndclass.cbWndExtra = 0;
    wndclass.hInstance = hInstance;
    wndclass.hIcon = LoadIcon(hInstance, "Chip");
    wndclass.hCursor = LoadCursor(NULL, IDC_ARROW);
    wndclass.hbrBackground = (HBRUSH)GetStockObject(GRAY_BRUSH);
    wndclass.lpszMenuName = "AsmMenu";
    wndclass.lpszClassName = "MdiFrame";
    wndclass.hIconSm = LoadIcon(hInstance, "AsmG");
 
 
 return RegisterClassEx(&wndclass);
}

 /* Child Window */
 BOOL InitChild(HINSTANCE hInstance)
{
    WNDCLASSEX wndclass;
     
    /* Define The Window */
    wndclass.style = 0;
    wndclass.cbSize = sizeof(wndclass);
    wndclass.lpfnWndProc = ChildProc;
    wndclass.cbClsExtra = 0;
    wndclass.cbWndExtra = sizeof(HANDLE);
    wndclass.hInstance = hInstance;
    wndclass.hIcon = LoadIcon(hInstance, "Chip");
    wndclass.hCursor = LoadCursor(NULL, IDC_ARROW);
    wndclass.hbrBackground = (HBRUSH)GetStockObject(BLACK_BRUSH);
    wndclass.lpszMenuName = 0;
    wndclass.lpszClassName = "ChildWindow";
    wndclass.hIconSm = LoadIcon(hInstance, "Chip");
 
 
 return RegisterClassEx(&wndclass);
}


 /* Initialize the Window */
 HWND InitClass(HINSTANCE hInt, int Show)
{
    
   return CreateWindow("MdiFrame", "80x86 Assembly PC Developer's Guide",WS_OVERLAPPEDWINDOW,
                        CW_USEDEFAULT, CW_USEDEFAULT, CW_USEDEFAULT, CW_USEDEFAULT,
                        HWND_DESKTOP, NULL, hInt, &Show);
}


 LRESULT CALLBACK WndProc(HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam)
{
  static HINSTANCE hInstance;
  static HWND hwndClient;
  HWND hwndChild;
  CLIENTCREATESTRUCT clientstruct;
  MDICREATESTRUCT mdicreate;
  
  
  switch(msg)
  {
      case WM_CREATE:
                      hInstance = ((LPCREATESTRUCT) lParam)->hInstance;
                      clientstruct.hWindowMenu = NULL;
                      clientstruct.idFirstChild = 100;

                      hwndClient = CreateWindow("MDICLIENT", NULL, WS_CHILD | WS_CLIPCHILDREN |
                                   WS_VISIBLE, 0, 0, 0, 0,hwnd, (HMENU) 1, hInstance,
                                   (LPSTR)&clientstruct);
                      DialogBox(hInstance, "AboutBox", hwnd, AboutProc);
                      
                      
                      return 0;
                      
      case WM_COMMAND: switch(LOWORD(wParam))
                        {
                            case IDM_CREDIT : DialogBox(hInstance, "CreditBox", hwnd, RegProc);
                                               DialogBox(hInstance, "CreditBox2", hwnd, RegProc);
                                               DialogBox(hInstance, "CreditBox3", hwnd, RegProc);
                                               DialogBox(hInstance, "CreditBox4", hwnd, RegProc);
                            return 0;

                            case IDM_ABOUT : DialogBox(hInstance, "AboutBox", hwnd, AboutProc);
                            return 0;

                            case IDM_CLOSE : hwndChild = (HWND)SendMessage(hwndClient,
                                                           WM_MDIGETACTIVE, 0, 0);
                                              if(SendMessage(hwndChild, WM_QUERYENDSESSION, 0, 0))
                                                    SendMessage(hwndClient, WM_MDIDESTROY, (WPARAM) hwndChild, 0);

                            return 0;

                            case IDM_TILE:
                             SendMessage(hwndClient, WM_MDITILE, 0, 0);
                             return 0;

                            case IDM_CASCADE :
                              SendMessage(hwndClient, WM_MDICASCADE, 0, 0);
                              return 0;

                            case IDM_ARRANGE:
                              SendMessage(hwndClient, WM_MDIICONARRANGE, 0, 0);
                              return 0;

                            case IDM_CLOSEALL :
                              EnumChildWindows(hwndClient, &CloseEnumProc, 0);
                              return 0;
                              
                            
                           default:

                             if(LOWORD(wParam) >= IDM_EAX  && LOWORD(wParam) <= IDM_RESET  )
                             {

                                mdicreate.szClass = "ChildWindow";
                                mdicreate.szTitle = Title[LOWORD(wParam)];
                                mdicreate.hOwner = hInstance;
                                mdicreate.x = CW_USEDEFAULT;
                                mdicreate.y = CW_USEDEFAULT;
                                mdicreate.cx = CW_USEDEFAULT;
                                mdicreate.cy = CW_USEDEFAULT;
                                mdicreate.style = WS_HSCROLL | WS_VSCROLL;
                                strcpy(Pass.Name, Title[LOWORD(wParam)]);
                                strcpy(Pass.File, Files[LOWORD(wParam)]);
                                mdicreate.lParam = 0;
                          
                              SendMessage(hwndClient, WM_MDICREATE, 0, (LPARAM) (LPMDICREATESTRUCT) &mdicreate);
                              return 0;

                             }
                             else
                             {

                              hwndChild = (HWND)SendMessage(hwndClient, WM_MDIGETACTIVE, 0, 0);

                              if(IsWindow(hwndChild))
                                 SendMessage(hwndChild, WM_COMMAND, wParam, lParam);
                             }
                             
                        }
                        break;
      case WM_QUERYENDSESSION :
      case WM_CLOSE:
        SendMessage(hwnd, WM_COMMAND, IDM_CLOSEALL, 0);

        if(NULL != GetWindow(hwndClient, GW_CHILD))
          return 0;

        break;
        
      case WM_DESTROY :  PostQuitMessage(0);
                       return 0;

         
  }

  return DefFrameProc(hwnd, hwndClient, msg, wParam, lParam);
}



 /* About Dialog Box */
 BOOL CALLBACK AboutProc(HWND hDlg, UINT Msg, WPARAM wParam, LPARAM lParam)
{
    HDC hdc;
    PAINTSTRUCT ps;
    static HBITMAP bitmap;
    static HDC hBitmap;
        
    switch (Msg)
    {
        case WM_INITDIALOG:
                           bitmap =LoadBitmap(g_hInstance, "AsmGB");
                           hBitmap = CreateCompatibleDC(NULL);
                           SelectObject(hBitmap, bitmap);

                           return TRUE;
                            
        case WM_COMMAND :
                   switch(LOWORD(wParam))
                   {
                       case IDOK:
                       case IDCANCEL:
                                      EndDialog (hDlg, 0);
                                      return TRUE;
                   }

                   break;
        case WM_PAINT:
            hdc = BeginPaint(hDlg, &ps);
            
            BitBlt(hdc, 83, 25, 150, 94, hBitmap, 0, 0,  SRCCOPY);

            EndPaint(hdc, &ps);
             
        return TRUE;

        case WM_CLOSE:
        
            DeleteDC(hBitmap);
            DeleteObject(bitmap);
            
    }

    return FALSE;

}


 BOOL CALLBACK RegProc(HWND hDlg, UINT Msg, WPARAM wParam, LPARAM lParam)
{
        
    switch (Msg)
    {
        case WM_INITDIALOG:

                           return TRUE;
                            
        case WM_COMMAND :
                   switch(LOWORD(wParam))
                   {
                       case IDOK:
                       case IDCANCEL:
                                      EndDialog (hDlg, 0);
                                      return TRUE;
                   }

                   break;
           
    }

    return FALSE;

}


 /* Close all windows proc */
 BOOL CALLBACK CloseEnumProc(HWND hwnd, LPARAM lParam)
{
    if(GetWindow(hwnd, GW_OWNER))
      return 1;

   if(!SendMessage(GetParent(hwnd), WM_QUERYENDSESSION, 0, 0))
     return 1;

   SendMessage(GetParent(hwnd), WM_MDIDESTROY, (WPARAM) hwnd, 0);

   return 1;

}


 /* Child Window Class */
 LRESULT CALLBACK ChildProc(HWND hwnd, UINT Msg, WPARAM wParam, LPARAM lParam)
{
   int Index1, Index2, y, x, Begin, End;
   char Temp;
   FILE *TheFile;
   static HWND hwndClient, hwndFrame;
   PAINTSTRUCT ps ;
   TEXTMETRIC  tm ;
   HDC hdc;
   WINDOW *Window;
   
    switch(Msg)
    {
        case WM_CREATE:

           
           SetWindowLong(hwnd, 0, (long)0);
           
           if(!(Window = (WINDOW *)malloc(sizeof(WINDOW))))
           {
               MessageBox(hwnd, "Out Of Memory", Pass.Name, MB_OK | MB_ICONEXCLAMATION);
               DestroyWindow(hwnd);
               return 0;
           }

           Window->TextPhile = 0;
           
           SetWindowLong(hwnd, 0, (long)Window);
           
           strcpy(Window->WindowTitle, Pass.Name);   
            
           /* Open File */
           if(!(TheFile = fopen(Pass.File, "r")))
           {
               MessageBox(hwnd, "File Not Found", Window->WindowTitle, MB_OK | MB_ICONEXCLAMATION);
               DestroyWindow(hwnd);
               return 0;
           }
           
           /* Allocate Memory */
           if(!(Window->TextPhile = (char **)malloc(sizeof(char *))))
           {
               MessageBox(hwnd, "Out Of Memory", Window->WindowTitle, MB_OK | MB_ICONEXCLAMATION);
               DestroyWindow(hwnd);
               return 0;
           }
           
           Window->TextPhile[0] = NULL;
           Index2 = Index1 = 0;
           Window->MaxWidth = 0;
           
           
           /* Read In File */
           while(!feof(TheFile))
           {
               Temp = fgetc(TheFile);
               
               if(Temp == '\n' || Temp == (char)EOF)
               {
                   if(Window->TextPhile[Index1])
                   {
                      if(Index2 > Window->MaxWidth)
                         Window->MaxWidth = Index2;
                         
                       Index2 = 0;
                       Index1++;

                       if(!(Window->TextPhile = (char **)realloc(Window->TextPhile, sizeof(char *)*(Index1 + 1))))
                       {
                         MessageBox(hwnd, "Out Of Memory", Window->WindowTitle, MB_OK | MB_ICONEXCLAMATION);
                         DestroyWindow(hwnd);
                         return 0;
                       }
                      
                       Window->TextPhile[Index1] = 0;
                   }
                   else
                   {
                       if(!(Window->TextPhile[Index1] = (char *)malloc(1)))
                       {
                         MessageBox(hwnd, "Out Of Memory", Window->WindowTitle, MB_OK | MB_ICONEXCLAMATION);
                         DestroyWindow(hwnd);
                         return 0;
                       }

                       
                       Window->TextPhile[Index1][0] = 0;
                       
                       Index1++;

                       if(!(Window->TextPhile = (char **)realloc(Window->TextPhile, sizeof(char *)*(Index1 + 1))))
                       {
                         MessageBox(hwnd, "Out Of Memory", Window->WindowTitle, MB_OK | MB_ICONEXCLAMATION);
                         DestroyWindow(hwnd);
                         return 0;
                       }
                       
                       Window->TextPhile[Index1] = 0;

                   }
                      
               }
               else
               {
                   if(!Window->TextPhile[Index1])
                   {
                       if(Temp == '\t')
                       {
                       
                         if(!(Window->TextPhile[Index1] = (char *)malloc(Index2 + 6)))
                         {
                           MessageBox(hwnd, "Out Of Memory", Window->WindowTitle, MB_OK | MB_ICONEXCLAMATION);
                           DestroyWindow(hwnd);
                           return 0;
                         }
                       

                       memset(Window->TextPhile[Index1] + Index2, ' ', 5);
                       Index2+=5;
                        
                       
                       Window->TextPhile[Index1][Index2] = 0;
                      }
                      else
                      {
                          
                        if(!(Window->TextPhile[Index1] = (char *)malloc(Index2 + 2)))
                        {
                          MessageBox(hwnd, "Out Of Memory", Window->WindowTitle, MB_OK | MB_ICONEXCLAMATION);
                          DestroyWindow(hwnd);
                          return 0;
                        }
                        
                        Window->TextPhile[Index1][Index2] = Temp;
                        Index2++;
                        Window->TextPhile[Index1][Index2] = 0;
                      }

                   }
                   else
                   {
                       if(Temp == '\t')
                       {
                       
                       
                         if(!(Window->TextPhile[Index1] = (char *)realloc(Window->TextPhile[Index1], Index2 + 6)))
                         {
                           MessageBox(hwnd, "Out Of Memory", Window->WindowTitle, MB_OK | MB_ICONEXCLAMATION);
                           DestroyWindow(hwnd);
                           return 0;
                         }
                       
                         memset(Window->TextPhile[Index1] + Index2, ' ', 5);
                         Index2+=5;
                         Window->TextPhile[Index1][Index2] = 0;
                       }
                       else
                       {


                          if(!(Window->TextPhile[Index1] = (char *)realloc(Window->TextPhile[Index1], Index2 + 6)))
                          {
                             MessageBox(hwnd, "Out Of Memory", Window->WindowTitle, MB_OK | MB_ICONEXCLAMATION);
                             DestroyWindow(hwnd);
                             return 0;
                          }
                        
                          Window->TextPhile[Index1][Index2] = Temp;
                          Index2++;
                          Window->TextPhile[Index1][Index2] = 0;

                       }


                       
                   }
               }

           }

           

            
           Window->MaxLines = Index1;
           
           hwndClient = GetParent(hwnd);
           hwndFrame = GetParent(hwndClient);

           hdc = GetDC (hwnd) ;

           GetTextMetrics (hdc, &tm) ;
           Window->cxChar = tm.tmAveCharWidth ;
           Window->cxCaps = (tm.tmPitchAndFamily & 1 ? 3 : 2) * Window->cxChar / 2 ;
           Window->cyChar = tm.tmHeight + tm.tmExternalLeading ;
           
           ReleaseDC (hwnd, hdc) ;

           SetScrollRange (hwnd, SB_HORZ, 0, Window->MaxWidth, FALSE) ;
           SetScrollPos   (hwnd, SB_HORZ, Window->iHscrollPos, TRUE) ;
 
           Window->iMaxWidth = Window->MaxWidth*Window->cxChar + 22 * Window->cxCaps;

           
           
           fclose(TheFile);
           
          return 0;
        case WM_PAINT:
           hdc = BeginPaint(hwnd, &ps);

           Window = (WINDOW *)GetWindowLong(hwnd, 0);
           SelectObject(hdc, GetStockObject(SYSTEM_FIXED_FONT));
           
           SetTextColor(hdc, 0xFFFFFF);
           SetBkMode(hdc, TRANSPARENT); 
           Begin = max(0, Window->iVscrollPos + ps.rcPaint.top/ Window->cyChar - 1);
           End = min(Window->MaxLines, Window->iVscrollPos + ps.rcPaint.bottom/ Window->cyChar);
           
           for(Index1 = Begin; Index1 < End; Index1++)
           {
               y = (Window->cyChar * (1 - Window->iVscrollPos +  Index1));
               x = (Window->cxChar * (1 - Window->iHscrollPos));
               
               TextOut( hdc, x, y, Window->TextPhile[Index1], strlen(Window->TextPhile[Index1]));
           }

           EndPaint(hdc, &ps);

           
           return 0;

        case WM_SIZE:
          Window = (WINDOW *)GetWindowLong(hwnd, 0);
          Window->cyClient = HIWORD(lParam);
          Window->cxClient = LOWORD(lParam);

          Window->iVscrollMax = max(0, Window->MaxLines + 2 - Window->cyClient / Window->cyChar);
          Window->iVscrollPos = min(Window->iVscrollPos, Window->iVscrollMax);

          SetScrollRange(hwnd, SB_VERT, 0, Window->iVscrollMax, FALSE);
          SetScrollPos(hwnd, SB_VERT, Window->iVscrollPos, TRUE);

          Window->iHscrollMax = max(0, 2 + (Window->iMaxWidth - Window->cxClient)/ Window->cxChar);
          Window->iHscrollPos = min(Window->iHscrollPos, Window->iHscrollMax);

          SetScrollRange(hwnd, SB_HORZ, 0, Window->iHscrollMax, FALSE);
          SetScrollPos(hwnd, SB_HORZ, Window->iHscrollPos, TRUE);
          InvalidateRect(hwnd, NULL, TRUE);
          UpdateWindow(hwnd);
          break;
          
        case WM_VSCROLL:
             Window = (WINDOW *)GetWindowLong(hwnd, 0);
             switch (LOWORD(wParam))
                {
                    case SB_TOP:
                          Window->iVscrollInc = -Window->iVscrollPos;
                          break;
                    case SB_BOTTOM:
                          Window->iVscrollInc = Window->iVscrollMax - Window->iVscrollPos;
                          break;
                    case SB_LINEUP:
                         Window->iVscrollInc = -1;
                         break;
                    case SB_LINEDOWN:
                         Window->iVscrollInc =1;
                         break;
                    case SB_PAGEUP :
                         Window->iVscrollInc = min(-1, -Window->cyClient /Window->cyChar);
                         break;
                    case SB_PAGEDOWN:
                         Window->iVscrollInc = max(1, Window->cyClient/Window->cyChar);
                         break;
                    case SB_THUMBTRACK:
                    case SB_THUMBPOSITION:
                         Window->iVscrollInc = HIWORD(wParam) - Window->iVscrollPos;
                         break;

                    default :
                         Window->iVscrollInc = 0;
                         break;
                }

                Window->iVscrollInc = max(-Window->iVscrollPos,
                            min(Window->iVscrollInc, Window->iVscrollMax - Window->iVscrollPos));

                if(Window->iVscrollInc != 0)
                 {
                     Window->iVscrollPos += Window->iVscrollInc;
                     ScrollWindow(hwnd, 0, -Window->cyChar * Window->iVscrollInc, NULL, NULL);
                     SetScrollPos(hwnd, SB_VERT, Window->iVscrollPos, TRUE);
                     UpdateWindow(hwnd);
                 }
               return 0;
               
        case WM_HSCROLL:
         Window = (WINDOW *)GetWindowLong(hwnd, 0);
             switch (LOWORD(wParam))
                {
                    case SB_TOP:
                          Window->iHscrollInc = -Window->iHscrollPos;
                          break;
                    case SB_BOTTOM:
                          Window->iHscrollInc = Window->iHscrollMax - Window->iHscrollPos;
                          break;
                    case SB_LINEUP:
                         Window->iHscrollInc = -1;
                         break;
                    case SB_LINEDOWN:
                         Window->iHscrollInc = 1;
                         break;
                    case SB_PAGEUP :
                         Window->iHscrollInc = min(-1, -Window->cxClient /Window->cxChar);
                         break;
                    case SB_PAGEDOWN:
                        Window->iHscrollInc = max(1, Window->cxClient/Window->cxChar);
                         break;
                         
                    case SB_THUMBTRACK:
                    case SB_THUMBPOSITION:
                         Window->iHscrollInc = HIWORD(wParam) - Window->iHscrollPos;
                         break;

                    default :
                         Window->iHscrollInc = 0;
                         break;
                }

                Window->iHscrollInc = max(-Window->iHscrollPos,
                       min(Window->iHscrollInc, Window->iHscrollMax - Window->iHscrollPos));

                if(Window->iHscrollInc != 0)
                 {
                     Window->iHscrollPos += Window->iHscrollInc;
                     ScrollWindow(hwnd, -Window->cxChar * Window->iHscrollInc, 0, NULL, NULL);
                     SetScrollPos(hwnd, SB_HORZ, Window->iHscrollPos, TRUE);
                     UpdateWindow(hwnd);
                 }
               return 0;
                    
        case WM_MDIACTIVATE:

           SendMessage(hwndClient, WM_MDISETMENU, (WPARAM)hMenu, (LPARAM)hMenuSub);
           DrawMenuBar(hwndFrame);
        return 0;
        
        case WM_QUERYENDSESSION:
        case WM_CLOSE:
          Window = (WINDOW *)GetWindowLong(hwnd, 0);
          if(IDOK != MessageBox(hwnd, "Close Window?", Window->WindowTitle, MB_OKCANCEL| MB_ICONQUESTION))
            return 0;
          break;
          
        case WM_DESTROY:
        
         Window = (WINDOW *)GetWindowLong(hwnd, 0);
         if(Window)
         {
             if(Window->TextPhile)
             {
                for(Index1 = 0; Index1 < Window->MaxLines; Index1++)
                  free(Window->TextPhile[Index1]);

               free(Window->TextPhile);
             }

         free(Window);
         }

         
         return 0;
          
    }


    return DefMDIChildProc(hwnd, Msg, wParam, lParam);
}
