;-=-=-=-=-=-=-=-=-=-=-
; Toby Opferman
; _Secret/Scrat
; 3D Wire Frame Cube
; http://www.opferman.com
; programming@opferman.com
;
; ** This Program Requires a Math CO-Processor **
; ** No Bounds Checking, Don't Go Off Screen **
; ** X, Y, Z Rotation, +/- Scaling **
;
; Program uses World Positioning 0 , 0, 300
; and Camera View of 0, 0, 0  and 0, 0, 0 degrees
;-=-=-=-=-=-=-=-=-=-=-



.MODEL TINY

.386

.CODE
 ORG 100h
START:
 MOV AL, 13h
 INT 10h                        ; Set Mode 13h

 ROTATE:
   XOR EAX, EAX
   PUSH DS
   POP ES
   MOV DI, Offset Buffer
   MOV ECX, 16000
   REP STOSD                    ; Clear Double Buffer

   XOR AX, AX

   CMP RY, AL
   JZ SHORT R2
   CALL ROTATEY                 ; Rotate On Y Axis

R2:
   CMP RX, AL
   JZ SHORT R3
   CALL ROTATEX                 ; Rotate On X Axis

R3:
   CMP RZ, AL
   JZ SHORT R4
   CALL ROTATEZ                 ; Rotate On Z Axis

R4:
   MOV SI, OFFSET Face1         ; Start at Face 1
   MOV ECX, 6                   ; Loop Through The 6 Faces
   PLOT:

    PUSH ECX
    MOV ECX, 3                  ; Save CX and Plot 3 Lines
    LINEPLOT:
      PUSH ECX
      MOV BL, CL
      NEG BL
      ADD BL, 3                 ; Convert CL (3-0) Into (0-3)
      XOR BH, BH

      MOV AL, DS:[SI + BX]      ; Get Point 1
      CALL PROJECT1

      MOV AL, DS:[SI + BX + 1]  ; Get Point 2
      CALL PROJECT2

      CALL LINE                 ; Draw Line

      POP ECX
    LOOP SHORT LINEPLOT

    POP ECX
    MOV AL, DS:[SI]             ; Get First Point
    CALL PROJECT1               

    CALL LINE                   ; Plot Last Line

    ADD SI, 4                   ; Next Face
   LOOP SHORT PLOT


   MOV SI, Offset Buffer
   XOR DI, DI
   PUSH 0A000h
   POP ES
   MOV ECX, 16000
   REP MOVSD                    ; Update Video Screen

   MOV AH, 1                    ; Check Key Press
   INT 16h
 JNZ SHORT GETKEY               ; No Key Press? Continue
 JMP ROTATE

GETKEY:
 XOR AH, AH                     ; Get Key
 INT 16h
 CALL KEYS

 TEST BX, BX
 JNZ SHORT FINISH
 JMP ROTATE

FINISH:
 MOV AX, 3                      ; Return To Text Mode
 INT 10h
 RET

;-=-=-=-=-=-=-=-=-=-
; Keys
;  Tests Keyboard Input
;-=-=-=-=-=-=-=-=-=-
KEYS PROC
 XOR BX, BX
 CMP AH, 45                     ; Scan Code For X
 JNE SHORT N1
 NOT RX                         ; Set Rotation Of X
N1:
 CMP AH, 21                     ; Scan Code For Y
 JNE SHORT N2
 NOT RY                         ; Set Rotation Of Y
N2:
 CMP AH, 44                     ; Scan Code For Z
 JNE SHORT N3
 NOT RZ                         ; Set Rotation Of Z
N3:
 CMP AH, 1                      ; Scan Code For Escape
 JNE SHORT N4
 NOT BX                         ; Set Quit
N4:
 CMP AH, 13                     ; Scale UP
 JNE SHORT N5
 CALL SCALEUP
N5:
 CMP AH, 12                      ; Scale Down
 JNE SHORT N6
 CALL SCALEDOWN
N6:
 RET
ENDP KEYS

;-=-=-=-=-=-=-=-=-
; Scale Up
;-=-=-=-=-=-=-=-=-
SCALEUP PROC
 PUSHA                                  ; Save Registers
 MOV SI, Offset X                       ; Get X, Y, Z Varibles
 MOV DI, Offset Y
 MOV BX, Offset Z

 MOV ECX, 8                             ; Do All 8 Points
 SKUP:
   FLD DWORD PTR [SI]                   ; Scale X
   FMUL ScaleFactor
   FSTP DWORD PTR [SI]

   FLD DWORD PTR [DI]                   ; Scale Y
   FMUL ScaleFactor
   FSTP DWORD PTR [DI]

   FLD DWORD PTR [BX]                   ; Scale Z
   FMUL ScaleFactor
   FSTP DWORD PTR [BX]
        
   ADD SI, 4                            ; Next Point
   ADD DI, 4
   ADD BX, 4
 LOOP SHORT SKUP                        ; Loop Back
 POPA                                   ; Restore Registers
 RET
ENDP SCALEUP


;-=-=-=-=-=-=-=-=-
; Scale Down
;-=-=-=-=-=-=-=-=-
SCALEDOWN PROC
 PUSHA                                  ; Save Registers
 MOV SI, Offset X                       ; Get X, Y, Z Varibles
 MOV DI, Offset Y
 MOV BX, Offset Z

 MOV ECX, 8                             ; Do All 8 Points
 SKDN:
   FLD DWORD PTR [SI]                   ; Scale X
   FDIV ScaleFactor
   FSTP DWORD PTR [SI]

   FLD DWORD PTR [DI]                   ; Scale Y
   FDIV ScaleFactor
   FSTP DWORD PTR [DI]

   FLD DWORD PTR [BX]                   ; Scale Z
   FDIV ScaleFactor
   FSTP DWORD PTR [BX]
        
   ADD SI, 4                            ; Next Point
   ADD DI, 4
   ADD BX, 4
 LOOP SHORT SKDN                        ; Loop Back
 POPA                                   ; Restore Registers
 RET
ENDP SCALEDOWN



;-=-=-=-=-=-=-=-=-=-
; Line Drawing Procedure
; Draws a Line From
;  (TempX, TempY) To (TempX2, TempY2)
;-=-=-=-=-=-=-=-=-=-
LINE PROC
 PUSHA
  MOV DI, OFFSET Buffer                 ; DI = Buffer + X + Y*320
  ADD DI, TempX                         ; Setting Up Starting Point
  MOV AX, TempY
  SHL AX, 6
  ADD DI, AX
  SHL AX, 2
  ADD DI, AX

  XOR AX, AX
  MOV Error, AX

  MOV AX, TempX2                        ; Set Delta X
  SUB AX, TempX
  MOV DeltaX, AX

  MOV AX, TempY2                        ; Set Delta Y
  SUB AX, TempY
  MOV DeltaY, AX

  MOV AX, 1                             ; Set X_INC To 1
  MOV X_INC, AX
  MOV AX, 320                           ; Set Y_INC To 320
  MOV Y_INC, AX

  XOR AX, AX                            ; Test Delta X Against 0
  CMP DeltaX, AX
  JGE SHORT SKIP1
  NEG X_INC                             ; Negate Them
  NEG DeltaX

  SKIP1:
  CMP DeltaY, AX                        ; Test DeltaY Against Zero
  JGE SHORT SKIP2
  NEG Y_INC                             ; Negate Them
  NEG DeltaY

  SKIP2:
  MOV AX, DeltaY
  CMP DeltaX, AX                        ; DeltaX > DeltaY?
  JLE SHORT ELSE1
  MOV CX, DeltaX                        ; Loop DeltaX Times
  INC CX
  THEN:
    DEC CX
    MOV BYTE PTR [DI], 1                ; Set Color

    MOV AX, DeltaY                      ; Set Error
    ADD Error, AX
    MOV AX, Error

    CMP AX, DeltaX                      ; Error>DeltaX
    JLE SHORT AGAIN
     SUB AX, DeltaX                     ; Error -= DeltaX
     MOV Error, AX
     ADD DI, Y_INC                      ; DI += Y_INC

    AGAIN:
    ADD DI, X_INC                       ; DI += X_INC
    TEST CX, CX                         ; Loop Back
    JNZ SHORT THEN

    JMP SHORT DONE_LINE
  ELSE1:
  MOV CX, DeltaY                        ; Loop DeltaY Times
  INC CX
  ELSE_LOOP:
    DEC CX
    MOV BYTE PTR [DI], 1                ; Set Color

    MOV AX, DeltaX                      ; Set Error
    ADD Error, AX
    MOV AX, Error

    CMP AX, 0                           ; Error>0
    JLE SHORT AGAIN2
     SUB AX, DeltaY                     ; Error -= DeltaY
     MOV Error, AX
     ADD DI, X_INC                      ; DI += X_INC

    AGAIN2:
    ADD DI, Y_INC                       ; DI += Y_INC
    TEST CX, CX                         ; Loop Back
    JNZ SHORT ELSE_LOOP

  DONE_LINE:
 POPA
 RET
ENDP LINE


;-=-=-=-=-=-=-=-=-=-=-
; Rotates All Points
; Around X Axis
;-=-=-=-=-=-=-=-=-=-=-
ROTATEX PROC
 PUSHA                                  ; Save Registers
 MOV SI, Offset Y                       ; Get Y And Z Varibles
 MOV DI, Offset Z

 MOV ECX, 8                             ; Do All 8 Points
 ROTX:
   FLD DWORD PTR [SI]                   ; Y = Y*COS-Z*SIN
   FMUL COSAngle
   FSTP Temp1

   FLD DWORD PTR [DI]
   FMUL SINAngle
   FSTP Temp2
   FLD Temp1
   FSUB Temp2
   FSTP Temp1                           ; Temporay Storage
      
   FLD DWORD PTR [DI]                   ; Z = Y*SIN+Z*COS
   FMUL COSAngle
   FSTP Temp2
   FLD DWORD PTR [SI]
   FMUL SINAngle
   FADD Temp2
   FSTP DWORD PTR [DI]                  ; Store Z

   FLD Temp1                            ; Store Y
   FSTP DWORD PTR [SI]

        
   ADD SI, 4                            ; Next Point
   ADD DI, 4
 LOOP SHORT ROTX                        ; Loop Back
 POPA                                   ; Restore Registers
 RET
ENDP ROTATEX 

;=-=-=-=-=-=-=-=-=-=-=-
; Rotates All Points
; Around Y Axis
;-=-=-=-=-=-=-=-=-=-=-=
ROTATEY PROC
 PUSHA                                  ; Save Registers
 MOV SI, Offset X                       ; Get X And Z Varibles
 MOV DI, Offset Z

 MOV ECX, 8                             ; Do All 8 Points
 ROTY:
   FLD DWORD PTR [SI]                   ; X = X*COS-Z*SIN
   FMUL COSAngle
   FSTP Temp1

   FLD DWORD PTR [DI]
   FMUL SINAngle
   FSTP Temp2
   FLD Temp1
   FSUB Temp2
   FSTP Temp1                           ; Temporay Storage

   
   FLD DWORD PTR [DI]                   ; Z = X*SIN+Z*COS
   FMUL COSAngle
   FSTP Temp2
   FLD DWORD PTR [SI]
   FMUL SINAngle
   FADD Temp2
   FSTP DWORD PTR [DI]                  ; Store Z

   FLD Temp1                            ; Store X
   FSTP DWORD PTR [SI]

        
   ADD SI, 4                            ; Next Point
   ADD DI, 4
 LOOP SHORT ROTY                        ; Loop Back
 POPA                                   ; Restore Registers
 RET
ENDP ROTATEY

;-=-=-=-=-=-=-=-=-=-=-=-
; Rotates All Points
; Around Z Axis
;=-=-=-=-=-=-=-=-=-=-=-=
ROTATEZ PROC
 PUSHA                                  ; Save Registers
 MOV SI, Offset X                       ; Get X And Y Varibles
 MOV DI, Offset Y

 MOV ECX, 8                             ; Do All 8 Points
 ROTZ:
   FLD DWORD PTR [SI]                   ; X = X*COS-Y*SIN
   FMUL COSAngle
   FSTP Temp1

   FLD DWORD PTR [DI]
   FMUL SINAngle
   FSTP Temp2
   FLD Temp1
   FSUB Temp2
   FSTP Temp1                           ; Temporay Storage

   
   FLD DWORD PTR [DI]                   ; Y = X*SIN+Y*COS
   FMUL COSAngle
   FSTP Temp2
   FLD DWORD PTR [SI]
   FMUL SINAngle
   FADD Temp2
   FSTP DWORD PTR [DI]                  ; Store Y

   FLD Temp1                            ; Store X
   FSTP DWORD PTR [SI]

        
   ADD SI, 4                            ; Next Point
   ADD DI, 4
 LOOP SHORT ROTZ                        ; Loop Back
 POPA                                   ; Restore Registers
 RET
ENDP ROTATEZ

;-=-=-=-=-=-=-=-=-=-=-=-
; Projects 3D to 2D
; In TempX, TempY
;-=-=-=-=-=-=-=-=-=-=-=-
PROJECT1 PROC
 PUSHA                          ; Save Regsiters
  XOR DX, DX
  XOR AH, AH                    ; Set AX To Index*4
  MOV BL, 4
  MUL BL                        ; To Get Correct Offset
  MOV Off, AX

  MOV SI, OFFSET X
  ADD SI, Off

                                ; TempX =
  FLD DWORD PTR [SI]            ; X*VIEW/Z + Half Width
  FMUL VIEW
  FSTP TEMP1
  MOV SI, OFFSET Z
  ADD SI, Off
  FLD DWORD PTR [SI]
  FADD WORLDZ
  FSTP TEMP2
  FLD TEMP1
  FDIV TEMP2
  FADD HALFW
  FISTP TEMP1                   ; Store in TempX
  MOV AX, Word Ptr Temp1
  MOV TempX, AX

  MOV SI, OFFSET Y               ; TempY =
  ADD SI, Off                    ; Half Height - Y*VIEW/Z
  FLD DWORD PTR [SI]
  FMUL VIEW
  FSTP TEMP1
  MOV SI, OFFSET Z
  ADD SI, Off
  FLD DWORD PTR [SI]
  FADD WORLDZ
  FSTP TEMP2
  FLD TEMP1
  FDIV TEMP2
  FSTP TEMP1
  FLD HALFH
  FSUB TEMP1
  FISTP TEMP1
  MOV AX, Word Ptr Temp1
  MOV TempY, AX

 POPA                            ; Restore Registers
 RET
ENDP PROJECT1

;-=-=-=-=-=-=-=-=-=-=-=-
; Projects 3D to 2D
; In TempX2, TempY2
;-=-=-=-=-=-=-=-=-=-=-=-
PROJECT2 PROC
 PUSHA                          ; Save Regsiters
  XOR DX, DX
  XOR AH, AH                    ; Set AX To Index*4
  MOV BL, 4
  MUL BL                        ; To Get Correct Offset
  MOV Off, AX
  MOV SI, OFFSET X
  ADD SI, Off

                                ; TempX =
  FLD DWORD PTR [SI]            ; X*VIEW/Z + Half Width
  FMUL VIEW
  FSTP TEMP1
  MOV SI, OFFSET Z
  ADD SI, Off
  FLD DWORD PTR [SI]
  FADD WORLDZ
  FSTP TEMP2
  FLD TEMP1
  FDIV TEMP2
  FADD HALFW
  FISTP TEMP1                   ; Store in TempX2
  MOV AX, Word Ptr Temp1
  MOV TempX2, AX

  MOV SI, OFFSET Y               ; TempY =
  ADD SI, Off                    ; Half Height - Y*VIEW/Z
  FLD DWORD PTR [SI]
  FMUL VIEW
  FSTP TEMP1
  MOV SI, OFFSET Z
  ADD SI, Off
  FLD DWORD PTR [SI]
  FADD WORLDZ
  FSTP TEMP2
  FLD TEMP1
  FDIV TEMP2
  FSTP TEMP1
  FLD HALFH
  FSUB TEMP1
  FISTP TEMP1
  MOV AX, Word Ptr Temp1
  MOV TempY2, AX

 POPA                            ; Restore Registers
 RET
ENDP PROJECT2

.DATA

 ; The Vertices
 X dd 35.0, -35.0, -35.0,  35.0,  35.0,  35.0, -35.0, -35.0
 Y dd 35.0,  35.0, -35.0, -35.0,  35.0, -35.0, -35.0,  35.0
 Z dd 35.0,  35.0,  35.0,  35.0, -35.0, -35.0, -35.0, -35.0


 ; The Sides of the Cube
 Face1 db 0, 1, 2, 3
 Face2 db 4, 5, 6, 7
 Face3 db 0, 4, 7, 1
 Face4 db 3, 5, 6, 2
 Face5 db 0, 3, 5, 4
 Face6 db 1, 2, 6, 7

 ; To Change The Angle, Just Punch
 ; COS(x) and SIN(x)
 ; Then put the Numbers Down Here
 ; Angle = 1 

 ; The COS(1) Angle Used
 COSAngle dd 0.9998476952

 ; The SIN(1) Angle Used
 SINAngle dd 0.0174524064

 ; The Rotation Status
 RX db 0
 RY db 0
 RZ db 0

 ; Scaling Factor
 ScaleFactor dd 1.2

 ; Screen Variables & View Distance
 HALFW    dd 160.0
 HALFH    dd 100.0
 VIEW     dd 256.0
 WORLDZ   dd 300.0

 ; Temporary Storage For Floats
 Temp1     dd  ?
 Temp2     dd  ?
 Off       dw  ?

 ; The Variables Used As Screen Coordinates
 TempX    dw  ?
 TempY    dw  ?
 TempX2   dw  ?
 TempY2   dw  ?

 ; Line Algorithm Variables
 DeltaX  dw  ?
 DeltaY  dw  ?
 Y_INC   dw  ?
 X_INC   dw  ?
 Error   dw  ?


 ; The Double Buffer
 Buffer db 64000 DUP(?)

END START
