/***************************************************************************** 
 *                            Example Bot                                    *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *    Copyright (c)2001-2005      Toby Opferman                              *
 *****************************************************************************/

#define _CRT_SECURE_NO_DEPRECATE

#include <windows.h>
#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <conio.h>
#include <shlwapi.h>
#include <dtl.h>
#include <irc2.h>


/*******************************************************************************
 * Internal Prototypes                                                         *
 *******************************************************************************/

 void Console_EmptyMessage(PVOID pContext, PIRC_EVENT_STRUC pIrcEventStruc);
 void Console_Disconnect(PVOID pContext, PIRC_EVENT_STRUC pIrcEventStruc);
 void Console_JoinChannel(PVOID pContext, PIRC_EVENT_STRUC pIrcEventStruc);
 void Console_PartChannel(PVOID pContext, PIRC_EVENT_STRUC pIrcEventStruc);
 void Console_QuitIrc(PVOID pContext, PIRC_EVENT_STRUC pIrcEventStruc);
 void Console_ChangeNick(PVOID pContext, PIRC_EVENT_STRUC pIrcEventStruc);
 void Console_ChannelTopic(PVOID pContext, PIRC_EVENT_STRUC pIrcEventStruc);
 void Console_Kick(PVOID pContext, PIRC_EVENT_STRUC pIrcEventStruc);
 void Console_PrivMessage(PVOID pContext, PIRC_EVENT_STRUC pIrcEventStruc);
 void Console_Notice(PVOID pContext, PIRC_EVENT_STRUC pIrcEventStruc);
 void Console_Ping(PVOID pContext, PIRC_EVENT_STRUC pIrcEventStruc);
 void Console_NoticeCtcp(PVOID pContext, PIRC_EVENT_STRUC pIrcEventStruc);
 void Console_PrivMessageCtcp(PVOID pContext, PIRC_EVENT_STRUC pIrcEventStruc);
 void Console_NumericEvent(PVOID pContext, PIRC_EVENT_STRUC pIrcEventStruc);
 void Console_Connect(PVOID pContext, PIRC_EVENT_STRUC pIrcEventStruc);

BOOL WINAPI ControlHandlerRoutine(DWORD dwCtrlType);
void ConsoleRunIrc(char *pszServer, unsigned short usPort, char *pszNickName, char *pszChannel);


/*******************************************************************************
 * main                                                                        *
 *                                                                             *
 * DESCRIPTION: C Entry Point                                                  *
 *                                                                             *
 * INPUT                                                                       *
 *   Standard Parameters                                                       *
 *                                                                             *
 * OUTPUT                                                                      * 
 *   ErrorCode to OS                                                           *
 *                                                                             *
 *******************************************************************************/
int _cdecl main(int argc, char **argv)
{
	if(argc != 5)
	{
		printf("Usage:\n");
		printf("    bot <server> <port> <Nick Name> <Channel>\n");
	}
	else
	{
		ConsoleRunIrc(argv[1], (unsigned short)atoi(argv[2]), argv[3], argv[4]);
	}

	return 0;
}



/*******************************************************************************
 * ConsoleRunIrc                                                                        *
 *                                                                             *
 * DESCRIPTION: Loop that lets you type into the channel after connecting
                to the IRC Server                                              *
 *                                                                             *
 * INPUT                                                                       *
 *   Server, Port, Nickname, Channel to join                                                       *
 *                                                                             *
 * OUTPUT                                                                      * 
 *   None                                                           *
 *                                                                             *
 *******************************************************************************/
void ConsoleRunIrc(char *pszServer, unsigned short usPort, char *pszNickName, char *pszChannel)
{
    HIRC hIrc;
    IRC_USER IrcUser = {0};
    char String[500];
	EVENT_CALLBACKS EventCallbacks = {0};

	srand(time(0));

    strcpy(IrcUser.szNick, pszNickName);
    strcpy(IrcUser.szUserName, pszNickName);
    strcpy(IrcUser.szRealName, "Example Bot");
    strcpy(IrcUser.szServerName, pszServer);
    strcpy(IrcUser.szHostName, "localhost");

	IRC_SetCallback(&EventCallbacks, Console_EmptyMessage, IRC_EVENT_EMPTY_MESSAGE);
	IRC_SetCallback(&EventCallbacks, Console_Disconnect, IRC_EVENT_DISCONNECT);
	IRC_SetCallback(&EventCallbacks, Console_JoinChannel, IRC_EVENT_JOIN);
	IRC_SetCallback(&EventCallbacks, Console_PartChannel, IRC_EVENT_PART);
	IRC_SetCallback(&EventCallbacks, Console_QuitIrc, IRC_EVENT_QUIT);
	IRC_SetCallback(&EventCallbacks, Console_ChangeNick, IRC_EVENT_NICK);
	IRC_SetCallback(&EventCallbacks, Console_ChannelTopic, IRC_EVENT_TOPIC);
	IRC_SetCallback(&EventCallbacks, Console_Kick, IRC_EVENT_KICK);
	IRC_SetCallback(&EventCallbacks, Console_PrivMessage, IRC_EVENT_PRIVMSG);
	IRC_SetCallback(&EventCallbacks, Console_Notice, IRC_EVENT_NOTICE);
	IRC_SetCallback(&EventCallbacks, Console_Ping, IRC_EVENT_PING);
	IRC_SetCallback(&EventCallbacks, Console_NoticeCtcp, IRC_EVENT_NOTICE_CTCP);
	IRC_SetCallback(&EventCallbacks, Console_PrivMessageCtcp, IRC_EVENT_PRIVMSG_CTCP);
    IRC_SetCallback(&EventCallbacks, Console_NumericEvent, IRC_EVENT_NUMERIC);
    IRC_SetCallback(&EventCallbacks, Console_Connect, IRC_EVENT_CONNECT);

    if(hIrc = IRC_ConnectToServer(pszServer, usPort, &IrcUser, &EventCallbacks, pszChannel))
    {
        while(1) 
        {
           gets(String);
           IRC_MsgNick(hIrc, pszChannel, String);
        }
     }
     else
	 {
        printf("Error Connecting to IRC Server\n");
     }
}






/*******************************************************************************
 * Console_EmptyMessage                                                         *
 *                                                                             *
 * DESCRIPTION: Never called                                                 *
 *                                                                             *
 * INPUT                                                                       *
 *   User Context, IRC Event Structure                                         *
 *                                                                             *
 * OUTPUT                                                                      * 
 *   Nothing                                                                   *
 *                                                                             *
 *******************************************************************************/
 void Console_EmptyMessage(PVOID pContext, PIRC_EVENT_STRUC pIrcEventStruc)
 {
	 _asm int 3
 }
 

/*******************************************************************************
 * Console_Connect                                                             *
 *                                                                             *
 * DESCRIPTION: Called when connecting to IRC                                                  *
 *                                                                             *
 * INPUT                                                                       *
 *   User Context, IRC Event Structure                                         *
 *                                                                             *
 * OUTPUT                                                                      * 
 *   Nothing                                                                   *
 *                                                                             *
 *******************************************************************************/
 void Console_Connect(PVOID pContext, PIRC_EVENT_STRUC pIrcEventStruc)
 {     
    IRC_JoinChannel(pIrcEventStruc->hIrc, pContext);
    IRC_MsgChannel(pIrcEventStruc->hIrc, pContext, "y0");
 }

/*******************************************************************************
 * Console_Disconnect                                                         *
 *                                                                             *
 * DESCRIPTION: Called when disconnected from IRC                                                  *
 *                                                                             *
 * INPUT                                                                       *
 *   User Context, IRC Event Structure                                         *
 *                                                                             *
 * OUTPUT                                                                      * 
 *   Nothing                                                                   *
 *                                                                             *
 *******************************************************************************/
 void Console_Disconnect(PVOID pContext, PIRC_EVENT_STRUC pIrcEventStruc)
 {
	 printf("Disconnected From Server\n");
	 ExitProcess(0);
 }

/*******************************************************************************
 * Console_JoinChannel                                                         *
 *                                                                             *
 * DESCRIPTION: Called on channel join events                                                *
 *                                                                             *
 * INPUT                                                                       *
 *   User Context, IRC Event Structure                                         *
 *                                                                             *
 * OUTPUT                                                                      * 
 *   Nothing                                                                   *
 *                                                                             *
 *******************************************************************************/
 void Console_JoinChannel(PVOID pContext, PIRC_EVENT_STRUC pIrcEventStruc)
 {
     if(pIrcEventStruc->bNickIsSelf)
	 {
        printf("*** You Joined %s\n", pIrcEventStruc->szChannelCommand);
	 }
	 else
	 {
		 printf("*** %s Joined %s\n", pIrcEventStruc->szNick, pIrcEventStruc->szChannelCommand);
	 }
 }


/*******************************************************************************
 * Console_PartChannel                                                         *
 *                                                                             *
 * DESCRIPTION: Called on channel part events                                                *
 *                                                                             *
 * INPUT                                                                       *
 *   User Context, IRC Event Structure                                         *
 *                                                                             *
 * OUTPUT                                                                      * 
 *   Nothing                                                                   *
 *                                                                             *
 *******************************************************************************/
 void Console_PartChannel(PVOID pContext, PIRC_EVENT_STRUC pIrcEventStruc)
 {
     if(pIrcEventStruc->bNickIsSelf)
	 {
        printf("*** You left %s\n", pIrcEventStruc->szChannelCommand);
	 }
	 else
	 {
		 printf("*** %s left %s\n", pIrcEventStruc->szNick, pIrcEventStruc->szChannelCommand);
	 }
 }

/*******************************************************************************
 * Console_QuitIrc                                                         *
 *                                                                             *
 * DESCRIPTION: Called on  quit events                                                *
 *                                                                             *
 * INPUT                                                                       *
 *   User Context, IRC Event Structure                                         *
 *                                                                             *
 * OUTPUT                                                                      * 
 *   Nothing                                                                   *
 *                                                                             *
 *******************************************************************************/
 void Console_QuitIrc(PVOID pContext, PIRC_EVENT_STRUC pIrcEventStruc)
 {
	 if(pIrcEventStruc->bNickIsSelf)
	 {
     	printf("*** You Quit(%s)\n", pIrcEventStruc->szText);
	 }
	 else
	 {
		printf("*** %s Quits(%s)\n", pIrcEventStruc->szNick, pIrcEventStruc->szText);
	 }
 }

/*******************************************************************************
 * Console_ChangeNick                                                         *
 *                                                                             *
 * DESCRIPTION: Called when user changes nick                                               *
 *                                                                             *
 * INPUT                                                                       *
 *   User Context, IRC Event Structure                                         *
 *                                                                             *
 * OUTPUT                                                                      * 
 *   Nothing                                                                   *
 *                                                                             *
 *******************************************************************************/
 void Console_ChangeNick(PVOID pContext, PIRC_EVENT_STRUC pIrcEventStruc)
 {
	 if(pIrcEventStruc->bNickIsSelf)
	 {
     	printf("*** You are now known as %s\n", pIrcEventStruc->szNickCommand);
	 }
	 else
	 {
		printf("*** %s is now known as %s\n", pIrcEventStruc->szNick, pIrcEventStruc->szNickCommand);
	 }
 }



/*******************************************************************************
 * Console_ChannelTopic                                                         *
 *                                                                             *
 * DESCRIPTION: Called on topic events                                               *
 *                                                                             *
 * INPUT                                                                       *
 *   User Context, IRC Event Structure                                         *
 *                                                                             *
 * OUTPUT                                                                      * 
 *   Nothing                                                                   *
 *                                                                             *
 *******************************************************************************/
 void Console_ChannelTopic(PVOID pContext, PIRC_EVENT_STRUC pIrcEventStruc)
 {
   if(pIrcEventStruc->bNickIsSelf)
   {
       printf("*** You changed to topic of %s to \"%s\"\n", pIrcEventStruc->szChannelCommand, pIrcEventStruc->szText);
   }
   else
   {
	   printf("*** %s changed the topic of %s to \"%s\"\n", pIrcEventStruc->szNick, pIrcEventStruc->szChannelCommand, pIrcEventStruc->szText);
   }
 }


/*******************************************************************************
 * Console_Kick                                                         *
 *                                                                             *
 * DESCRIPTION: Called on kick events                                               *
 *                                                                             *
 * INPUT                                                                       *
 *   User Context, IRC Event Structure                                         *
 *                                                                             *
 * OUTPUT                                                                      * 
 *   Nothing                                                                   *
 *                                                                             *
 *******************************************************************************/
 void Console_Kick(PVOID pContext, PIRC_EVENT_STRUC pIrcEventStruc)
 {
      if(pIrcEventStruc->bNickCommandIsSelf)
	  {
           printf("*** You were kicked from %s by %s (%s)\n", pIrcEventStruc->szChannelCommand, pIrcEventStruc->szNick, pIrcEventStruc->szText);
	  }
      else
	  {
		   if(pIrcEventStruc->bNickIsSelf)
		   {
	           printf("*** You kicked %s from %s (%s)\n", pIrcEventStruc->szNickCommand, pIrcEventStruc->szChannelCommand, pIrcEventStruc->szText);
		   }
		   else
		   {
			   printf("*** %s was kicked from %s by %s (%s)\n", pIrcEventStruc->szNickCommand, pIrcEventStruc->szChannelCommand, pIrcEventStruc->szNick, pIrcEventStruc->szText);
		   }
	  }
 }

/*******************************************************************************
 * Console_PrivMessage                                                         *
 *                                                                             *
 * DESCRIPTION: Called on message events                                               *
 *                                                                             *
 * INPUT                                                                       *
 *   User Context, IRC Event Structure                                         *
 *                                                                             *
 * OUTPUT                                                                      * 
 *   Nothing                                                                   *
 *                                                                             *
 *******************************************************************************/
 void Console_PrivMessage(PVOID pContext, PIRC_EVENT_STRUC pIrcEventStruc)
 {
	 if(pIrcEventStruc->bNickCommandIsSelf)
	 {
		 printf("**Private Message: <%s> %s\n", pIrcEventStruc->szNick, pIrcEventStruc->szText);
		 IRC_MsgNick(pIrcEventStruc->hIrc, pIrcEventStruc->szNick, "Error baby");    
	 }
	 else
	 {
		 printf("<%s:%s> %s\n", pIrcEventStruc->szChannelCommand, pIrcEventStruc->szNick, pIrcEventStruc->szText);
	 }
 }


/*******************************************************************************
 * Console_Notice                                                         *
 *                                                                             *
 * DESCRIPTION: Called on notice events                                               *
 *                                                                             *
 * INPUT                                                                       *
 *   User Context, IRC Event Structure                                         *
 *                                                                             *
 * OUTPUT                                                                      * 
 *   Nothing                                                                   *
 *                                                                             *
 *******************************************************************************/
 void Console_Notice(PVOID pContext, PIRC_EVENT_STRUC pIrcEventStruc)
 {
	 if(pIrcEventStruc->bNickCommandIsSelf)
	 {
		 printf("**Private Notice: <%s> %s\n", pIrcEventStruc->szNick, pIrcEventStruc->szText);
		 IRC_NoticeNick(pIrcEventStruc->hIrc, pIrcEventStruc->szNick, "Error baby");    
	 }
	 else
	 {
		 printf("-%s:%s- %s\n", pIrcEventStruc->szChannelCommand, pIrcEventStruc->szNick, pIrcEventStruc->szText);
	 }
 }


/*******************************************************************************
 * Console_Ping                                                         *
 *                                                                             *
 * DESCRIPTION: Called on ping events                                               *
 *                                                                             *
 * INPUT                                                                       *
 *   User Context, IRC Event Structure                                         *
 *                                                                             *
 * OUTPUT                                                                      * 
 *   Nothing                                                                   *
 *                                                                             *
 *******************************************************************************/
 void Console_Ping(PVOID pContext, PIRC_EVENT_STRUC pIrcEventStruc)
 {
 }

/*******************************************************************************
 * Console_NoticeCtcp                                                         *
 *                                                                             *
 * DESCRIPTION: Called on notice ctcp events                                               *
 *                                                                             *
 * INPUT                                                                       *
 *   User Context, IRC Event Structure                                         *
 *                                                                             *
 * OUTPUT                                                                      * 
 *   Nothing                                                                   *
 *                                                                             *
 *******************************************************************************/
 void Console_NoticeCtcp(PVOID pContext, PIRC_EVENT_STRUC pIrcEventStruc)
 {
 }

/*******************************************************************************
 * Console_PrivMessageCtcp                                                         *
 *                                                                             *
 * DESCRIPTION: Called on message ctcp events                                               *
 *                                                                             *
 * INPUT                                                                       *
 *   User Context, IRC Event Structure                                         *
 *                                                                             *
 * OUTPUT                                                                      * 
 *   Nothing                                                                   *
 *                                                                             *
 *******************************************************************************/
 void Console_PrivMessageCtcp(PVOID pContext, PIRC_EVENT_STRUC pIrcEventStruc)
 {
 }


/*******************************************************************************
 * Console_NumericEvent                                                         *
 *                                                                             *
 * DESCRIPTION: Called on numeric events                                               *
 *                                                                             *
 * INPUT                                                                       *
 *   User Context, IRC Event Structure                                         *
 *                                                                             *
 * OUTPUT                                                                      * 
 *   Nothing                                                                   *
 *                                                                             *
 *******************************************************************************/
 void Console_NumericEvent(PVOID pContext, PIRC_EVENT_STRUC pIrcEventStruc)
 {
	 printf("<%i> %s\n", pIrcEventStruc->dwNumericId, pIrcEventStruc->szText);
 }





