

#ifndef __RAYCASTER_H__
#define __RAYCASTER_H__

typedef PVOID HRAYCAST;

#define NO_INTERSECTION ((UINT)-1)

typedef struct _DRAW_CONTEXT
{
	PVOID pContext;
	UINT  Distance;
	UINT  VerticleLine;
	UINT  ImageNumber;
	UINT  CellX;
	UINT  CellY;
	UINT  CellLocationX;
	UINT  CellLocationY;
	BOOL  XIsBlocked;
	BOOL  YIsBlocked;
} DRAW_CONTEXT, *PDRAW_CONTEXT;

typedef void (WINAPI *PFN_DRAW)(HRAYCAST hRayCast, PDRAW_CONTEXT pDrawContext);

typedef struct _RAYCAST_INIT
{
	UINT LevelSizeX;
	UINT LevelSizeY;
	UINT CellSizeX;
	UINT CellSizeY;
	PFN_DRAW pfnDrawWallSlice;
	UINT CellLocationX;
	UINT CellLocationY;
	int DirectionAngle;
	PDWORD pLevelMap;
	PVOID pContext;
	UINT     CellIndexX;
	UINT     CellIndexY;

} RAYCAST_INIT, *PRAYCAST_INIT;


typedef struct _MAP_LOCATION
{
	UINT CellLocationX;
	UINT CellLocationY;
	UINT     CellIndexX;
	UINT     CellIndexY;
	int  DirectionAngle;

} MAP_LOCATION, *PMAP_LOCATION;

HRAYCAST RayCaster_Init(PRAYCAST_INIT pRayCastInit);
void RayCaster_Turn(HRAYCAST hRayCast, int TurnAngleMod);
DWORD RayCaster_Move(HRAYCAST hRayCast, int NumberSteps);
void RayCaster_GetLocation(HRAYCAST hRayCast, PMAP_LOCATION pMapLocation);
void RayCaster_Cast(HRAYCAST hRayCast, UINT Width, UINT CellSize, UINT ViewAngle);




#endif


