/***********************************************************************
 * maingame.C
 *  
 *    Main Game
 *
 *
 * Toby Opferman Copyright (c) 2003
 *
 ***********************************************************************/
 
 
#include <windows.h>
#include <time.h>
#include <stdio.h>
#include <stdlib.h>
#include <raycaster.h>
#include <gdi.h>
#include <gif.h>
#include "game.h"
#include "gameres.h"

typedef struct _GAME_SCREEN
{
	HGDI hGameScreen;	

} GAME_SCREEN, *PGAME_SCREEN;

#define CUBE_SIZE    60
#define TEXTURE_HEIGHT 60
#define POV   60

typedef struct _GAME_INTERNAL
{
	HWND      hWnd;
	HINSTANCE hInstance;
	HRAYCAST  hRayCast;
	BOOL      bUpArrow;
	BOOL      bDownArrow;
	BOOL      bLeftArrow;
	BOOL      bRightArrow;
	DWORD     *pScreenBuffer;
	HGIF      hGIF[10];
	DWORD      *pImageBuffer[10];
	UINT       ImageWidth[10];  
	UINT       ImageHeight[10]; 

	GAME_SCREEN  GameScreen;
}GAME_INTERNAL, *PGAME_INTERNAL;



/*DWORD g_LevelMap[] =
{
	1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2,
	1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2,
	2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1,
	1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 2, 1, 2, 1, 0, 0, 2,
	2, 0, 2, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 2, 0, 0, 1,
	1, 0, 1, 0, 0, 2, 1, 2, 0, 0, 1, 0, 0, 0, 1, 0, 0, 2,
	2, 0, 2, 0, 0, 0, 0, 1, 0, 0, 2, 0, 0, 0, 2, 0, 0, 1,
	1, 0, 1, 0, 0, 0, 0, 2, 0, 0, 1, 0, 0, 0, 1, 0, 0, 2,
	2, 0, 2, 0, 0, 0, 0, 1, 0, 0, 2, 0, 0, 0, 2, 0, 0, 1,
	1, 0, 1, 0, 0, 0, 0, 2, 1, 2, 1, 0, 0, 0, 1, 0, 0, 2,
	2, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 1,
	1, 0, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 0, 0, 2,
	2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1,
	1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2,
	1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2
};*/


 DWORD g_LevelMap[] =
{
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1,
	1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1,
	1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 3, 3, 3, 4, 0, 0, 1,
	1, 0, 2, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 4, 0, 0, 1,
	1, 0, 2, 0, 0, 3, 3, 4, 0, 0, 2, 0, 0, 0, 4, 0, 0, 1,
	1, 0, 2, 0, 0, 0, 0, 4, 0, 0, 2, 0, 0, 0, 4, 0, 0, 1,
	1, 0, 2, 0, 0, 0, 0, 4, 0, 0, 2, 0, 0, 0, 4, 0, 0, 1,
	1, 0, 2, 0, 0, 0, 0, 4, 0, 0, 2, 0, 0, 0, 4, 0, 0, 1,
	1, 0, 2, 0, 0, 0, 0, 4, 3, 3, 2, 0, 0, 0, 4, 0, 0, 1,
	1, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 1,
	1, 0, 2, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 0, 0, 1,
	1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1,
	1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1
};

DWORD g_LevelMapMod[15*18];

 /***********************************************************************
  * Prototypes
  ***********************************************************************/
void Game_Debug(char *pszFormatString, ...);
void WINAPI Game_DrawLine(HRAYCAST hRayCast, PDRAW_CONTEXT pDrawContext);
BOOL Game_GameLoop(PGAME_INTERNAL pGameInternal);

 /***********************************************************************
  * Game_Init
  *  
  *    
  *
  * Parameters
  *     
  * 
  * Return Value
  *     
  *
  ***********************************************************************/
HGAME Game_Init(HWND hWnd, HINSTANCE hInstance)
{
	PGAME_INTERNAL pGameInternal = NULL;
	RAYCAST_INIT RayCastInit = {0};

	pGameInternal = (PGAME_INTERNAL)LocalAlloc(LMEM_ZEROINIT, sizeof(GAME_INTERNAL));

	srand((int)time(NULL));

	if(pGameInternal)
	{
     	pGameInternal->hWnd      = hWnd;
		pGameInternal->hInstance = hInstance;
		pGameInternal->GameScreen.hGameScreen = GDI_Init(NULL, GAME_WIDTH, GAME_HEIGHT);

		pGameInternal->hGIF[0]      = Gif_Open("brickwall.gif");
		pGameInternal->hGIF[1]      = Gif_Open("amelia.gif");
		pGameInternal->hGIF[2]      = pGameInternal->hGIF[1];
		pGameInternal->hGIF[3]      = pGameInternal->hGIF[1];
     	
	    pGameInternal->ImageWidth[0]  = Gif_GetImageWidth(pGameInternal->hGIF[0], 0);
	    pGameInternal->ImageHeight[0] = Gif_GetImageHeight(pGameInternal->hGIF[0], 0);
	    pGameInternal->ImageWidth[1]  = Gif_GetImageWidth(pGameInternal->hGIF[1], 0);
	    pGameInternal->ImageHeight[1] = Gif_GetImageHeight(pGameInternal->hGIF[1], 0);
	    pGameInternal->ImageWidth[2]  = Gif_GetImageWidth(pGameInternal->hGIF[2], 0);
	    pGameInternal->ImageHeight[2] = Gif_GetImageHeight(pGameInternal->hGIF[2], 0);
	    pGameInternal->ImageWidth[3]  = Gif_GetImageWidth(pGameInternal->hGIF[3], 0);
	    pGameInternal->ImageHeight[3] = Gif_GetImageHeight(pGameInternal->hGIF[3], 0);

		pGameInternal->pImageBuffer[0] = (DWORD *)LocalAlloc(LMEM_ZEROINIT, sizeof(DWORD)*pGameInternal->ImageWidth[0]*pGameInternal->ImageHeight[0]);
		pGameInternal->pImageBuffer[1] = (DWORD *)LocalAlloc(LMEM_ZEROINIT, sizeof(DWORD)*pGameInternal->ImageWidth[1]*pGameInternal->ImageHeight[1]);
		pGameInternal->pImageBuffer[2] = (DWORD *)LocalAlloc(LMEM_ZEROINIT, sizeof(DWORD)*pGameInternal->ImageWidth[2]*pGameInternal->ImageHeight[2]);
		pGameInternal->pImageBuffer[3] = (DWORD *)LocalAlloc(LMEM_ZEROINIT, sizeof(DWORD)*pGameInternal->ImageWidth[3]*pGameInternal->ImageHeight[3]);
	
        Gif_GetImage32bpp(pGameInternal->hGIF[0], 0, (PVOID)pGameInternal->pImageBuffer[0]);
		Gif_GetImage32bpp(pGameInternal->hGIF[1], 0, (PVOID)pGameInternal->pImageBuffer[1]);
		Gif_GetImage32bpp(pGameInternal->hGIF[2], 0, (PVOID)pGameInternal->pImageBuffer[2]);
		Gif_GetImage32bpp(pGameInternal->hGIF[3], 0, (PVOID)pGameInternal->pImageBuffer[3]);

		RayCastInit.LevelSizeX = 18;
		RayCastInit.LevelSizeY = 15;
		RayCastInit.CellSizeX = CUBE_SIZE;
		RayCastInit.CellSizeY = CUBE_SIZE;
		RayCastInit.pfnDrawWallSlice = Game_DrawLine;
		RayCastInit.CellLocationX = 0;
		RayCastInit.CellLocationY = 0;
		RayCastInit.DirectionAngle = 45;
		RayCastInit.pdwLevelMap = g_LevelMap;
		RayCastInit.pContext = (PVOID)pGameInternal;
		RayCastInit.CellIndexX = 1;
		RayCastInit.CellIndexY = 1;

		pGameInternal->hRayCast = RayCaster_Init(&RayCastInit);
	}

	return pGameInternal;
}


 /***********************************************************************
  * Game_Init
  *  
  *    
  *
  * Parameters
  *     
  * 
  * Return Value
  *     
  *
  ***********************************************************************/
void Game_Close(HGAME hGame)
{
	PGAME_INTERNAL pGameInternal = (PGAME_INTERNAL)hGame;

	LocalFree(pGameInternal);
}



 /***********************************************************************
  * Game_Init
  *  
  *    
  *
  * Parameters
  *     
  * 
  * Return Value
  *     
  *
  ***********************************************************************/
void Game_HandleKeyRelease(HGAME hGame, UINT vKey)
{
	PGAME_INTERNAL pGameInternal = (PGAME_INTERNAL)hGame;

	switch(vKey)
	{
		case VK_UP:
			 pGameInternal->bUpArrow = FALSE;
			 break;

		case VK_DOWN:
			 pGameInternal->bDownArrow = FALSE;
			 break;

		case VK_LEFT:
			 pGameInternal->bLeftArrow = FALSE;
			 break;

		case VK_RIGHT:
			 pGameInternal->bRightArrow = FALSE;
			 break;
	}
}




 /***********************************************************************
  * Game_Init
  *  
  *    
  *
  * Parameters
  *     
  * 
  * Return Value
  *     
  *
  ***********************************************************************/
void Game_HandleKeyPress(HGAME hGame, UINT vKey)
{
	PGAME_INTERNAL pGameInternal = (PGAME_INTERNAL)hGame;

	switch(vKey)
	{
		case VK_UP:
			 pGameInternal->bUpArrow = TRUE;
			 break;

		case VK_DOWN:
			 pGameInternal->bDownArrow = TRUE;
			 break;

		case VK_LEFT:
			 pGameInternal->bLeftArrow = TRUE;
			 break;

		case VK_RIGHT:
			 pGameInternal->bRightArrow = TRUE;
			 break;
	}
}


 /***********************************************************************
  * Game_Init
  *  
  *    
  *
  * Parameters
  *     
  * 
  * Return Value
  *     
  *
  ***********************************************************************/
HDC Game_GetGameDc(HGAME hGame)
{
	PGAME_INTERNAL pGameInternal = (PGAME_INTERNAL)hGame;

    return GDI_GetDC(pGameInternal->GameScreen.hGameScreen);
}

 /***********************************************************************
  * Game_Init
  *  
  *    
  *
  * Parameters
  *     
  * 
  * Return Value
  *     
  *
  ***********************************************************************/
void Game_ReleaseGameDc(HGAME hGame, HDC hGameDC)
{
	PGAME_INTERNAL pGameInternal = (PGAME_INTERNAL)hGame;
	GDI_ReleaseDC(pGameInternal->GameScreen.hGameScreen);
}

 /***********************************************************************
  * Game_Init
  *  
  *    
  *
  * Parameters
  *     
  * 
  * Return Value
  *     
  *
  ***********************************************************************/
BOOL Game_MessageLoop(HGAME hGame)
{
	PGAME_INTERNAL pGameInternal = (PGAME_INTERNAL)hGame;
	BOOL bContinue = TRUE;


	{
		 MSG Msg;
		 BOOL bThunkMessageLoop = TRUE;

		 SetTimer(pGameInternal->hWnd, 1, 1000/30, NULL);

		 while(bThunkMessageLoop)
		 {
			if(GetMessage(&Msg, 0, 0, 0) > 0)
			{
				if(Msg.message == WM_SWITCH_GAME_STATE)
				{
					bThunkMessageLoop = FALSE;
				}

				TranslateMessage(&Msg);
				DispatchMessage(&Msg);

				Game_GameLoop(pGameInternal);

			}
			else
			{
				bThunkMessageLoop = FALSE;
				bContinue         = FALSE;
			}
		 }

		 KillTimer(pGameInternal->hWnd, 1);
	}

	return bContinue;
}

 /***********************************************************************
  * Game_GameLoop
  *  
  *    
  *
  * Parameters
  *     
  * 
  * Return Value
  *     
  *
  ***********************************************************************/
BOOL Game_GameLoop(PGAME_INTERNAL pGameInternal)
{
	if(pGameInternal->bUpArrow)
	{
		RayCaster_Move(pGameInternal->hRayCast, 10);
	}

	if(pGameInternal->bDownArrow)
	{
		RayCaster_Move(pGameInternal->hRayCast, -10);
	}

	if(pGameInternal->bLeftArrow)
	{
		RayCaster_Turn(pGameInternal->hRayCast, 2);
	}

	if(pGameInternal->bRightArrow)
	{
		RayCaster_Turn(pGameInternal->hRayCast, -2);
	}


	pGameInternal->pScreenBuffer = (DWORD *)GDI_BeginPaint(pGameInternal->GameScreen.hGameScreen);
	memset(pGameInternal->pScreenBuffer, 0, GAME_WIDTH*GAME_HEIGHT*sizeof(DWORD));
    
	RayCaster_Cast(pGameInternal->hRayCast, GAME_WIDTH, TEXTURE_HEIGHT, POV);

	GDI_EndPaint(pGameInternal->GameScreen.hGameScreen);

	pGameInternal->pScreenBuffer = NULL;
	
	InvalidateRect(pGameInternal->hWnd, NULL, FALSE);

#if 1
	{
		int x;
		int y;
		static int PrevX = 0;
		static int PrevY = 0;
		MAP_LOCATION MapLocation;

		RayCaster_GetLocation(pGameInternal->hRayCast, &MapLocation);

		if(MapLocation.CellIndexY != PrevY || MapLocation.CellIndexX != PrevX)
		{
			PrevY = MapLocation.CellIndexY;
			PrevX = MapLocation.CellIndexX;
			printf("\n");
			memcpy(g_LevelMapMod, g_LevelMap, sizeof(g_LevelMap));

			for(y = 0; y < 15; y++)
			{
				for(x = 0; x < 18; x++)
				{
					if(y == MapLocation.CellIndexY && x == MapLocation.CellIndexX)
					{
						printf("%c", 1);
					}
					else
					{
						switch(g_LevelMapMod[x + y*18])
						{
							case 0:
								printf(" ");
								break;
							case 1:
							case 2:
							case 3:
							case 4:
								printf("I");
								break;
							case 5:
								printf("@");
								break;
						}
					}
				}
				printf("\n");
			}
			printf("\n");
		}
	}
#endif

	return TRUE;
}

 /***********************************************************************
  * Game_Init
  *  
  *    
  *
  * Parameters
  *     
  * 
  * Return Value
  *     
  *
  ***********************************************************************/
void Game_DispatchMenuSelections(HGAME hGame, UINT uiMenuSelection)
{
	PGAME_INTERNAL pGameInternal = (PGAME_INTERNAL)hGame;
}

 /***********************************************************************
  * Game_Init
  *  
  *    
  *
  * Parameters
  *     
  * 
  * Return Value
  *     
  *
  ***********************************************************************/
BOOL Game_FadeTitleScreen(HGAME hGame)
{
	return FALSE;
}
/***********************************************************************
 * Game_Debug
 *  
 *    Debug Shit
 *
 *    
 *
 * Parameters
 *     Debug
 *
 * Return Value
 *     Nothing
 *
 ***********************************************************************/
 void Game_Debug(char *pszFormatString, ...)
 {
     char DebugString[256];
     va_list vl;

     va_start(vl, pszFormatString);
     vsprintf(DebugString, pszFormatString, vl);
     va_end(vl);

     OutputDebugStringA(DebugString);
 }





/***********************************************************************
 * Game_HandleMenuCommands
 *  
 *    
 *
 *    
 *
 * Parameters
 *     Debug
 *
 * Return Value
 *     Nothing
 *
 ***********************************************************************/
void Game_HandleMenuCommands(HGAME hGame, USHORT Command, LPARAM lParam)
{
	PGAME_INTERNAL pGameInternal = (PGAME_INTERNAL)hGame;

	switch(Command)
	{
		case IDM_EXIT:
			 SendMessage(pGameInternal->hWnd, WM_CLOSE, 0, 0);
			 break;
	}
}



/***********************************************************************
 * Game_DrawLine
 *  
 *    
 *
 *    
 *
 * Parameters
 *     Debug
 *
 * Return Value
 *     Nothing
 *
 ***********************************************************************/
void WINAPI Game_DrawLine(HRAYCAST hRayCast, PDRAW_CONTEXT pDrawContext)
{
	PGAME_INTERNAL pGameInternal = (PGAME_INTERNAL)pDrawContext->pContext;
	UINT uiStart = 0;
	UINT uiSize  = GAME_HEIGHT;
	UINT uiEnd;
	DWORD Color[4] = { 0xFFFFFFFF, 0xFF, 0xFF00, 0xFF0000 };
	UCHAR ColorByte = 0xFF;
	float fImageY;
	float fImageYInc;
	UINT ImageX = 0;

	if(pDrawContext->Distance)
	{
		//uiSize = uiSize - pDrawContext->Distance;
		uiSize = (UINT)((((float)80)/((float)pDrawContext->Distance))*692.0);
		//Game_Debug("%i / (%i + 400) * 400 = %i\n", TEXTURE_HEIGHT, pDrawContext->Distance, uiSize);

		ColorByte = 0xFF;
		if(uiSize < 256*2)
		{
			ColorByte = uiSize/2;
		}
		
		switch(pDrawContext->ImageNumber)
		{
			case 1:
			Color[pDrawContext->ImageNumber-1] = (ColorByte | ColorByte<<8 | ColorByte<<16 | ColorByte<<24);
			break;
			case 2:
			Color[pDrawContext->ImageNumber-1] = (ColorByte);
			break;

			case 3:
			Color[pDrawContext->ImageNumber-1] = (ColorByte<<8);
			break;

			case 4:
			Color[pDrawContext->ImageNumber-1] = (ColorByte<<16);
			break;
		}


			//uiStart = (GAME_HEIGHT/2) - (uiSize/2);
	}

	if(uiSize > GAME_HEIGHT)
	{
		uiSize = GAME_HEIGHT;
	}

	if(pDrawContext->XIsBlocked)
	{
		if(pDrawContext->CellLocationY == 0)
		{
			ImageX = 0;
		}
		else
		{
			ImageX = pDrawContext->CellLocationY;
		}
	}
	else
	{
		if(pDrawContext->CellLocationX == 0)
		{
			ImageX = 0;
		}
		else
		{
			ImageX = pDrawContext->CellLocationX;
		}
	}


	if(ImageX >= pGameInternal->ImageWidth[pDrawContext->ImageNumber-1])
	{
		ImageX = pGameInternal->ImageWidth[pDrawContext->ImageNumber-1] - 1;
	}

	uiStart = (GAME_HEIGHT/2) - (uiSize/2);

	fImageYInc = (float)((float)pGameInternal->ImageHeight[pDrawContext->ImageNumber-1])/((float)uiSize);

    fImageY = 0;
	
//	Game_Debug("Number %i, Distance %i\n", pDrawContext->VerticleLine, pDrawContext->Distance);
  
	//Game_Debug("ImageX = %i\n", ImageX);

	uiEnd = uiStart + uiSize;
	while(uiStart < uiEnd && uiStart < GAME_HEIGHT)
	{

		 if(((UINT)fImageY) > pGameInternal->ImageHeight[pDrawContext->ImageNumber-1])
		 {
			 fImageY = (float)((float)pGameInternal->ImageHeight[pDrawContext->ImageNumber-1] - 1.0);
		 }


		 //if(pDrawContext->ImageNumber == 1)
		 {
			UCHAR Red, Green, Blue;
			DWORD dwColor = pGameInternal->pImageBuffer[pDrawContext->ImageNumber-1][ImageX + (((UINT)fImageY)*pGameInternal->ImageWidth[pDrawContext->ImageNumber-1])];

			if(pDrawContext->Distance > 100)
			{
				Red   = (UCHAR)(((dwColor>>16)&0xFF)*100/pDrawContext->Distance);
			    Green = (UCHAR)(((dwColor>>8)&0xFF)*100/pDrawContext->Distance);
				Blue  = (UCHAR)(((dwColor)&0xFF)*100/pDrawContext->Distance);
			}
			else
			{
				Red   = (UCHAR)(((dwColor>>16)&0xFF));
				Green = (UCHAR)(((dwColor>>8)&0xFF));
				Blue  = (UCHAR)(((dwColor)&0xFF));
			}

			pGameInternal->pScreenBuffer[pDrawContext->VerticleLine + uiStart*GAME_WIDTH] =  (Red<<16) | (Green<<8) | Blue;

			//pGameInternal->pScreenBuffer[pDrawContext->VerticleLine + uiStart*GAME_WIDTH] =  pGameInternal->pImageBuffer[ImageX + (((UINT)fImageY)*pGameInternal->ImageWidth)];
		 }
		 //else
		 {
		 //	pGameInternal->pScreenBuffer[pDrawContext->VerticleLine + uiStart*GAME_WIDTH] =  Color[pDrawContext->ImageNumber-1];
		 }

		 fImageY += fImageYInc;

			 //Color[pDrawContext->ImageNumber-1];
		 uiStart++;
	}
}










	
    
