/***********************************************************************
 * maingame.C
 *  
 *    Main Game
 *
 *
 * Toby Opferman Copyright (c) 2003
 *
 ***********************************************************************/
 
 
#include <windows.h>
#include <time.h>
#include <stdio.h>
#include <stdlib.h>
#include <raylevel.h>
#include <gdi.h>
#include <gif.h>
#include "game.h"
#include "gameres.h"

typedef struct _GAME_SCREEN
{
	HGDI hGameScreen;	

} GAME_SCREEN, *PGAME_SCREEN;

#define CUBE_SIZE      60
#define TEXTURE_HEIGHT 100
#define POV            60

typedef struct _GAME_INTERNAL
{
	HWND      hWnd;
	HINSTANCE hInstance;
	HRAYLEVEL  hRayLevel;
	BOOL      bUpArrow;
	BOOL      bDownArrow;
	BOOL      bLeftArrow;
	BOOL      bRightArrow;
	DWORD     *pScreenBuffer;
	HGIF      hGIF[10];
	WALL_GRAPHIC WallGraphics[10];

	GAME_SCREEN  GameScreen;
}GAME_INTERNAL, *PGAME_INTERNAL;



 DWORD g_LevelMap[] =
{
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1,
	1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1,
    1, 0, 0, 3, 2, 2, 2, 2, 2, 0, 0, 4, 4, 4, 4, 4, 4, 1,
	1, 0, 0, 3, 0, 0, 0, 0, 2, 0, 0, 4, 0, 0, 0, 0, 0, 1,
	1, 0, 0, 3, 0, 0, 0, 0, 2, 0, 0, 4, 0, 0, 0, 0, 0, 1,
	1, 0, 0, 3, 0, 0, 0, 0, 2, 0, 0, 4, 0, 0, 4, 0, 0, 1,
	1, 0, 0, 3, 0, 0, 0, 0, 2, 0, 0, 4, 0, 0, 4, 0, 0, 1,
	1, 0, 0, 3, 0, 0, 2, 2, 2, 0, 0, 4, 0, 0, 4, 0, 0, 1,
	1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 1,
	1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 1,
	1, 0, 0, 3, 0, 0, 3, 3, 3, 3, 3, 3, 3, 3, 4, 0, 0, 1,
	1, 0, 0, 3, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 1,
	1, 0, 0, 3, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 1,
	1, 0, 0, 3, 0, 0, 1, 0, 0, 5, 5, 5, 5, 5, 4, 0, 0, 1,
	1, 0, 0, 3, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1,
	1, 0, 0, 3, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1,
	1, 0, 0, 3, 0, 0, 1, 5, 5, 5, 0, 0, 5, 5, 5, 0, 0, 1,
	1, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 5, 0, 0, 1,
	1, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 5, 0, 0, 1,
	1, 0, 0, 3, 0, 0, 1, 5, 5, 5, 5, 5, 0, 0, 5, 0, 0, 1,
	1, 0, 0, 3, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 5, 0, 0, 1,
	1, 3, 3, 3, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 5, 0, 0, 1,
	1, 0, 0, 0, 0, 0, 1, 0, 0, 5, 5, 5, 0, 0, 5, 0, 0, 1,
	1, 0, 0, 0, 0, 0, 1, 0, 0, 5, 0, 3, 0, 0, 5, 0, 0, 1,
	1, 0, 0, 1, 1, 1, 1, 5, 5, 5, 0, 3, 0, 0, 0, 0, 0, 1,
	1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 0, 0, 0, 0, 0, 1,
	1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 0, 0, 1,
	1, 0, 0, 2, 2, 2, 0, 0, 0, 0, 0, 0, 0, 0, 3, 0, 0, 1,
	1, 0, 0, 2, 0, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 0, 0, 1,
	1, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 0, 0, 1,
    1, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1,
	1, 0, 0, 2, 0, 0, 2, 2, 2, 2, 2, 0, 0, 0, 0, 0, 0, 1,
	1, 2, 2, 2, 0, 0, 2, 0, 0, 0, 2, 2, 0, 0, 2, 0, 0, 1,
	1, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 1,
	1, 0, 0, 0, 0, 0, 2, 0, 1, 1, 1, 1, 0, 0, 2, 0, 0, 1,
	1, 0, 0, 2, 2, 2, 0, 0, 0, 2, 0, 0, 0, 0, 2, 0, 0, 1,
	1, 0, 0, 3, 0, 0, 0, 2, 0, 2, 0, 2, 0, 0, 2, 0, 0, 1,
	1, 0, 0, 3, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0, 2, 0, 0, 1,
	1, 0, 0, 3, 0, 0, 4, 0, 0, 0, 0, 4, 4, 4, 2, 0, 0, 1,
	1, 0, 0, 3, 0, 0, 4, 0, 0, 0, 0, 4, 0, 0, 0, 0, 0, 1,
	1, 0, 0, 3, 0, 0, 4, 0, 0, 4, 4, 4, 0, 0, 0, 0, 0, 1,
	1, 0, 0, 3, 0, 0, 4, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 1,
	1, 0, 0, 3, 0, 0, 4, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1
};


 /***********************************************************************
  * Prototypes
  ***********************************************************************/
void Game_Debug(char *pszFormatString, ...);
BOOL Game_GameLoop(PGAME_INTERNAL pGameInternal);

 /***********************************************************************
  * Game_Init
  *  
  *    
  *
  * Parameters
  *     
  * 
  * Return Value
  *     
  *
  ***********************************************************************/
HGAME Game_Init(HWND hWnd, HINSTANCE hInstance)
{
	PGAME_INTERNAL pGameInternal = NULL;
	RAYLEVEL_INIT RayLevelInit = {0};
	WALL_GRAPHIC WallGraphics[4] = {0};

	pGameInternal = (PGAME_INTERNAL)LocalAlloc(LMEM_ZEROINIT, sizeof(GAME_INTERNAL));

	srand((int)time(NULL));

	if(pGameInternal)
	{
     	pGameInternal->hWnd      = hWnd;
		pGameInternal->hInstance = hInstance;
		pGameInternal->GameScreen.hGameScreen = GDI_Init(NULL, GAME_WIDTH, GAME_HEIGHT);

		pGameInternal->hGIF[0]      = Gif_Open("brickwall.gif");
		pGameInternal->hGIF[1]      = Gif_Open("amelia.gif");
		pGameInternal->hGIF[2]      = Gif_Open("lisa.gif");
		pGameInternal->hGIF[3]      = Gif_Open("backyardigans.gif");
		pGameInternal->hGIF[4]      = Gif_Open("dora.gif");
     	
	    pGameInternal->WallGraphics[0].Width  = Gif_GetImageWidth(pGameInternal->hGIF[0], 0);
	    pGameInternal->WallGraphics[0].Height = Gif_GetImageHeight(pGameInternal->hGIF[0], 0);
	    pGameInternal->WallGraphics[1].Width  = Gif_GetImageWidth(pGameInternal->hGIF[1], 0);
	    pGameInternal->WallGraphics[1].Height = Gif_GetImageHeight(pGameInternal->hGIF[1], 0);
	    pGameInternal->WallGraphics[2].Width  = Gif_GetImageWidth(pGameInternal->hGIF[2], 0);
	    pGameInternal->WallGraphics[2].Height = Gif_GetImageHeight(pGameInternal->hGIF[2], 0);
	    pGameInternal->WallGraphics[3].Width  = Gif_GetImageWidth(pGameInternal->hGIF[3], 0);
	    pGameInternal->WallGraphics[3].Height = Gif_GetImageHeight(pGameInternal->hGIF[3], 0);
	    pGameInternal->WallGraphics[4].Width  = Gif_GetImageWidth(pGameInternal->hGIF[4], 0);
	    pGameInternal->WallGraphics[4].Height = Gif_GetImageHeight(pGameInternal->hGIF[4], 0);

		pGameInternal->WallGraphics[0].pImageData = (DWORD *)LocalAlloc(LMEM_ZEROINIT, sizeof(DWORD)*pGameInternal->WallGraphics[0].Width*pGameInternal->WallGraphics[0].Height);
		pGameInternal->WallGraphics[1].pImageData = (DWORD *)LocalAlloc(LMEM_ZEROINIT, sizeof(DWORD)*pGameInternal->WallGraphics[1].Width*pGameInternal->WallGraphics[1].Height);
		pGameInternal->WallGraphics[2].pImageData = (DWORD *)LocalAlloc(LMEM_ZEROINIT, sizeof(DWORD)*pGameInternal->WallGraphics[2].Width*pGameInternal->WallGraphics[2].Height);
		pGameInternal->WallGraphics[3].pImageData = (DWORD *)LocalAlloc(LMEM_ZEROINIT, sizeof(DWORD)*pGameInternal->WallGraphics[3].Width*pGameInternal->WallGraphics[3].Height);
		pGameInternal->WallGraphics[4].pImageData = (DWORD *)LocalAlloc(LMEM_ZEROINIT, sizeof(DWORD)*pGameInternal->WallGraphics[4].Width*pGameInternal->WallGraphics[4].Height);

        Gif_GetImage32bpp(pGameInternal->hGIF[0], 0, (PVOID)pGameInternal->WallGraphics[0].pImageData);
		Gif_GetImage32bpp(pGameInternal->hGIF[1], 0, (PVOID)pGameInternal->WallGraphics[1].pImageData);
		Gif_GetImage32bpp(pGameInternal->hGIF[2], 0, (PVOID)pGameInternal->WallGraphics[2].pImageData);
		Gif_GetImage32bpp(pGameInternal->hGIF[3], 0, (PVOID)pGameInternal->WallGraphics[3].pImageData);
		Gif_GetImage32bpp(pGameInternal->hGIF[4], 0, (PVOID)pGameInternal->WallGraphics[4].pImageData);

		RayLevelInit.ResolutionX = 18;
		RayLevelInit.ResolutionY = 46;
		
		RayLevelInit.CellResolution = CUBE_SIZE;
		
		RayLevelInit.CellX = 20;
		RayLevelInit.CellY = 20;
		
		RayLevelInit.DirectionAngle = 45;
		
		RayLevelInit.pLevelMap = g_LevelMap;
		RayLevelInit.MapIndexX = 1;
		RayLevelInit.MapIndexY = 1;
		
		RayLevelInit.CollisionRadius = 25;
		RayLevelInit.LightingType    = SimpleLighting;
		
		RayLevelInit.SizeDistanceRatio = 800;
		RayLevelInit.PointOfViewAngle  = 60;

		RayLevelInit.SimpleLightingLumination = 200;
		RayLevelInit.SimpleLightingDistance   = 200;
		
		RayLevelInit.ScreenWidth  = GAME_WIDTH;
		RayLevelInit.ScreenHeight = GAME_HEIGHT;

		RayLevelInit.NumberOfWallGraphics = 5;
		RayLevelInit.pWallGraphicList     = pGameInternal->WallGraphics;

		pGameInternal->hRayLevel = RayLevel_Init(&RayLevelInit);
	}

	return pGameInternal;
}




 /***********************************************************************
  * Game_Init
  *  
  *    
  *
  * Parameters
  *     
  * 
  * Return Value
  *     
  *
  ***********************************************************************/
void Game_Close(HGAME hGame)
{
	PGAME_INTERNAL pGameInternal = (PGAME_INTERNAL)hGame;

	LocalFree(pGameInternal);
}



 /***********************************************************************
  * Game_Init
  *  
  *    
  *
  * Parameters
  *     
  * 
  * Return Value
  *     
  *
  ***********************************************************************/
void Game_HandleKeyRelease(HGAME hGame, UINT vKey)
{
	PGAME_INTERNAL pGameInternal = (PGAME_INTERNAL)hGame;

	switch(vKey)
	{
		case VK_UP:
			 pGameInternal->bUpArrow = FALSE;
			 break;

		case VK_DOWN:
			 pGameInternal->bDownArrow = FALSE;
			 break;

		case VK_LEFT:
			 pGameInternal->bLeftArrow = FALSE;
			 break;

		case VK_RIGHT:
			 pGameInternal->bRightArrow = FALSE;
			 break;
	}
}




 /***********************************************************************
  * Game_Init
  *  
  *    
  *
  * Parameters
  *     
  * 
  * Return Value
  *     
  *
  ***********************************************************************/
void Game_HandleKeyPress(HGAME hGame, UINT vKey)
{
	PGAME_INTERNAL pGameInternal = (PGAME_INTERNAL)hGame;

	switch(vKey)
	{
		case VK_UP:
			 pGameInternal->bUpArrow = TRUE;
			 break;

		case VK_DOWN:
			 pGameInternal->bDownArrow = TRUE;
			 break;

		case VK_LEFT:
			 pGameInternal->bLeftArrow = TRUE;
			 break;

		case VK_RIGHT:
			 pGameInternal->bRightArrow = TRUE;
			 break;
	}
}


 /***********************************************************************
  * Game_Init
  *  
  *    
  *
  * Parameters
  *     
  * 
  * Return Value
  *     
  *
  ***********************************************************************/
HDC Game_GetGameDc(HGAME hGame)
{
	PGAME_INTERNAL pGameInternal = (PGAME_INTERNAL)hGame;

    return GDI_GetDC(pGameInternal->GameScreen.hGameScreen);
}

 /***********************************************************************
  * Game_Init
  *  
  *    
  *
  * Parameters
  *     
  * 
  * Return Value
  *     
  *
  ***********************************************************************/
void Game_ReleaseGameDc(HGAME hGame, HDC hGameDC)
{
	PGAME_INTERNAL pGameInternal = (PGAME_INTERNAL)hGame;
	GDI_ReleaseDC(pGameInternal->GameScreen.hGameScreen);
}

 /***********************************************************************
  * Game_Init
  *  
  *    
  *
  * Parameters
  *     
  * 
  * Return Value
  *     
  *
  ***********************************************************************/
BOOL Game_MessageLoop(HGAME hGame)
{
	PGAME_INTERNAL pGameInternal = (PGAME_INTERNAL)hGame;
	BOOL bContinue = TRUE;


	{
		 MSG Msg;
		 BOOL bThunkMessageLoop = TRUE;

		 SetTimer(pGameInternal->hWnd, 1, 1000/30, NULL);

		 while(bThunkMessageLoop)
		 {
			if(GetMessage(&Msg, 0, 0, 0) > 0)
			{
				if(Msg.message == WM_SWITCH_GAME_STATE)
				{
					bThunkMessageLoop = FALSE;
				}

				TranslateMessage(&Msg);
				DispatchMessage(&Msg);

				Game_GameLoop(pGameInternal);

			}
			else
			{
				bThunkMessageLoop = FALSE;
				bContinue         = FALSE;
			}
		 }

		 KillTimer(pGameInternal->hWnd, 1);
	}

	return bContinue;
}

 /***********************************************************************
  * Game_GameLoop
  *  
  *    
  *
  * Parameters
  *     
  * 
  * Return Value
  *     
  *
  ***********************************************************************/
BOOL Game_GameLoop(PGAME_INTERNAL pGameInternal)
{
	if(pGameInternal->bUpArrow)
	{
		RayLevel_Move(pGameInternal->hRayLevel, MAIN_SPRITE, 5);
	}

	if(pGameInternal->bDownArrow)
	{
		RayLevel_Move(pGameInternal->hRayLevel, MAIN_SPRITE, -5);
	}

	if(pGameInternal->bLeftArrow)
	{
		RayLevel_Turn(pGameInternal->hRayLevel, MAIN_SPRITE, 5);
	}

	if(pGameInternal->bRightArrow)
	{
		RayLevel_Turn(pGameInternal->hRayLevel, MAIN_SPRITE, -5);
	}


	pGameInternal->pScreenBuffer = (DWORD *)GDI_BeginPaint(pGameInternal->GameScreen.hGameScreen);
	memset(pGameInternal->pScreenBuffer, 0, GAME_WIDTH*GAME_HEIGHT*sizeof(DWORD));
    
	RayLevel_DrawScene(pGameInternal->hRayLevel, pGameInternal->pScreenBuffer);

	GDI_EndPaint(pGameInternal->GameScreen.hGameScreen);

	pGameInternal->pScreenBuffer = NULL;
	
	InvalidateRect(pGameInternal->hWnd, NULL, FALSE);

	return TRUE;
}

 /***********************************************************************
  * Game_Init
  *  
  *    
  *
  * Parameters
  *     
  * 
  * Return Value
  *     
  *
  ***********************************************************************/
void Game_DispatchMenuSelections(HGAME hGame, UINT uiMenuSelection)
{
	PGAME_INTERNAL pGameInternal = (PGAME_INTERNAL)hGame;
}

 /***********************************************************************
  * Game_Init
  *  
  *    
  *
  * Parameters
  *     
  * 
  * Return Value
  *     
  *
  ***********************************************************************/
BOOL Game_FadeTitleScreen(HGAME hGame)
{
	return FALSE;
}
/***********************************************************************
 * Game_Debug
 *  
 *    Debug Shit
 *
 *    
 *
 * Parameters
 *     Debug
 *
 * Return Value
 *     Nothing
 *
 ***********************************************************************/
 void Game_Debug(char *pszFormatString, ...)
 {
     char DebugString[256];
     va_list vl;

     va_start(vl, pszFormatString);
     vsprintf(DebugString, pszFormatString, vl);
     va_end(vl);

     OutputDebugStringA(DebugString);
 }





/***********************************************************************
 * Game_HandleMenuCommands
 *  
 *    
 *
 *    
 *
 * Parameters
 *     Debug
 *
 * Return Value
 *     Nothing
 *
 ***********************************************************************/
void Game_HandleMenuCommands(HGAME hGame, USHORT Command, LPARAM lParam)
{
	PGAME_INTERNAL pGameInternal = (PGAME_INTERNAL)hGame;

	switch(Command)
	{
		case IDM_EXIT:
			 SendMessage(pGameInternal->hWnd, WM_CLOSE, 0, 0);
			 break;
	}
}











	
    
