

#include <windows.h>
#include <stdio.h>
#include <stdlib.h>
#include <raycaster.h>


DWORD g_LevelMap[] =
{
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1,
	1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1,
	1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 0, 0, 1,
	1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 1,
	1, 0, 1, 0, 0, 1, 1, 1, 0, 0, 1, 0, 0, 0, 1, 0, 0, 1,
	1, 0, 1, 0, 0, 0, 0, 1, 0, 0, 1, 0, 0, 0, 1, 0, 0, 1,
	1, 0, 1, 0, 0, 0, 0, 1, 0, 0, 1, 0, 0, 0, 1, 0, 0, 1,
	1, 0, 1, 0, 0, 0, 0, 1, 0, 0, 1, 0, 0, 0, 1, 0, 0, 1,
	1, 0, 1, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 1, 0, 0, 1,
	1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 1,
	1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1,
	1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1,
	1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1
};

DWORD g_LevelMapMod[15*18];

/******************************************************* 
 * Internal Prototypes
 *******************************************************/
void WINAPI DrawLine(HRAYCAST hRayCast, PDRAW_CONTEXT pDrawContext);

/**********************************************************************
 *
 *  main
 *
 *
 *
 **********************************************************************/
int __cdecl main(void)
{
	HRAYCAST hRayCast;
	RAYCAST_INIT RayCastInit = {0};

	RayCastInit.LevelSizeX = 18;
	RayCastInit.LevelSizeY = 15;
	RayCastInit.CellSizeX = 48;
	RayCastInit.CellSizeY = 48;
	RayCastInit.pfnDrawWallSlice = DrawLine;
	RayCastInit.CellLocationX = 0;
	RayCastInit.CellLocationY = 0;
	RayCastInit.DirectionAngle = 90;
	RayCastInit.pdwLevelMap = g_LevelMap;
	RayCastInit.pContext = NULL;
	RayCastInit.CellIndexX = 1;
	RayCastInit.CellIndexY = 1;

	hRayCast = RayCaster_Init(&RayCastInit);

	if(hRayCast)
	{
		int AngleMod;
		int NumerOfSteps;
		int x;
		int y;
		MAP_LOCATION MapLocation;

		while(1)
		{
			memcpy(g_LevelMapMod, g_LevelMap, sizeof(g_LevelMap));
			printf("Angle Modification\n");
			scanf("%i", &AngleMod);
			RayCaster_Turn(hRayCast, AngleMod);

			printf("Number of Steps\n");
			scanf("%i", &NumerOfSteps);
			RayCaster_Move(hRayCast, NumerOfSteps);

			RayCaster_GetLocation(hRayCast, &MapLocation);
			RayCaster_Cast(hRayCast, 320, 60, 60);

			printf("\n");

			for(y = 0; y < 15; y++)
			{
				for(x = 0; x < 18; x++)
				{
					if(y == MapLocation.CellIndexY && x == MapLocation.CellIndexX)
					{
						printf("%c", 1);
					}
					else
					{
						switch(g_LevelMapMod[x + y*18])
						{
							case 0:
								printf(" ");
								break;
							case 1:
								printf("I");
								break;
							case 2:
								printf("@");
								break;
						}
					}
				}
				printf("\n");
			}
			printf("\n");

			printf("Cell Location (%i, %i)\n", MapLocation.CellLocationX, MapLocation.CellLocationY);
			printf("Cell Index (%i, %i)\n", MapLocation.CellIndexX, MapLocation.CellIndexY);
			printf("Direction Angle %i\n", MapLocation.DirectionAngle);
		}
	}
}




void WINAPI DrawLine(HRAYCAST hRayCast, PDRAW_CONTEXT pDrawContext)
{
	g_LevelMapMod[pDrawContext->CellX + pDrawContext->CellY*18] = 2;	
}



