/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*
  Toby Opferman
 


  http://www.opferman.com
  toby@opferman.com

 

  SCL (Simple Computer Language) Complier (R)

  C Source Code to be compiled with Watcom C/C++ 10.6 for DOS 32-Bit
  
      ---------------------------------------------------------------------
  
   Basic Input And Output File Module.
   
 *-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/



/*-----------------------------------------------------------------------------------*
    HEADER FILES
 *-----------------------------------------------------------------------------------*/
#include "basicio.h"

/*-----------------------------------------------------------------------------------*
  ASSEMBLY PROTOTYPES
 *-----------------------------------------------------------------------------------*/
 void GetCursor(char *, char *);
 void SetCursor(char, char);
 void Print(char *);

/*-----------------------------------------------------------------------------------*
    DISPATCH MESSAGE TO THE SCREEN
 *-----------------------------------------------------------------------------------*/
 void DispatchMessage(int Message)
{
  /* Dispatch Message To The Screen */
  switch(Message)
  {
     case DM_COMMANDLINE:
     
          printf(" SCL Compiler\n");
          printf("     Usage:\n");
          printf("   SCL <Input File Name> [Output File Name]\n\n");
          break;
             
     case DM_NOMEMORY :
     
          printf(" Compiler Out Of Memory\n\n");
          break;
     
     case DM_INPUTFILE_ERROR  :

          printf(" Compiler has come across an Input File Error.\n");
          printf(" Either the file does not exist or cannot be read.\n\n");
          break;
     
     case DM_OUTPUTFILE_ERROR :
     
          printf(" Compiler has come across an Output File Error.\n");
          printf(" Either the file already exists or cannot be created.\n\n");
          break;
  }

}


/*-----------------------------------------------------------------------------------*
  DOS GET STRING FROM KEYBOARD
 *-----------------------------------------------------------------------------------*/
 void DOSGetInputString(char *String, int Bytes)
{
   char KeyPress, X[4];
   int Done = 0, Counter = 0;
   char  x, y;
   
   /* Initialize String To Zero */
   String[Counter] = 0;
      
   /* Loop Until Return Is Pressed */
   while(!Done)
   {
   
      switch(KeyPress = getch())
      {
         case '\r' :
         case '\n' : /* Enter      */
             printf("\n"); fflush(stdout);
             Done = 1;
             break;
          
         case '\b' : /* Back Space */
             
             if(Counter)
             {
                GetCursor(&x, &y);
                Counter--;
                String[Counter] = 0;
                
                if(!x)
                {
                  x = 79;
                  y--;
                }
                else
                  x--;
                  
                SetCursor(x,y);
                Print(" $");
                SetCursor(x,y);
                
             }
   
             break;
                   
         default:   /* Key Press   */
             if(Counter + 1 < Bytes)
             {
                *((short *)(String + Counter)) = KeyPress;
                
                sprintf(X, "%c$", KeyPress);
                Print(X);
                
                Counter++;
                
            }
      }
      
   }
   
}


/*-----------------------------------------------------------------------------------*
    ASSEMBLY INLINE FUNCTIONS 
 *-----------------------------------------------------------------------------------*/
#pragma aux GetCursor = \
 "MOV AH, 03"           \
 "XOR BH, BH"           \
 "INT 10h"              \
 "MOV [DI], DL"         \
 "MOV [SI], DH"         \
 PARM [ DI ] [ SI ]     \
 MODIFY [ AH BH DX CX ] ; 
    
#pragma aux SetCursor = \
 "MOV AH, 2"            \
 "XOR BH, BH"           \
 "INT 10h"              \
 PARM [ DL ] [ DH ]     \
 MODIFY [ AH BH ] ;

#pragma aux Print = \
 "MOV AH, 9"        \
 "INT 21h"          \
 PARM [ DX ]        \
 MODIFY [ AH ]  ;





