/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*
  Toby Opferman
 



  http://www.opferman.com
  toby@opferman.com
 


  SCL (Simple Computer Language) Complier (R)

  C Source Code to be compiled with Watcom C/C++ 10.6 for DOS 32-Bit
  
      ---------------------------------------------------------------------
      
   File Input Output Object Source Module.
        
 *-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/




/*-----------------------------------------------------------------------------------*
    HEADER  FILES
 *-----------------------------------------------------------------------------------*/
#include "fileio.h"


/*-----------------------------------------------------------------------------------*
    CHECK FOR FILE EXISTANCE
 *-----------------------------------------------------------------------------------*/
 int FileExists(char *FileName)
{
   FILE *FileHandle;

   /* Check If File Exists */   
   if(FileHandle = fopen(FileName, "r"))
   {
       fclose(FileHandle);
       return -1;
   }
   
   return 0;
}



/*-----------------------------------------------------------------------------------*
    CONVERT SOURCE FILE TO TARGET FILE EXT
 *-----------------------------------------------------------------------------------*/
 int SourceToTarget(char *Source, char *Target)
{
   int Counter;
   
   /* Copy Source To Target */
   strcpy(Target, Source);
   
   Counter = strlen(Target) - 1;
   
   /* Find Dot */
   while(Counter)
   {
       /* Found Dot Seperator */
       if(Target[Counter] == '.')
       {
          strcpy(Target + Counter + 1, OUTPUT_EXTENSION);
          return 0;
       }
          
       Counter--;
   }       
   
   /* No Extension, Create One */
   strcpy(Target + strlen(Target), DOT_OUTPUT_EXTENSION);
   
   return 0;
}

/*-----------------------------------------------------------------------------------*
    CONVERT TARGET FILE TO BACKUP FILE EXT
 *-----------------------------------------------------------------------------------*/
 int TargetToBackup(char *Source, char *Target)
{
   int Counter;
   
   /* Copy Source To Target */
   strcpy(Target, Source);
   
   Counter = strlen(Target) - 1;
   
   /* Find Dot */
   while(Counter)
   {
       /* Found Dot Seperator */
       if(Target[Counter] == '.')
       {
          strcpy(Target + Counter + 1, BACKUP_EXTENSION);
          return 0;
       }
          
       Counter--;
   }       
   
   /* No Extension, Create One */
   strcpy(Target + strlen(Target), DOT_BACKUP_EXTENSION);
   
   return 0;
}




/*-----------------------------------------------------------------------------------*
    CONVERT SOURCE FILE TO LIST FILE EXT
 *-----------------------------------------------------------------------------------*/
 int SourceToList(char *Source, char *Target)
{
   int Counter;
   
   /* Copy Source To Target */
   strcpy(Target, Source);
   
   Counter = strlen(Target) - 1;
   
   /* Find Dot */
   while(Counter)
   {
       /* Found Dot Seperator */
       if(Target[Counter] == '.')
       {
          strcpy(Target + Counter + 1, LIST_EXTENSION);
          return 0;
       }
          
       Counter--;
   }       
   
   /* No Extension, Create One */
   strcpy(Target + strlen(Target), DOT_LIST_EXTENSION);
   
   return 0;
}



