/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*
  Toby Opferman



  http://www.opferman.com
  toby@opferman.com



  SCL (Simple Computer Language) Complier (R)

  C Source Code to be compiled with Watcom C/C++ 10.6 for DOS 32-Bit
  
      ---------------------------------------------------------------------
      
   Main Module Of The aXe langauge compiler source code.
        
 *-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/


/*-----------------------------------------------------------------------------------*
    HEADER  FILES
 *-----------------------------------------------------------------------------------*/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "fileio.h"
#include "basicio.h"
#include "main.h"
#include "scan.h"
#include "compile.h"

/*-----------------------------------------------------------------------------------*
    PROTOTYPES
 *-----------------------------------------------------------------------------------*/
 PFILESTRUCT CheckCommandLine(int, char **);
 PFILESTRUCT PreCheckCommandLine(int, char **);
 void EndOutput(PFILESTRUCT, ERRORSTRUCT);
 void BinaryFree(PNAMESTRUCT);
 
/*-----------------------------------------------------------------------------------*
    MAIN PROGRAM
 *-----------------------------------------------------------------------------------*/
 int main(int argc, char *argv[])
{
   PFILESTRUCT pFileStruct;
   ERRORSTRUCT ErrorStruct;
   ARGSTRUCT ArgStruct;

   /* Clear Memory Of Error Struct */
   ZeroMemory(&ErrorStruct, sizeof(ERRORSTRUCT));

   pFileStruct = PreCheckCommandLine((argc - 1), (argv + 1));
   
   printf("SCL Compiler\n");
   
   memset(&ArgStruct, 0, sizeof(ARGSTRUCT));
   
   ArgStruct.pFileStruct = pFileStruct;
   ArgStruct.pErrorStruct = &ErrorStruct;
   

   /* Compile Program */
   PerformCompile(&ArgStruct);
   
   /* Perform End Message */
   EndOutput(pFileStruct, ErrorStruct);
   
   /* Program Cleanup */
   fclose(pFileStruct->Source);
   fclose(pFileStruct->Target);
   fclose(pFileStruct->List);
   free(pFileStruct);

   if(ArgStruct.pHeadNames)
     BinaryFree(ArgStruct.pHeadNames);
     
   if(ArgStruct.ProgramLine)
     free(ArgStruct.ProgramLine);
     
   if(ArgStruct.ActualToken)
     free(ArgStruct.ActualToken);
     
   return 0;
}


/*-----------------------------------------------------------------------------------*
   PRE CHECK COMMAND LINE ARGUEMENTS
 *-----------------------------------------------------------------------------------*/
 PFILESTRUCT PreCheckCommandLine(int Count, char **CommandLine)
{
   char NewCommand[_MAX_PATH];
   char *NC;
   PFILESTRUCT pFileStruct;
      
   /* Process Command Line Arguements */
   if(!Count)
   {
       NewCommand[0] = 0;

       printf("Source File: "); fflush(stdout);      
       fgets(NewCommand, _MAX_PATH, stdin);
       
       NewCommand[strlen(NewCommand) - 1] = 0;
       
       if(NewCommand[0] != 0)
       {
         NC = NewCommand;
         pFileStruct = CheckCommandLine(1, &NC);
       }
       else
       {
           printf("\n No Source File\n");
           exit(ERROR_CMLINE);
       }
   } 
   else
     pFileStruct = CheckCommandLine(Count, CommandLine);

   
   return pFileStruct;
}


/*-----------------------------------------------------------------------------------*
    CHECK COMMAND LINE ARGUEMENTS
 *-----------------------------------------------------------------------------------*/
 PFILESTRUCT CheckCommandLine(int Count, char **CommandLine)
{
    PFILESTRUCT pFileStruct;
    char Temp[600], Backup[_MAX_PATH];
        
    /* Check Command Arguement Number */   
    if(Count > 2)
    {
        /* Dispatch Error */
        DispatchMessage(DM_COMMANDLINE);
        exit(ERROR_CMLINE);
    }


    /* Check If Input File Exists */
    if(!FileExists(CommandLine[0]))
    {
        /* Dispatch Error */
        DispatchMessage(DM_INPUTFILE_ERROR);
        exit(ERROR_INPUTFILE);
    }
    
    /* Allocate File Structure */
    if(!(pFileStruct = (PFILESTRUCT)malloc(sizeof(FILESTRUCT))))
    {
        /* Dispatch Error */
        DispatchMessage(DM_NOMEMORY);
        exit(ERROR_NOMEM);
    }

    /* Copy Input File */
    strcpy(pFileStruct->SourceFile, CommandLine[0]);

    /* Check If Output File Exists */
    if(Count == 2)
    {
       /* Check To Not Overwrite */
       if(FileExists(CommandLine[1]))
       {  
           /* Create Backup */
           TargetToBackup(CommandLine[1], Backup);
           sprintf(Temp, "copy %s %s /y", CommandLine[1], Backup);
           system(Temp);
       }
       
       /* Copy Output File */
       strcpy(pFileStruct->TargetFile, CommandLine[1]);
    }
    else
    {
       pFileStruct->TargetFile[0] = 0;

       printf("Target File: "); fflush(stdout);
       fgets(pFileStruct->TargetFile, _MAX_PATH, stdin);
       
       pFileStruct->TargetFile[strlen(pFileStruct->TargetFile) - 1] = 0;
             
       if(pFileStruct->TargetFile[0] == 0)
         SourceToTarget(pFileStruct->SourceFile, pFileStruct->TargetFile);       
 
       /* Check If Overwrite Output File */
       if(FileExists(pFileStruct->TargetFile))
       {
           TargetToBackup(pFileStruct->TargetFile, Backup);
           sprintf(Temp, "copy %s %s /y", pFileStruct->TargetFile, Backup);
           system(Temp);           
       }

         
       
    }
    
    SourceToList(pFileStruct->SourceFile, pFileStruct->ListFile);
             
    /* Open Files */
    if(!(pFileStruct->Source = fopen(pFileStruct->SourceFile, "r")))
    {
        /* Dispatch Error */
        DispatchMessage(DM_INPUTFILE_ERROR);
        free(pFileStruct);
        exit(ERROR_INPUTFILE);
        
    }

    if(!(pFileStruct->List = fopen(pFileStruct->ListFile, "w")))
    {
        /* Dispatch Error */
        DispatchMessage(DM_OUTPUTFILE_ERROR);
        free(pFileStruct);
        exit(ERROR_INPUTFILE);
    }

    
    if(!(pFileStruct->Target = fopen(pFileStruct->TargetFile, "w")))
    {
        /* Dispatch Error */
        DispatchMessage(DM_OUTPUTFILE_ERROR);        
        free(pFileStruct);        
        exit(ERROR_OUTPUTFILE);
    }


    /* Return File Structure */
    return pFileStruct;

}



/*-----------------------------------------------------------------------------------*
   END OUTPUT
 *-----------------------------------------------------------------------------------*/
 void EndOutput(PFILESTRUCT pFileStruct, ERRORSTRUCT ErrorStruct)
{
    /* Print Output Evaluations */
    fprintf(pFileStruct->List, "\n\nLexical Errors  %i\n", ErrorStruct.LexicalErrors);
    fprintf(pFileStruct->List, "Syntax Errors   %i\n", ErrorStruct.SyntaxErrors);
    fprintf(pFileStruct->List, "Warnings        %i\n", ErrorStruct.Warnings);

    printf("\n\nLexical Errors  %i\n", ErrorStruct.LexicalErrors);
    printf("Syntax Errors   %i\n", ErrorStruct.SyntaxErrors);
    printf("Warnings        %i\n", ErrorStruct.Warnings);

    /* Print End Message */
    if(ErrorStruct.LexicalErrors || ErrorStruct.SyntaxErrors || ErrorStruct.Warnings)
    {
      fprintf(pFileStruct->List, " Encountered Errors During Compilation\n");
      printf(" Encountered Errors During Compilation check '%s' for details\n", pFileStruct->ListFile);
    }
    else
    {
      fprintf(pFileStruct->List, " Completed Successfully\n");
      printf(" Completed Successfully\n");
      printf(" Completed output file '%s'\n", pFileStruct->TargetFile);
    }
      
    fflush(pFileStruct->List);
}

/*-----------------------------------------------------------------------------------*
   FREE BINARY TREE
 *-----------------------------------------------------------------------------------*/
 void BinaryFree(PNAMESTRUCT pNameStruct)
{
   if(!pNameStruct)
     return;
     
   BinaryFree(pNameStruct->Left);
   BinaryFree(pNameStruct->Right);
   
   free(pNameStruct);
}


