/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*
  Toby Opferman



  http://www.opferman.com
  toby@opferman.com



  SCL (Simple Language Compiler) Complier (R)

  C Source Code to be compiled with Watcom C/C++ 10.6 for DOS 32-Bit
  
      ---------------------------------------------------------------------
  
   Main Constants and Structures Header File
   
 *-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
 
 
#ifndef __MAIN_H__
#define __MAIN_H__

/*-----------------------------------------------------------------------------------*
    HEADER FILES
 *-----------------------------------------------------------------------------------*/
#include <stdio.h>
#include <stdlib.h>
#include <mem.h>

/*-----------------------------------------------------------------------------------*
    MACROS
 *-----------------------------------------------------------------------------------*/
#define ZeroMemory(mem,size)   memset(mem, 0, size)


/*-----------------------------------------------------------------------------------*
    CONSTANTS
 *-----------------------------------------------------------------------------------*/
 
/* Dispatch Message Constants */
#define DM_COMMANDLINE        0
#define DM_NOMEMORY           1
#define DM_INPUTFILE_ERROR    2
#define DM_OUTPUTFILE_ERROR   3

/* Exit Code Constants */
#define ERROR_CMLINE          1  
#define ERROR_NOMEM           2
#define ERROR_INPUTFILE       3
#define ERROR_OUTPUTFILE      4

/* File Extensions */
#define INPUT_EXTENSION       "AXE"
#define OUTPUT_EXTENSION      "C"
#define BACKUP_EXTENSION      "BAK"
#define LIST_EXTENSION        "LST"
#define DOT_INPUT_EXTENSION   ".AXE"
#define DOT_OUTPUT_EXTENSION  ".C"
#define DOT_BACKUP_EXTENSION  ".BAK"
#define DOT_LIST_EXTENSION    ".LST"


extern char *TokenName[];

typedef enum { IDEXPR, LITERALEXPR, TEMPEXPR } EXPR;
typedef enum { DECTYPE, INTTYPE, CHRTYPE, ANYTYPE } DATATYPE;

/*-----------------------------------------------------------------------------------*
    STRUCTURES
 *-----------------------------------------------------------------------------------*/



/* File Structure */ 
typedef struct file_struct_type {

 char SourceFile[_MAX_PATH];
 char TargetFile[_MAX_PATH];
 char ListFile[_MAX_PATH];
 FILE *List;
 FILE *Target;
 FILE *Source;
 
} FILESTRUCT, *PFILESTRUCT;

/* Error Structure */
typedef struct error_struct_type {
    
 short LexicalErrors;
 short SyntaxErrors;
 short Warnings;
 
} ERRORSTRUCT, *PERRORSTRUCT;

/* Names Structure */
typedef struct names_struct_type {

  char *Name;
  DATATYPE DataType;
  int Size;
  struct names_struct_type *Left, *Right;
  
 
} NAMESTRUCT, *PNAMESTRUCT;


/* Agruement Structure */
typedef struct arguement_struct_type {
    
    char *ActualToken;
    int ATSize, ATIndex;
    int LineCounter;
    int CurTemp, MaxTemp;
    
    PNAMESTRUCT pHeadNames;
    PFILESTRUCT pFileStruct;
    PERRORSTRUCT pErrorStruct;
    
    char *ProgramLine;
    int PSize, PIndex;
    int HeadFlag;
    DATATYPE DataType;
    int Size;

} ARGSTRUCT, *PARGSTRUCT ;


  /* Expression Structure */
typedef struct expression_record_type {
    
   EXPR Type;
   DATATYPE DataType;
   int  Size;
   char *Name;
   int InitVal;  
   float InitValReal;

   
} EXPRECSTRUCT, *PEXPRECSTRUCT;

  /* Operator Structure */
typedef struct operator_record_type {
    
   char  Op[2];

} OPRECSTRUCT, *POPRECSTRUCT;



#endif



 
 
