/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*
  Toby Opferman



  http://www.opferman.com
  toby@opferman.com


  SCL (Simple Computer Language) Complier (R)

  C Source Code to be compiled with Watcom C/C++ 10.6 for DOS 32-Bit
  
      ---------------------------------------------------------------------
  
   Parser
   
 *-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/



/*-----------------------------------------------------------------------------------*
    HEADER FILES
 *-----------------------------------------------------------------------------------*/
#include "parser.h"



/*-----------------------------------------------------------------------------------*
   PROGRAM ROUTINE
 *-----------------------------------------------------------------------------------*/
 void Program(PARGSTRUCT pArgStruct)
{


     /* Statement Program List */
     Match(pArgStruct, BEGIN);
     pArgStruct->HeadFlag = 1;
     ProgramHead(pArgStruct);

#ifndef __TESTHEAD__
     pArgStruct->HeadFlag = 0;
     StatementList(pArgStruct);
#endif

     Match(pArgStruct, END);

}






#ifndef __TESTHEAD__

/*-----------------------------------------------------------------------------------*
   STATEMENT LIST
 *-----------------------------------------------------------------------------------*/
 void StatementList(PARGSTRUCT pArgStruct)
{
    int Done = 0;

    /* Loop Until Read a Line Not Valid */
    while(!Done)
    {
        switch(Scan(pArgStruct))
        {
            case ID:
            case READ:
            case WRITE:
            case WHEN:
            case REPEAT:
               Statements(pArgStruct);
               break;
               
            default:
               Done = 1;
               break;              
        }
    }
}






/*-----------------------------------------------------------------------------------*
   STATEMENTS
 *-----------------------------------------------------------------------------------*/
 void Statements(PARGSTRUCT pArgStruct)
{
   EXPRECSTRUCT Exp, Exp2;
   int CurrentTemp, CurTemp2;
   char *Cond, *LoopName;
   
    /* Read Line In */
    switch(Scan(pArgStruct))
    {
        case WHEN:
             CurrentTemp = pArgStruct->CurTemp;
             Match(pArgStruct, WHEN);
             

             Cond = ProcessCondition(pArgStruct);
             
             CurTemp2 = pArgStruct->CurTemp;
             
             Generate(3, pArgStruct, "if(", Cond, ")\n{");
             
             free(Cond);
             
             StatementList(pArgStruct);
             
             if(Scan(pArgStruct) == ELSE)
             {
                 /* Close Scope */
                 while(pArgStruct->CurTemp > CurTemp2)
                 {
                    Generate(1, pArgStruct, "}");
                    pArgStruct->CurTemp--;
                 }
                 
                 Generate(1, pArgStruct, "}\n else \n {");
                 StatementList(pArgStruct);

             }

             Match(pArgStruct, WEND);
             Match(pArgStruct, SEMICOLON);

             /* Close Scope */
             while(pArgStruct->CurTemp > CurrentTemp)
             {
                 Generate(1, pArgStruct, "}");
                 pArgStruct->CurTemp--;
             }

             /* End IF */
             Generate(1, pArgStruct, "}");

             break;
             
        case REPEAT:
             CurrentTemp = pArgStruct->CurTemp;        
             Match(pArgStruct, REPEAT);

             LoopName = GetLabel();
             Generate(2, pArgStruct, LoopName, ":");
             
             Cond = ProcessCondition(pArgStruct);
             
             CurTemp2 = pArgStruct->CurTemp;
             
             Generate(3, pArgStruct, "if(", Cond, ")\n{");
             
             free(Cond);

             StatementList(pArgStruct);
                          
             Match(pArgStruct, ENDR);
             Match(pArgStruct, SEMICOLON);
             
             Generate(3, pArgStruct, "goto ", LoopName, ";");
             
             /* Close Scope */
             while(pArgStruct->CurTemp > CurrentTemp)
             {
                 Generate(1, pArgStruct, "}");
                 pArgStruct->CurTemp--;
             }
             
             /* End While */
             Generate(1, pArgStruct, "}");
             
             free(LoopName);
             
             break;
             
         case ID:
         
             CurrentTemp = pArgStruct->CurTemp;
                 
             Match(pArgStruct, ID);
             Exp2 = ProcessID(pArgStruct);
             Match(pArgStruct, ASSIGNOP);
             

             
             Exp = Expression(pArgStruct, Exp2.DataType);
             Match(pArgStruct, SEMICOLON);
             
             AssignID(pArgStruct, Exp2, Exp);

             /* Close Scope */
             while(pArgStruct->CurTemp > CurrentTemp)
             {
                 Generate(1, pArgStruct, "}");
                 pArgStruct->CurTemp--;
             }
                          
             break;
             
        case READ:
             CurrentTemp = pArgStruct->CurTemp;
  
             Match(pArgStruct, READ);
             Match(pArgStruct, LPAREN);
             IdList(pArgStruct);
             Match(pArgStruct, RPAREN);
             Match(pArgStruct, SEMICOLON);

             
             /* Close Scope */
             while(pArgStruct->CurTemp > CurrentTemp)
             {
                 Generate(1, pArgStruct, "}");
                 pArgStruct->CurTemp--;
             }

             break;
             
        case WRITE:
             CurrentTemp = pArgStruct->CurTemp;        
             Match(pArgStruct, WRITE);
             Match(pArgStruct, LPAREN);
             ExpressionList(pArgStruct);
             Match(pArgStruct, RPAREN);
             Match(pArgStruct, SEMICOLON);
             
             
             /* Close Scope */
             while(pArgStruct->CurTemp > CurrentTemp)
             {
                 Generate(1, pArgStruct, "}");
                 pArgStruct->CurTemp--;
             }

             break;
    }
    
}


/*-----------------------------------------------------------------------------------*
   ADD LINE TO BUFFER
 *-----------------------------------------------------------------------------------*/
 void AddLineToBuffer(char **Line, char *String, int *Index, int *Size)
{
  int x = 0;
  
  while(String[x])
    AddToBuffer(Line, String[x++], Index, Size);
}

/*-----------------------------------------------------------------------------------*
   PROCESS CONDITION
 *-----------------------------------------------------------------------------------*/
 char * ProcessCondition(PARGSTRUCT pArgStruct)
{
    EXPRECSTRUCT Exp, Exp2;
    TOKEN Token = ID;
    char *Line = NULL;
    int Index = 0, Size = 0;
    
    do {

    if(Token != ID)
    {
      Match(pArgStruct, Token);
      
      if(Token == AND)
        AddLineToBuffer(&Line, " && ", &Index, &Size);  
      else
        AddLineToBuffer(&Line, " || ", &Index, &Size);
    }
    
    Match(pArgStruct, ID);
    Exp = ProcessID(pArgStruct);
        
    switch(Scan(pArgStruct))
    {
        case EQL:
              Match(pArgStruct, EQL);
              
              Exp2 = Expression(pArgStruct, Exp.DataType);
              
              switch(Exp.DataType)
              {
                  case INTTYPE:
                  case DECTYPE:

                        AddLineToBuffer(&Line, Exp.Name, &Index, &Size);
                        AddLineToBuffer(&Line, " == ", &Index, &Size);
                        AddLineToBuffer(&Line, Exp2.Name, &Index, &Size);
                        
                        free(Exp.Name);
                        free(Exp2.Name);
                        break;
                        
                  case CHRTYPE:
                  
                        if(Exp.Size != Exp2.Size)
                           SyntaxErrorGen(pArgStruct, "Data Size Conflict");
                           
                        if(Exp.Size)
                        {
                           AddLineToBuffer(&Line, " strcmp( ", &Index, &Size);
                           AddLineToBuffer(&Line, Exp.Name, &Index, &Size);
                           AddLineToBuffer(&Line, ",", &Index, &Size);
                           AddLineToBuffer(&Line, Exp2.Name, &Index, &Size);
                           AddLineToBuffer(&Line, ")  == 0 ", &Index, &Size);
                        }
                        else
                        {
                           AddLineToBuffer(&Line, Exp.Name, &Index, &Size);
                           AddLineToBuffer(&Line, " == ", &Index, &Size);
                           AddLineToBuffer(&Line, Exp2.Name, &Index, &Size);
                        }
                           
                        free(Exp.Name);
                        free(Exp2.Name);
              }

           break;
                         
        case LESSEQL:
              Match(pArgStruct, LESSEQL);
              
              Exp2 = Expression(pArgStruct, Exp.DataType);
              
              switch(Exp.DataType)
              {
                  case INTTYPE:
                  case DECTYPE:
                  
                        AddLineToBuffer(&Line, Exp.Name, &Index, &Size);
                        AddLineToBuffer(&Line, " <= ", &Index, &Size);
                        AddLineToBuffer(&Line, Exp2.Name, &Index, &Size);
                        
                        free(Exp.Name);
                        free(Exp2.Name);
                        break;
                        
                  case CHRTYPE:
                  
                        if(Exp.Size != Exp2.Size)
                           SyntaxErrorGen(pArgStruct, "Data Size Conflict");
                           
                        if(Exp.Size)
                        {
                           AddLineToBuffer(&Line, " strcmp( ", &Index, &Size);
                           AddLineToBuffer(&Line, Exp.Name, &Index, &Size);
                           AddLineToBuffer(&Line, ",", &Index, &Size);
                           AddLineToBuffer(&Line, Exp2.Name, &Index, &Size);
                           AddLineToBuffer(&Line, ")  <= 0 ", &Index, &Size);
                        }
                        else
                        {
                           AddLineToBuffer(&Line, Exp.Name, &Index, &Size);
                           AddLineToBuffer(&Line, " <= ", &Index, &Size);
                           AddLineToBuffer(&Line, Exp2.Name, &Index, &Size);
                        }
                           
                        free(Exp.Name);
                        free(Exp2.Name);
              }

           break;
           
        case NOTEQL:
              Match(pArgStruct, NOTEQL);
              
              Exp2 = Expression(pArgStruct, Exp.DataType);
              
              switch(Exp.DataType)
              {
                  case INTTYPE:
                  case DECTYPE:
                  
                        AddLineToBuffer(&Line, Exp.Name, &Index, &Size);
                        AddLineToBuffer(&Line, " != ", &Index, &Size);
                        AddLineToBuffer(&Line, Exp2.Name, &Index, &Size);
                        
                        free(Exp.Name);
                        free(Exp2.Name);
                        break;
                        
                  case CHRTYPE:
                  
                        if(Exp.Size != Exp2.Size)
                           SyntaxErrorGen(pArgStruct, "Data Size Conflict");
                           
                        if(Exp.Size)
                        {
                           AddLineToBuffer(&Line, " strcmp( ", &Index, &Size);
                           AddLineToBuffer(&Line, Exp.Name, &Index, &Size);
                           AddLineToBuffer(&Line, ",", &Index, &Size);
                           AddLineToBuffer(&Line, Exp2.Name, &Index, &Size);
                           AddLineToBuffer(&Line, ")  != 0 ", &Index, &Size);
                        }
                        else
                        {
                           AddLineToBuffer(&Line, Exp.Name, &Index, &Size);
                           AddLineToBuffer(&Line, " != ", &Index, &Size);
                           AddLineToBuffer(&Line, Exp2.Name, &Index, &Size);
                        }
                           
                        free(Exp.Name);
                        free(Exp2.Name);
              }
        
           break;
           
        case GTREQL:
              Match(pArgStruct, GTREQL);
              
              Exp2 = Expression(pArgStruct, Exp.DataType);
              
              switch(Exp.DataType)
              {
                  case INTTYPE:
                  case DECTYPE:
                  
                        AddLineToBuffer(&Line, Exp.Name, &Index, &Size);
                        AddLineToBuffer(&Line, " >= ", &Index, &Size);
                        AddLineToBuffer(&Line, Exp2.Name, &Index, &Size);
                        
                        free(Exp.Name);
                        free(Exp2.Name);
                        break;
                        
                  case CHRTYPE:
                  
                        if(Exp.Size != Exp2.Size)
                           SyntaxErrorGen(pArgStruct, "Data Size Conflict");
                           
                        if(Exp.Size)
                        {
                           AddLineToBuffer(&Line, " strcmp( ", &Index, &Size);
                           AddLineToBuffer(&Line, Exp.Name, &Index, &Size);
                           AddLineToBuffer(&Line, ",", &Index, &Size);
                           AddLineToBuffer(&Line, Exp2.Name, &Index, &Size);
                           AddLineToBuffer(&Line, ")  >= 0 ", &Index, &Size);
                        }
                        else
                        {
                           AddLineToBuffer(&Line, Exp.Name, &Index, &Size);
                           AddLineToBuffer(&Line, " >= ", &Index, &Size);
                           AddLineToBuffer(&Line, Exp2.Name, &Index, &Size);
                        }
                           
                        free(Exp.Name);
                        free(Exp2.Name);
              }
        
           break;
           
        case GTR:
              Match(pArgStruct, GTR);
              
              Exp2 = Expression(pArgStruct, Exp.DataType);
              
              switch(Exp.DataType)
              {
                  case INTTYPE:
                  case DECTYPE:
                  
                        AddLineToBuffer(&Line, Exp.Name, &Index, &Size);
                        AddLineToBuffer(&Line, " > ", &Index, &Size);
                        AddLineToBuffer(&Line, Exp2.Name, &Index, &Size);
                        
                        free(Exp.Name);
                        free(Exp2.Name);
                        break;
                        
                  case CHRTYPE:
                  
                        if(Exp.Size != Exp2.Size)
                           SyntaxErrorGen(pArgStruct, "Data Size Conflict");
                           
                        if(Exp.Size)
                        {
                           AddLineToBuffer(&Line, " strcmp( ", &Index, &Size);
                           AddLineToBuffer(&Line, Exp.Name, &Index, &Size);
                           AddLineToBuffer(&Line, ",", &Index, &Size);
                           AddLineToBuffer(&Line, Exp2.Name, &Index, &Size);
                           AddLineToBuffer(&Line, ")  > 0 ", &Index, &Size);
                        }
                        else
                        {
                           AddLineToBuffer(&Line, Exp.Name, &Index, &Size);
                           AddLineToBuffer(&Line, " > ", &Index, &Size);
                           AddLineToBuffer(&Line, Exp2.Name, &Index, &Size);
                        }
                           
                        free(Exp.Name);
                        free(Exp2.Name);
              }
        
           break;
           
        case LESS:

              Match(pArgStruct, LESS);
              
              Exp2 = Expression(pArgStruct, Exp.DataType);
              
              switch(Exp.DataType)
              {
                  case INTTYPE:
                  case DECTYPE:
                  
                        AddLineToBuffer(&Line, Exp.Name, &Index, &Size);
                        AddLineToBuffer(&Line, " < ", &Index, &Size);
                        AddLineToBuffer(&Line, Exp2.Name, &Index, &Size);
                        
                        free(Exp.Name);
                        free(Exp2.Name);
                        break;
                        
                  case CHRTYPE:
                  
                        if(Exp.Size != Exp2.Size)
                           SyntaxErrorGen(pArgStruct, "Data Size Conflict");
                           
                        if(Exp.Size)
                        {
                           AddLineToBuffer(&Line, " strcmp( ", &Index, &Size);
                           AddLineToBuffer(&Line, Exp.Name, &Index, &Size);
                           AddLineToBuffer(&Line, ",", &Index, &Size);
                           AddLineToBuffer(&Line, Exp2.Name, &Index, &Size);
                           AddLineToBuffer(&Line, ")  < 0 ", &Index, &Size);
                        }
                        else
                        {
                           AddLineToBuffer(&Line, Exp.Name, &Index, &Size);
                           AddLineToBuffer(&Line, " < ", &Index, &Size);
                           AddLineToBuffer(&Line, Exp2.Name, &Index, &Size);
                        }
                           
                        free(Exp.Name);
                        free(Exp2.Name);
              }
        
           break;
           
        default:
           SyntaxError(pArgStruct, "Expected Logical Operator");
    }
    
    Token = Scan(pArgStruct);
    
    } while(Token == AND || Token == OR);
    
    return Line;
}
 

/*-----------------------------------------------------------------------------------*
   EXPRESSION
 *-----------------------------------------------------------------------------------*/
 EXPRECSTRUCT Expression(PARGSTRUCT pArgStruct, DATATYPE DataType)
{
    TOKEN Token;
    EXPRECSTRUCT Exp, Exp2;
    OPRECSTRUCT Op;
    
    if(DataType == ANYTYPE)
    {
       Token = Scan(pArgStruct);
       
       if(Token == CHRLITERAL || Token == I2C)
         DataType = CHRTYPE;
         
    }
       
    if(DataType == CHRTYPE)
    {
         switch(Scan(pArgStruct))
         {
             case CHRLITERAL:
               Match(pArgStruct, CHRLITERAL);
               Exp = ProcessLiteral(pArgStruct, CHRTYPE);
               break;
               
             case I2C:
               Match(pArgStruct, I2C);
               Match(pArgStruct, LPAREN);
               Exp2 = Expression(pArgStruct, INTTYPE);
               Match(pArgStruct, RPAREN);
               
               Exp.Name = GetTemp(pArgStruct, CHRTYPE);
               Exp.DataType = CHRTYPE;
               Exp.Size = 1;
               
               Generate(5, pArgStruct, "sprintf(", Exp.Name, ",\"%i\",", Exp2.Name, ");");
               free(Exp2.Name);
               
               break;
               
             default:
               SyntaxError(pArgStruct, "Expected Character Literal Expression");
               break;
         }
    }
    else
    {
    
      Exp = Primary(pArgStruct, DataType);
      
      if(DataType == ANYTYPE)
        DataType = Exp.DataType;
        
      if(Exp.DataType != DataType)
        SyntaxErrorType(pArgStruct, DataType, Exp.DataType);
    
      /* Loop Through Expression */
      for(Token = Scan(pArgStruct); Token == MULTOP || Token == DIVOP || Token == PLUSOP || Token == MINUSOP;Token = Scan(pArgStruct))
      {
        Op = Operation(pArgStruct);

        /* Operator Precidence */
        if(Op.Op[0] == '+' || Op.Op[0] == '-')
           Exp2 = Expression(pArgStruct,DataType);
        else
           Exp2 = Primary(pArgStruct, DataType);
        
        if(Exp2.DataType != DataType)
          SyntaxErrorType(pArgStruct, DataType, Exp2.DataType);
        
        Exp = GenInfix(pArgStruct, Exp, Op, Exp2);
      }
      
    }
    
    return Exp;
}


/*-----------------------------------------------------------------------------------*
   ID LIST
 *-----------------------------------------------------------------------------------*/
 void IdList(PARGSTRUCT pArgStruct)
{
    EXPRECSTRUCT Exp = {0};

    Match(pArgStruct, ID);
    
    Exp = ProcessID(pArgStruct);
    ReadID(pArgStruct, Exp);
    
    /* Loop While Commas */
    while(Scan(pArgStruct) == COMMA)
    {
        Match(pArgStruct, COMMA);
        Match(pArgStruct, ID);
        
        Exp = ProcessID(pArgStruct);
        ReadID(pArgStruct, Exp);
    }
}


/*-----------------------------------------------------------------------------------*
   PRIMARY
 *-----------------------------------------------------------------------------------*/
 EXPRECSTRUCT Primary(PARGSTRUCT pArgStruct, DATATYPE DataType)
{
    EXPRECSTRUCT Exp, Exp2;

   /* Find Next Operation */
   switch(Scan(pArgStruct))
   {
       case LPAREN:
       
             Match(pArgStruct, LPAREN);
             Exp = Expression(pArgStruct, DataType);
             Match(pArgStruct, RPAREN);
             
             break;
             
       case ID:
             Match(pArgStruct, ID);
             Exp = ProcessID(pArgStruct);
             break;
             
       case REALLITERAL:
       case INTLITERAL:
       
             if(DataType == INTTYPE)
                Match(pArgStruct, INTLITERAL);
             else if(DataType == DECTYPE)
                     Match(pArgStruct, REALLITERAL);
                   else
                   {
                      DataType = Scan(pArgStruct);
                      Match(pArgStruct, DataType);
                   }
                
             Exp = ProcessLiteral(pArgStruct, DataType);
             
             break;
             
       case C2I:
       
             if(DataType == INTTYPE || DataType == ANYTYPE)
             {
               Match(pArgStruct, C2I);
               Match(pArgStruct, LPAREN);
               Exp2 = Expression(pArgStruct, CHRTYPE);
               Match(pArgStruct, RPAREN);
               
               Exp.Name = GetTemp(pArgStruct, INTTYPE);
               Exp.Size = 0;
               Exp.DataType = INTTYPE;
               
               Generate(4, pArgStruct, Exp.Name, " = atoi(", Exp2.Name, ");");
               
             }
             else
               Match(pArgStruct, REALLITERAL);
             
             break;
             
       case D2I:
             if(DataType == INTTYPE  || DataType == ANYTYPE)
             {
               Match(pArgStruct, D2I);
               Match(pArgStruct, LPAREN);
               Exp2 = Expression(pArgStruct, DECTYPE);
               Match(pArgStruct, RPAREN);
               
               Exp.Name = GetTemp(pArgStruct, INTTYPE);
               Exp.Size = 0;
               Exp.DataType = INTTYPE;
               
               Generate(4, pArgStruct, Exp.Name, " = (int)", Exp2.Name, ";");
               
             }
             else
               Match(pArgStruct, REALLITERAL);
             break;
             
       case I2D:
       
             if(DataType == DECTYPE  || DataType == ANYTYPE)
             {
               Match(pArgStruct, I2D);
               Match(pArgStruct, LPAREN);
               Exp2 = Expression(pArgStruct, INTTYPE);
               Match(pArgStruct, RPAREN);
               
               Exp.Name = GetTemp(pArgStruct, DECTYPE);
               Exp.Size = 0;
               Exp.DataType = DECTYPE;
               
               Generate(4, pArgStruct, Exp.Name, " = (float)", Exp2.Name, ";");
               
             }
             else
               Match(pArgStruct, INTLITERAL);
             
             break;             
       
       default:
             Match(pArgStruct, UNKNOWN);
             memset(&Exp, 0, sizeof(EXPRECSTRUCT));
             SyntaxError(pArgStruct, "Expecting '(', ID, or INTLITERAL");
       
   }

   return Exp;
}



/*-----------------------------------------------------------------------------------*
   OPERATION
 *-----------------------------------------------------------------------------------*/
 OPRECSTRUCT Operation(PARGSTRUCT pArgStruct)
{
   TOKEN Token;
   OPRECSTRUCT Op;
   
   Token = Scan(pArgStruct);

   if(Token == PLUSOP || Token == MINUSOP || Token == MULTOP || Token == DIVOP)
   {
     Match(pArgStruct, Token);
     Op = ProcessOp(Token);
   }
   else
   {
       strcpy(Op.Op, "?");
       Match(pArgStruct, UNKNOWN);
       SyntaxError(pArgStruct, "Expecting '+', '-', '/' or '*'");
   }

   return Op;
    
}

/*-----------------------------------------------------------------------------------*
   PROCESS OP
 *-----------------------------------------------------------------------------------*/
 OPRECSTRUCT ProcessOp(TOKEN Token)
{
  OPRECSTRUCT Op;
  
  switch(Token)
  {
      case PLUSOP:
         strcpy(Op.Op,"+");
         break;
         
      case MULTOP:
         strcpy(Op.Op,"-");
         break;
         
      case DIVOP:
         strcpy(Op.Op, "/");
         break;
         
      case MINUSOP:
         strcpy(Op.Op, "-");
         break;
  }
  
  return Op;
}

/*-----------------------------------------------------------------------------------*
   EXPRESSION LIST
 *-----------------------------------------------------------------------------------*/
 void ExpressionList(PARGSTRUCT pArgStruct)
{
    EXPRECSTRUCT Exp;
    
    Exp = Expression(pArgStruct, ANYTYPE);
    
    WriteExp(pArgStruct, Exp);
    
    /* Loop While Commas */
    while(Scan(pArgStruct) == COMMA)
    {
        Match(pArgStruct, COMMA);
        Exp = Expression(pArgStruct, ANYTYPE);
        WriteExp(pArgStruct, Exp);
        pArgStruct->CurTemp = 0;
    }
   
}

#endif

/*-----------------------------------------------------------------------------------*
   MATCH
 *-----------------------------------------------------------------------------------*/
 void Match(PARGSTRUCT pArgStruct, TOKEN Token)
{
  TOKEN NewToken;
  char ErrorString[100];
  int x;
    
  /* Get Token */
  NewToken = RemoveScan(pArgStruct);

  /* Quick Exit */
  if(Token == UNKNOWN)
    return;


  /* Check If Token Is Correct */
  if(NewToken != Token)
  {
    sprintf(ErrorString, "Expecting '%s'", TokenName[Token]);
    SyntaxError(pArgStruct, ErrorString);
  }

  /* Add To Line */
  switch(NewToken)
  {
      case SEMICOLON :
      case SCANEOF:
          if(pArgStruct->ProgramLine)
          {
             pArgStruct->ProgramLine[0] = 0;
             pArgStruct->PIndex = 0;
          }
          break;
                
      case BEGIN:
          Start(pArgStruct);
          if(pArgStruct->ProgramLine)
          {
             pArgStruct->ProgramLine[0] = 0;
             pArgStruct->PIndex = 0;
          }
          break;
          
      case END:
          Finish(pArgStruct);
          if(pArgStruct->ProgramLine)
          {
             pArgStruct->ProgramLine[0] = 0;
             pArgStruct->PIndex = 0;
          }
          
          break;
          
      case ID:
      
         if(pArgStruct->HeadFlag)
         {
             if(!Lookup(pArgStruct))
                 Enter(pArgStruct);
             else
             {
                 sprintf(ErrorString, "Variable Already Declared");
                 SyntaxErrorGen(pArgStruct, ErrorString);
             }
         }
         else
         {
             if(!Lookup(pArgStruct))
             {
                 sprintf(ErrorString, "Variable Not Declared");
                 SyntaxErrorGen(pArgStruct, ErrorString);
             }
         }


              
      default:
     
      x = 0;      
      if(pArgStruct->ActualToken)
      {
        while(pArgStruct->ActualToken[x])
           AddToBuffer(&pArgStruct->ProgramLine, pArgStruct->ActualToken[x++], &pArgStruct->PIndex, &pArgStruct->PSize);
           
        AddToBuffer(&pArgStruct->ProgramLine, ' ', &pArgStruct->PIndex, &pArgStruct->PSize);
      }
  }
  
}




/*-----------------------------------------------------------------------------------*
   SYNTAX ERROR
 *-----------------------------------------------------------------------------------*/
 void SyntaxError(PARGSTRUCT pArgStruct, char *ErrorString)
{
    fprintf(pArgStruct->pFileStruct->List, "\nSyntax Error %s But Found %s\n", ErrorString, pArgStruct->ActualToken);
    fflush(pArgStruct->pFileStruct->List);
    pArgStruct->pErrorStruct->SyntaxErrors++;
}

/*-----------------------------------------------------------------------------------*
   TYPE SYNTAX ERROR
 *-----------------------------------------------------------------------------------*/
 void SyntaxErrorType(PARGSTRUCT pArgStruct, DATATYPE Orig, DATATYPE New)
{
    char *Types[] = { "DEC", "INT", "CHR", "ANY" };
    
    fprintf(pArgStruct->pFileStruct->List, "\nSyntax Error Cannot convert types between %s to %s\n", Types[New], Types[Orig]);
    fflush(pArgStruct->pFileStruct->List);
    
    pArgStruct->pErrorStruct->SyntaxErrors++;
}

/*-----------------------------------------------------------------------------------*
   SYNTAX ERROR GENERIC
 *-----------------------------------------------------------------------------------*/
 void SyntaxErrorGen(PARGSTRUCT pArgStruct, char *Error)
{
    
    fprintf(pArgStruct->pFileStruct->List, "\nSyntax Error %s\n", Error);
    fflush(pArgStruct->pFileStruct->List);
    
    pArgStruct->pErrorStruct->SyntaxErrors++;
}

#ifndef __TESTHEAD__


/*-----------------------------------------------------------------------------------*
   GET TEMP
 *-----------------------------------------------------------------------------------*/
 char * GetTemp(PARGSTRUCT pArgStruct, DATATYPE DataType)
{
    char *Memory;
        
    pArgStruct->CurTemp++;
                
    switch(DataType)
    {
        case INTTYPE:
           fprintf(pArgStruct->pFileStruct->Target, "{ int Temp%i;\n", pArgStruct->CurTemp);
           break;
               
        case DECTYPE:
           fprintf(pArgStruct->pFileStruct->Target, "{ float Temp%i;\n", pArgStruct->CurTemp);
           break;
         
        case CHRTYPE:
           fprintf(pArgStruct->pFileStruct->Target, "{ char Temp%i[257];\n", pArgStruct->CurTemp);
           break;
     }


    /* Allocate Temp Name */
    if(!(Memory = (char *)malloc(10)))
    {
       /* Dispatch Error */
        DispatchMessage(DM_NOMEMORY);
        exit(ERROR_NOMEM);      
    }

    sprintf(Memory, "Temp%i", pArgStruct->CurTemp);
    
    return Memory;
}

#endif

/*-----------------------------------------------------------------------------------*
   START ROUTINE
 *-----------------------------------------------------------------------------------*/
 void Start(PARGSTRUCT pArgStruct)
{
   char Line[_MAX_PATH + 50];

   sprintf(Line, "#include<stdio.h>\n#include<string.h>\n#include<stdlib.h>\n\nint main(void) \n {");
       
   Generate(1, pArgStruct, Line);
}


/*-----------------------------------------------------------------------------------*
   FINISH ROUTINE
 *-----------------------------------------------------------------------------------*/
 void Finish(PARGSTRUCT pArgStruct)
{
   Generate(1, pArgStruct, "return 0; \n }");
}

#ifndef __TESTHEAD__

/*-----------------------------------------------------------------------------------*
   READ ID
 *-----------------------------------------------------------------------------------*/
 void ReadID(PARGSTRUCT pArgStruct, EXPRECSTRUCT InRec)
{
   switch(InRec.DataType)
   {
       case INTTYPE:
            Generate(3, pArgStruct, "scanf(\"%d\", &", InRec.Name, ");");
            
          break;
          
       case DECTYPE:
             Generate(3, pArgStruct, "scanf(\"%f\", &", InRec.Name, ");");
          break;
          
       case CHRTYPE:
          if(InRec.Name)
             Generate(3, pArgStruct, "gets(", InRec.Name, ");");
          else
             Generate(3, pArgStruct, "scanf(\"%c\", &", InRec.Name, ");");
          break;
     }
      
   free(InRec.Name);
}


/*-----------------------------------------------------------------------------------*
   ASSIGN ID
 *-----------------------------------------------------------------------------------*/
 void AssignID(PARGSTRUCT pArgStruct, EXPRECSTRUCT Target, EXPRECSTRUCT Source)
{
   if(Target.DataType == CHRTYPE)
   {
       if(Target.Size == Source.Size)
       {
         if(Target.Size)
           Generate(5, pArgStruct, "strcpy(", Target.Name, " , ", Source.Name, ");");                      
         else
           Generate(4, pArgStruct,  Target.Name, " = ", Source.Name, ";");             
       }
       else
         SyntaxErrorGen(pArgStruct, "Data Size Conflict");
   }
   else
     Generate(4, pArgStruct,  Target.Name, " = ", Source.Name, ";");
   
   free(Source.Name);
   free(Target.Name);
}


/*-----------------------------------------------------------------------------------*
   WRITE EXPRESSION
 *-----------------------------------------------------------------------------------*/
 void WriteExp(PARGSTRUCT pArgStruct, EXPRECSTRUCT InRec)
{
    
   switch(InRec.DataType)
   {
       case INTTYPE:
            Generate(3, pArgStruct, "printf(\"%d\", ", InRec.Name, ");");
            
          break;
          
       case DECTYPE:
             Generate(3, pArgStruct, "printf(\"%f\", ", InRec.Name, ");");
          break;
          
       case CHRTYPE:
          if(InRec.Size)
             Generate(3, pArgStruct, "printf(\"%s\",", InRec.Name, ");");
          else
             Generate(3, pArgStruct, "printf(\"%c\", ", InRec.Name, ");");
          break;
   }

   free(InRec.Name);
}

/*-----------------------------------------------------------------------------------*
   GENERATE INFIX
 *-----------------------------------------------------------------------------------*/
 EXPRECSTRUCT GenInfix(PARGSTRUCT pArgStruct, EXPRECSTRUCT Left, OPRECSTRUCT Op, EXPRECSTRUCT Right)
{
    EXPRECSTRUCT Rec;

    Rec.Type = TEMPEXPR;
    Rec.Name = GetTemp(pArgStruct, Left.DataType);

    Rec.DataType = Left.DataType;
        
    Generate(6, pArgStruct, Rec.Name, " = ", Left.Name, Op.Op, Right.Name, ";");
    
    free(Left.Name);
    free(Right.Name);
    
    return Rec;
}

#endif

/*-----------------------------------------------------------------------------------*
   PROCESS LITERAL
 *-----------------------------------------------------------------------------------*/
 EXPRECSTRUCT ProcessLiteral(PARGSTRUCT pArgStruct, DATATYPE DataType)
{
  EXPRECSTRUCT ExpRecStruct;

  ExpRecStruct.Type = LITERALEXPR;
  ExpRecStruct.DataType = DataType;
  
  if(DataType == CHRTYPE)
    ExpRecStruct.Size = 1;
  else
    ExpRecStruct.Size = 0;
    
  /* Allocate Token Name */
  if(!(ExpRecStruct.Name = (char *)malloc(strlen(pArgStruct->ActualToken) + 1)))
  {
       /* Dispatch Error */
        DispatchMessage(DM_NOMEMORY);
        exit(ERROR_NOMEM);      
  }
  
  strcpy(ExpRecStruct.Name, pArgStruct->ActualToken);

  return ExpRecStruct;
}


/*-----------------------------------------------------------------------------------*
   PROCESS ID
 *-----------------------------------------------------------------------------------*/
 EXPRECSTRUCT ProcessID(PARGSTRUCT pArgStruct)
{
  EXPRECSTRUCT ExpRecStruct, Exp;
  
  ExpRecStruct.Type = IDEXPR;

  /* Allocate Token Name */
  if(!(ExpRecStruct.Name = (char *)malloc(strlen(pArgStruct->ActualToken) + 1)))
  {
       /* Dispatch Error */
        DispatchMessage(DM_NOMEMORY);
        exit(ERROR_NOMEM);      
  }
  
  strcpy(ExpRecStruct.Name, pArgStruct->ActualToken);
  ExpRecStruct.DataType = pArgStruct->DataType;

  
  if(ExpRecStruct.Size = pArgStruct->Size)
  {
      if(ExpRecStruct.DataType == CHRTYPE)
      {
        if(Scan(pArgStruct) == LBRACE && ExpRecStruct.Size)
        {
            Match(pArgStruct, LBRACE);
            Exp = Expression(pArgStruct, INTTYPE);
            Match(pArgStruct, RBRACE);
            
            if(!(ExpRecStruct.Name = (char *)realloc(ExpRecStruct.Name, strlen(ExpRecStruct.Name) + strlen(Exp.Name) + 3)))
            {
                /* Dispatch Error */
                DispatchMessage(DM_NOMEMORY);
               exit(ERROR_NOMEM);      
            }
            
            sprintf(ExpRecStruct.Name + strlen(ExpRecStruct.Name), "[%s]", Exp.Name);
            free(Exp.Name);
            ExpRecStruct.Size = 0;
        }
        else if(!ExpRecStruct.Size)
        {
            if(!(ExpRecStruct.Name = (char *)realloc(ExpRecStruct.Name, strlen(ExpRecStruct.Name) +  4)))
            {
                /* Dispatch Error */
                DispatchMessage(DM_NOMEMORY);
                exit(ERROR_NOMEM);      
            }
            
            sprintf(ExpRecStruct.Name + strlen(ExpRecStruct.Name), "[0]", Exp.Name);
            ExpRecStruct.Size = 0;
        }
      }     
      else
      {
         Match(pArgStruct, LBRACE);
         Exp = Expression(pArgStruct, INTTYPE);
         Match(pArgStruct, RBRACE);
            
         if(!(ExpRecStruct.Name = (char *)realloc(ExpRecStruct.Name, strlen(ExpRecStruct.Name) + strlen(Exp.Name) + 3)))
         {
             /* Dispatch Error */
             DispatchMessage(DM_NOMEMORY);
             exit(ERROR_NOMEM);      
         }
            
         sprintf(ExpRecStruct.Name + strlen(ExpRecStruct.Name), "[%s]", Exp.Name);
         free(Exp.Name);
         ExpRecStruct.Size = 0;
      }
  }
  
  return ExpRecStruct;
}


/*-----------------------------------------------------------------------------------*
   GET LABEL
 *-----------------------------------------------------------------------------------*/
 char * GetLabel(void)
{
    static int Number = 0;
    char *Memory = NULL;
        
    Number++;
                
    /* Allocate Temp Name */
    if(!(Memory = (char *)malloc(10)))
    {
       /* Dispatch Error */
        DispatchMessage(DM_NOMEMORY);
        exit(ERROR_NOMEM);      
    }

    sprintf(Memory, "loop%i", Number);
    
    return Memory;
}

