/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*
  Toby Opferman
  


  http://www.opferman.com
  toby@opferman.com

 

  SCL (Simple Computer Language) Complier (R)

  C Source Code to be compiled with Watcom C/C++ 10.6 for DOS 32-Bit
  
      ---------------------------------------------------------------------
  
   Parser File Parse the Syntax
   
 *-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
 
 
#ifndef __PARSER_H__
#define __PARSER_H__

/*-----------------------------------------------------------------------------------*
    HEADER FILES
 *-----------------------------------------------------------------------------------*/
#include "main.h"
#include "compile.h"
#include "fileio.h"
#include "basicio.h"
#include <stdio.h>
#include <stdlib.h>
#include <mem.h>
#include <stdarg.h>

/*-----------------------------------------------------------------------------------*
    PROTOTYPES
 *-----------------------------------------------------------------------------------*/
 void StatementList(PARGSTRUCT);
 void Statements(PARGSTRUCT);
 void Program(PARGSTRUCT);
 EXPRECSTRUCT Expression(PARGSTRUCT, DATATYPE);
 OPRECSTRUCT Operation(PARGSTRUCT);
 void IdList(PARGSTRUCT);
 void ExpressionList(PARGSTRUCT);
 EXPRECSTRUCT Primary(PARGSTRUCT, DATATYPE);
 void SyntaxError(PARGSTRUCT, char *);
 void Match(PARGSTRUCT, TOKEN);
 void Start(PARGSTRUCT);
 void Finish(PARGSTRUCT);
 void Generate(short, PARGSTRUCT, ...);
 void WriteExp(PARGSTRUCT, EXPRECSTRUCT);
 char *GetTemp(PARGSTRUCT, DATATYPE);
 void ReadID(PARGSTRUCT, EXPRECSTRUCT);
 void WriteExp(PARGSTRUCT, EXPRECSTRUCT);
 void AssignID(PARGSTRUCT, EXPRECSTRUCT, EXPRECSTRUCT);
 EXPRECSTRUCT ProcessLiteral(PARGSTRUCT, DATATYPE);
 EXPRECSTRUCT ProcessID(PARGSTRUCT);
 EXPRECSTRUCT GenInfix(PARGSTRUCT, EXPRECSTRUCT, OPRECSTRUCT, EXPRECSTRUCT);
 OPRECSTRUCT ProcessOp(TOKEN);
 int BranchCheck(PARGSTRUCT, PNAMESTRUCT);
 void BranchAdd(PARGSTRUCT, PNAMESTRUCT);
 int Lookup(PARGSTRUCT);
 void Enter(PARGSTRUCT);
 void ProgramHead(PARGSTRUCT);
 void HeadStatements(PARGSTRUCT);
 void DeclareInt(PARGSTRUCT, EXPRECSTRUCT);
 void IntStatementList(PARGSTRUCT);
 void DeclareChr(PARGSTRUCT, EXPRECSTRUCT);
 void ChrStatementList(PARGSTRUCT);
 void DeclareDec(PARGSTRUCT, EXPRECSTRUCT);
 void DecStatementList(PARGSTRUCT);
 void SetArray(PARGSTRUCT, EXPRECSTRUCT);
 void BranchSet(EXPRECSTRUCT, PNAMESTRUCT);
 char * ProcessCondition(PARGSTRUCT);
 void AddLineToBuffer(char **, char *, int *, int *);
 char * GetLabel(void);
 void SyntaxErrorGen(PARGSTRUCT, char *);
 void SyntaxErrorType(PARGSTRUCT, DATATYPE, DATATYPE);
  
#endif


