/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*
  Toby Opferman
 


  http://www.opferman.com
  toby@opferman.com



  SCL (Simple Computer Language) Complier (R)

  C Source Code to be compiled with Watcom C/C++ 10.6 for DOS 32-Bit
  
      ---------------------------------------------------------------------
  
   Program Head
   
 *-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/



/*-----------------------------------------------------------------------------------*
    HEADER FILES
 *-----------------------------------------------------------------------------------*/
#include "parser.h"



/*-----------------------------------------------------------------------------------*
   PROGRAM HEAD ROUTINE
 *-----------------------------------------------------------------------------------*/
 void ProgramHead(PARGSTRUCT pArgStruct)
{
    int Done = 0;

    /* Loop Until Read a Line Not Valid */
    while(!Done)
    {
        switch(Scan(pArgStruct))
        {
            case DEC:
            case INT:
            case CHR:
               HeadStatements(pArgStruct);
               break;
            default:
               Done = 1;
               break;              
        }
    }
}


/*-----------------------------------------------------------------------------------*
   PROGRAM HEAD STATEMENTS
 *-----------------------------------------------------------------------------------*/
 void HeadStatements(PARGSTRUCT pArgStruct)
{
     
     switch(Scan(pArgStruct))
     {
            case DEC:
               Match(pArgStruct, DEC);
               pArgStruct->DataType = DECTYPE;
               DecStatementList(pArgStruct);
               Match(pArgStruct, SEMICOLON);
               break;
               
            case INT:
               Match(pArgStruct, INT);
               pArgStruct->DataType = INTTYPE;               
               IntStatementList(pArgStruct);
               Match(pArgStruct, SEMICOLON);
               break;
               
            case CHR:
               Match(pArgStruct, CHR);
               pArgStruct->DataType = CHRTYPE;               
               ChrStatementList(pArgStruct);
               Match(pArgStruct, SEMICOLON);
               break;
     }
}


/*-----------------------------------------------------------------------------------*
   STATEMENT DECLARE LIST
 *-----------------------------------------------------------------------------------*/
 void IntStatementList(PARGSTRUCT pArgStruct)
{
    EXPRECSTRUCT Exp;
    
    pArgStruct->DataType = INTTYPE;
    
    Match(pArgStruct, ID);
    Exp = ProcessID(pArgStruct);
    Exp.InitVal = 0;
    Exp.Size = 0;
    
    switch(Scan(pArgStruct))
    {
        case SEMICOLON:
        case COMMA:
             DeclareInt(pArgStruct, Exp);
             break;
             
        case LBRACE:
       
             Match(pArgStruct, LBRACE);
             Match(pArgStruct, INTLITERAL);
             Exp.Size = atoi(pArgStruct->ActualToken);
             Match(pArgStruct, RBRACE);
             
             SetArray(pArgStruct, Exp);
             
             DeclareInt(pArgStruct, Exp);
             break;
             
        case ASSIGNOP:
             Match(pArgStruct, ASSIGNOP);
             Match(pArgStruct, INTLITERAL);
             Exp.InitVal = atoi(pArgStruct->ActualToken);
             DeclareInt(pArgStruct, Exp);
             
             break;
            
    }
        
    /* Loop While Commas */
    while(Scan(pArgStruct) == COMMA)
    {
        
       Match(pArgStruct, COMMA);
       Match(pArgStruct, ID);
       Exp = ProcessID(pArgStruct);
       Exp.InitVal = 0;
       Exp.Size = 0;
    
       switch(Scan(pArgStruct))
       {
           case SEMICOLON:
           case COMMA:
                DeclareInt(pArgStruct, Exp);
                break;
              
           case LBRACE:
          
                Match(pArgStruct, LBRACE);
                Match(pArgStruct, INTLITERAL);
                Exp.Size = atoi(pArgStruct->ActualToken);
                Match(pArgStruct, RBRACE);
                
               SetArray(pArgStruct, Exp);
                
                DeclareInt(pArgStruct, Exp);
                break;
             
           case ASSIGNOP:
                Match(pArgStruct, ASSIGNOP);
                Match(pArgStruct, INTLITERAL);
                Exp.InitVal = atoi(pArgStruct->ActualToken);
                DeclareInt(pArgStruct, Exp);
             
                break;
             
       }

        
    }
     
}

/*-----------------------------------------------------------------------------------*
   DECLAR INT ROUTINE
 *-----------------------------------------------------------------------------------*/
 void DeclareInt(PARGSTRUCT pArgStruct, EXPRECSTRUCT Exp)
{
   char Temp[25];
   
   if(Exp.Size)
   {
      itoa(Exp.Size, Temp, 10);
      Generate(5, pArgStruct, "int ", Exp.Name, "[", Temp, "];");
   }
   else
   {
      itoa(Exp.InitVal, Temp, 10);
      Generate(5, pArgStruct, "int ", Exp.Name, " = ", Temp, ";");
   }


}

/*-----------------------------------------------------------------------------------*
   STATEMENT DECLARE LIST
 *-----------------------------------------------------------------------------------*/
 void DecStatementList(PARGSTRUCT pArgStruct)
{
    EXPRECSTRUCT Exp;
    
    pArgStruct->DataType = DECTYPE;
    
    Match(pArgStruct, ID);
    Exp = ProcessID(pArgStruct);
    Exp.InitValReal = 0;
    Exp.Size = 0;
    
    switch(Scan(pArgStruct))
    {
        case SEMICOLON:
        case COMMA:
             DeclareDec(pArgStruct, Exp);
             break;
             
        case LBRACE:
        
             
             Match(pArgStruct, LBRACE);
             Match(pArgStruct, INTLITERAL);
             Exp.Size = atoi(pArgStruct->ActualToken);
             Exp.InitValReal = 0;
             Match(pArgStruct, RBRACE);
             
             SetArray(pArgStruct, Exp);
             
             DeclareDec(pArgStruct, Exp);
             break;
             
        case ASSIGNOP:
            
             Match(pArgStruct, ASSIGNOP);
             Match(pArgStruct, REALLITERAL);
             Exp.InitValReal = atof(pArgStruct->ActualToken);
             
             DeclareDec(pArgStruct, Exp);
             
             break;
            
    }
        
    /* Loop While Commas */
    while(Scan(pArgStruct) == COMMA)
    {
        
        Match(pArgStruct, COMMA);
        Match(pArgStruct, ID);
        
        Exp = ProcessID(pArgStruct);
        Exp.InitValReal = 0;
        Exp.Size = 0;
    
       switch(Scan(pArgStruct))
       {
           case SEMICOLON:
           case COMMA:
               DeclareDec(pArgStruct, Exp);
               break;
             
           case LBRACE:
        
             
               Match(pArgStruct, LBRACE);
               Match(pArgStruct, INTLITERAL);
               Exp.Size = atoi(pArgStruct->ActualToken);
               Exp.InitValReal = 0;
               Match(pArgStruct, RBRACE);
               
               SetArray(pArgStruct, Exp);
               
               DeclareDec(pArgStruct, Exp);
               break;
             
          case ASSIGNOP:
            
               Match(pArgStruct, ASSIGNOP);
               Match(pArgStruct, REALLITERAL);
               Exp.InitValReal = atof(pArgStruct->ActualToken);
             
               DeclareDec(pArgStruct, Exp);
             
               break;
            
         }

        
    }
     
}

/*-----------------------------------------------------------------------------------*
   DECLAR DEC ROUTINE
 *-----------------------------------------------------------------------------------*/
 void DeclareDec(PARGSTRUCT pArgStruct, EXPRECSTRUCT Exp)
{
   char Temp[25];
   
   if(Exp.Size)
   {
      itoa(Exp.Size, Temp, 10);
      Generate(5, pArgStruct, "float ", Exp.Name, "[", Temp, "];");
   }
   else
   {
      sprintf(Temp, "%f", Exp.InitValReal);
      Generate(5, pArgStruct, "float ", Exp.Name, " = ", Temp, ";");
   }


}




/*-----------------------------------------------------------------------------------*
   STATEMENT DECLARE LIST
 *-----------------------------------------------------------------------------------*/
 void ChrStatementList(PARGSTRUCT pArgStruct)
{
    EXPRECSTRUCT Exp;
    
    pArgStruct->DataType = CHRTYPE;
    
    Match(pArgStruct, ID);
    Exp = ProcessID(pArgStruct);
    Exp.Size = 0;
       
    switch(Scan(pArgStruct))
    {
        case SEMICOLON:
        case COMMA:
             strcpy(pArgStruct->ActualToken, "\" \"");
             DeclareChr(pArgStruct, Exp);
             break;
             
        case LBRACE:
             Match(pArgStruct, LBRACE);
             Match(pArgStruct, INTLITERAL);
             Exp.Size = atoi(pArgStruct->ActualToken);
             Match(pArgStruct, RBRACE);
             
             SetArray(pArgStruct, Exp);
             
             DeclareChr(pArgStruct, Exp);
             break;
             
        case ASSIGNOP:
             
             Match(pArgStruct, ASSIGNOP);
             Match(pArgStruct, CHRLITERAL);
             DeclareChr(pArgStruct, Exp);
             
             break;
            
    }
        
    /* Loop While Commas */
    while(Scan(pArgStruct) == COMMA)
    {
        
       Match(pArgStruct, COMMA);
       Match(pArgStruct, ID);
       Exp = ProcessID(pArgStruct);
       Exp.Size = 0;
       
       switch(Scan(pArgStruct))
       {
           case SEMICOLON:
           case COMMA:
                strcpy(pArgStruct->ActualToken, "\" \"");
                DeclareChr(pArgStruct, Exp);
                break;
             
           case LBRACE:
                Match(pArgStruct, LBRACE);
                Match(pArgStruct, INTLITERAL);
                Exp.Size = atoi(pArgStruct->ActualToken);
                Match(pArgStruct, RBRACE);
                
                SetArray(pArgStruct, Exp);
                
                DeclareChr(pArgStruct, Exp);
                break;
              
           case ASSIGNOP:
             
                Match(pArgStruct, ASSIGNOP);
                Match(pArgStruct, CHRLITERAL);
                DeclareChr(pArgStruct, Exp);
               
                break;
            
       }

        
    }
     
}

/*-----------------------------------------------------------------------------------*
   DECLARE CHAR ROUTINE
 *-----------------------------------------------------------------------------------*/
 void DeclareChr(PARGSTRUCT pArgStruct, EXPRECSTRUCT Exp)
{
   char Temp[25];
   
   if(Exp.Size)
   {
      itoa(Exp.Size, Temp, 10);
      Generate(5, pArgStruct, "char ", Exp.Name, "[", Temp, "];");
   }
   else
      Generate(5, pArgStruct, "char *", Exp.Name, " = ", pArgStruct->ActualToken, ";");

}

