/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*
  Toby Opferman
  



  http://www.opferman.com
  toby@opferman.com
 


  SCL (Simple Computer Language) Complier (R)

  C Source Code to be compiled with Watcom C/C++ 10.6 for DOS 32-Bit
  
      ---------------------------------------------------------------------
      
   Scanner Module Code
        
 *-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/



/*-----------------------------------------------------------------------------------*
    HEADER  FILES
 *-----------------------------------------------------------------------------------*/
#include "scan.h"

/*-----------------------------------------------------------------------------------*
   SCANNER ROUTINE
 *-----------------------------------------------------------------------------------*/
 TOKEN Scan(PARGSTRUCT pArgStruct)
{
    int Found = 0, Char;
    fpos_t Position;    
    TOKEN Token;

    pArgStruct->ATIndex = 0;
    
    /* Save Position */
    fgetpos(pArgStruct->pFileStruct->Source, &Position);
    
    if(!pArgStruct->LineCounter)
    {
       fprintf(pArgStruct->pFileStruct->List, "Line 1: ");
       pArgStruct->LineCounter++;
    }
    
    
    /* Clear Buffer Memory */
    ClearBuffer(pArgStruct->ActualToken);
    
    /* Loop Through File */
    while(!Found)
    {
        /* Load Character */
        Char = fgetc(pArgStruct->pFileStruct->Source);

        /* Check For Alphanumeric ID */
        if(isalpha(Char) || Char == '_')
        {
           Token = ID;
                      
           while(Char != '\n' && Char != EOF && (isalpha(Char) || Char == '_' || isdigit(Char)))
           {
                AddToBuffer(&pArgStruct->ActualToken, Char, &pArgStruct->ATIndex, &pArgStruct->ATSize);
                Char = fgetc(pArgStruct->pFileStruct->Source);
           }
           
           ungetc(Char, pArgStruct->pFileStruct->Source);
           
           Char = 0;
           
           /* Check Reserved Words */
           CheckReserved(pArgStruct->ActualToken, &Token);
            
           Found = 1;    
        }
              
        if(Char == '-' || isdigit(Char))
        {
          if(Char == '-')
          {
            Token = MINUSOP;
            AddToBuffer(&pArgStruct->ActualToken, Char, &pArgStruct->ATIndex, &pArgStruct->ATSize);
          
            Char = fgetc(pArgStruct->pFileStruct->Source);
          }
          
          /* Check For Numeric ID */
          if(isdigit(Char))
          {
             Token = INTLITERAL;
           
             while(Char != '\n' && Char != EOF && isdigit(Char))
             {
                AddToBuffer(&pArgStruct->ActualToken, Char, &pArgStruct->ATIndex, &pArgStruct->ATSize);     
                Char = fgetc(pArgStruct->pFileStruct->Source);
             }
           
             if(Char == '.')
             {
                Token = REALLITERAL;
               
                AddToBuffer(&pArgStruct->ActualToken, Char, &pArgStruct->ATIndex, &pArgStruct->ATSize);
                Char = fgetc(pArgStruct->pFileStruct->Source);
               
                
                while(Char != '\n' && Char != EOF && isdigit(Char))
                {
                   AddToBuffer(&pArgStruct->ActualToken, Char, &pArgStruct->ATIndex, &pArgStruct->ATSize);     
                   Char = fgetc(pArgStruct->pFileStruct->Source);
                }
             }
           
           
            
           }
           
           ungetc(Char, pArgStruct->pFileStruct->Source);
           Char = 0;
           
           Found = 1;
           
        }
        
        
        /* Check for Other IDs */
        switch(Char)
        {
            case '\n' :
              break;
            case '~' :
              Token = CHRLITERAL;
              Found = 1;
              AddToBuffer(&pArgStruct->ActualToken, '"', &pArgStruct->ATIndex, &pArgStruct->ATSize);
              
              Char = getc(pArgStruct->pFileStruct->Source);
              
              while(Char != '\n' && Char != '~' && Char != EOF)
              {
                  if(Char == '"')
                  {
                    AddToBuffer(&pArgStruct->ActualToken, '\\', &pArgStruct->ATIndex, &pArgStruct->ATSize);
                    AddToBuffer(&pArgStruct->ActualToken, '"', &pArgStruct->ATIndex, &pArgStruct->ATSize);
                  }
                  else
                    AddToBuffer(&pArgStruct->ActualToken, Char, &pArgStruct->ATIndex, &pArgStruct->ATSize);

                  Char = getc(pArgStruct->pFileStruct->Source);                      
              }
              
              if(Char == '~')
                 AddToBuffer(&pArgStruct->ActualToken, '"', &pArgStruct->ATIndex, &pArgStruct->ATSize);
              else
                Token = UNKNOWN;

              break;
              
            case '{' : /*------------------------ LEFT BRACE --------------------*/
              Found = 1;
              Token = LBRACE;
              AddToBuffer(&pArgStruct->ActualToken, Char, &pArgStruct->ATIndex, &pArgStruct->ATSize);
              break;
              
            case '}' : /*------------------------ RIGHT BRACE --------------------*/
              Found = 1;
              Token = RBRACE;
              AddToBuffer(&pArgStruct->ActualToken, Char, &pArgStruct->ATIndex, &pArgStruct->ATSize);
              break;
              
            case '>' :  /*-------------------- GREATER -----------------------*/
              Found = 1;
              Token = GTR;
              AddToBuffer(&pArgStruct->ActualToken, Char, &pArgStruct->ATIndex, &pArgStruct->ATSize);
              Char = getc(pArgStruct->pFileStruct->Source);

              switch(Char)
              {
                 
                  case '=' :
                    Token = GTREQL;
                    AddToBuffer(&pArgStruct->ActualToken, Char, &pArgStruct->ATIndex, &pArgStruct->ATSize);
                    break;
                    
                  default:
                  ungetc(Char, pArgStruct->pFileStruct->Source);
              }

              break;
              
            case '<' :     /*---------------- Less Than -------------------*/
              Found = 1;
              Token = LESS;
              AddToBuffer(&pArgStruct->ActualToken, Char, &pArgStruct->ATIndex, &pArgStruct->ATSize);
              Char = getc(pArgStruct->pFileStruct->Source);

              switch(Char)
              {
                  case '>' :
                    Token = NOTEQL;
                    AddToBuffer(&pArgStruct->ActualToken, Char, &pArgStruct->ATIndex, &pArgStruct->ATSize);
                    break;
                    
                  case '=' :
                    Token = LESSEQL;
                    AddToBuffer(&pArgStruct->ActualToken, Char, &pArgStruct->ATIndex, &pArgStruct->ATSize);
                    break;
                    
                  default:
                  ungetc(Char, pArgStruct->pFileStruct->Source);
              }

              break;
              
            case '=' :  /*-----------------------EQUAL--------------------------*/
              Found = 1;
              Token = EQL;
              AddToBuffer(&pArgStruct->ActualToken, Char, &pArgStruct->ATIndex, &pArgStruct->ATSize);
              break;
            
                
            case EOF :  /*----------------  EOF ---------*/
              Found = 1;
              
              fprintf(pArgStruct->pFileStruct->List,"\n");
              
              Token = SCANEOF;
              break;
              
            case ';' :  /*------------- SEMI COLON ------*/
              Found = 1;
              Token = SEMICOLON;
              AddToBuffer(&pArgStruct->ActualToken, Char, &pArgStruct->ATIndex, &pArgStruct->ATSize);
              break;

            case ',' :  /*------------- COMMA -----------*/
              Found = 1;
              Token = COMMA;
              AddToBuffer(&pArgStruct->ActualToken, Char, &pArgStruct->ATIndex, &pArgStruct->ATSize);
              break;
               
            case '(' :  /*------------ LEFT PAREN -------*/
              Found = 1;
              Token = LPAREN;
              AddToBuffer(&pArgStruct->ActualToken, Char, &pArgStruct->ATIndex, &pArgStruct->ATSize);
              break;

            case ')' :  /*----------- RIGHT PAREN -------*/
              Found = 1;
              Token = RPAREN;
              AddToBuffer(&pArgStruct->ActualToken, Char, &pArgStruct->ATIndex, &pArgStruct->ATSize);
              break;
            
            case ':' :  /*---------- ASSIGN OP ----------*/
            
              Found = 1;
              AddToBuffer(&pArgStruct->ActualToken, Char, &pArgStruct->ATIndex, &pArgStruct->ATSize);
              Char = getc(pArgStruct->pFileStruct->Source);
              
              if(Char == ':')
              {
                  Token = ASSIGNOP;
                  AddToBuffer(&pArgStruct->ActualToken, Char, &pArgStruct->ATIndex, &pArgStruct->ATSize);
              }
              else
              {
                  ungetc(Char, pArgStruct->pFileStruct->Source);
                  Token = UNKNOWN;
              }
              break;
            
            case '+' : /*---------- PLUS    ----------*/
              Found = 1;
              Token = PLUSOP;
              AddToBuffer(&pArgStruct->ActualToken, Char, &pArgStruct->ATIndex, &pArgStruct->ATSize);
              break;
            


            case '*' : /*---------- MULTIPLICATION ---------*/
              Found = 1;
              Token = MULTOP;
              AddToBuffer(&pArgStruct->ActualToken, Char, &pArgStruct->ATIndex, &pArgStruct->ATSize);
              break;

            case '/' : /*---------- DIVISION ---------*/
              Found = 1;
              Token = DIVOP;
              AddToBuffer(&pArgStruct->ActualToken, Char, &pArgStruct->ATIndex, &pArgStruct->ATSize);
              break;

            
            case '?' : /*-------- COMMENT ----------*/
            
                 do {
                      Char = fgetc(pArgStruct->pFileStruct->Source);
                  } while(Char != '\n' && Char != EOF) ;

                 break;

       }
    }

    /* Restore Position */
    fsetpos(pArgStruct->pFileStruct->Source, &Position);
   
    return Token;
}      



/*-----------------------------------------------------------------------------------*
   ADD TO BUFFER ROUTINE
 *-----------------------------------------------------------------------------------*/
 void AddToBuffer(char **Buffer, int Char, int *Index, int *Size)
{
    
    if(*Buffer)
    {
        if(*Size > *Index + 1)
        {
            (*Buffer)[*Index] = Char;
            *Index = *Index + 1;
            (*Buffer)[*Index] = 0;
        }
        else
        {
            *Size = *Size + 1;
            *Buffer = (char *)realloc(*Buffer, *Size);
            (*Buffer)[*Index] = Char;
            *Index = *Index + 1;
            (*Buffer)[*Size - 1] = 0;
            
        }
        
    }
    else
    {
      *Buffer = (char *)malloc(2);
      
      (*Buffer)[0] = Char;
      (*Buffer)[1] = 0;
      
      *Index = 1;
      *Size = 2;
    }
    
}

/*-----------------------------------------------------------------------------------*
   CHECK RESERVED WORDS
 *-----------------------------------------------------------------------------------*/
 void CheckReserved(char *Buffer, TOKEN *Token)
{
    
    Buffer = strupr(Buffer);
    
    if(!strcmp(Buffer, "BEGIN"))
       *Token = BEGIN;
       
    if(!strcmp(Buffer, "READ"))
       *Token = READ;

    if(!strcmp(Buffer, "WRITE"))
       *Token = WRITE;
       
    if(!strcmp(Buffer, "END"))
       *Token = END;
       
    if(!strcmp(Buffer, "AND"))
       *Token = AND;

    if(!strcmp(Buffer, "OR"))
       *Token = OR;

    if(!strcmp(Buffer, "ENDR"))
       *Token = ENDR;

    if(!strcmp(Buffer, "REPEAT"))
       *Token = REPEAT;

    if(!strcmp(Buffer, "C2I"))
       *Token = C2I;

    if(!strcmp(Buffer, "I2C"))
       *Token = I2C;
       
    if(!strcmp(Buffer, "I2D"))
       *Token = I2D;
       
    if(!strcmp(Buffer, "D2I"))
       *Token = D2I;

    if(!strcmp(Buffer, "NL"))
       *Token = NL;
       
    if(!strcmp(Buffer, "DEC"))
       *Token = DEC;
 
    if(!strcmp(Buffer, "INT"))
       *Token = INT;
       
    if(!strcmp(Buffer, "CHR"))
       *Token = CHR;

    if(!strcmp(Buffer, "WHEN"))
       *Token = WHEN;

    if(!strcmp(Buffer, "ELSE"))
       *Token = ELSE;
       
    if(!strcmp(Buffer, "WEND"))
       *Token = WEND;

    if(!strcmp(Buffer, "THEN"))
       *Token = THEN;
}



/*-----------------------------------------------------------------------------------*
   REMOVE TOKEN ROUTINE
 *-----------------------------------------------------------------------------------*/
 TOKEN RemoveScan(PARGSTRUCT pArgStruct)
{
    int Found = 0, Char;
    TOKEN Token;

    pArgStruct->ATIndex = 0;
    
    if(!pArgStruct->LineCounter)
    {
       fprintf(pArgStruct->pFileStruct->List, "Line 1: ");
       pArgStruct->LineCounter++;
    }
    
    
    /* Clear Buffer Memory */
    ClearBuffer(pArgStruct->ActualToken);
    
    /* Loop Through File */
    while(!Found)
    {
        /* Load Character */
        Char = fgetc(pArgStruct->pFileStruct->Source);

        /* Check For Alphanumeric ID */
        if(isalpha(Char) || Char == '_')
        {
           Token = ID;
                      
           while(Char != '\n' && Char != EOF && (isalpha(Char) || Char == '_' || isdigit(Char)))
           {
                AddToBuffer(&pArgStruct->ActualToken, Char, &pArgStruct->ATIndex, &pArgStruct->ATSize);
                Char = fgetc(pArgStruct->pFileStruct->Source);
           }
           
           ungetc(Char, pArgStruct->pFileStruct->Source);
           
           Char = 0;
           
           /* Check Reserved Words */
           CheckReserved(pArgStruct->ActualToken, &Token);
            
           Found = 1;    
        }
        
        if(Char == '-' || isdigit(Char))
        {
          if(Char == '-')
          {
            Token = MINUSOP;
            AddToBuffer(&pArgStruct->ActualToken, Char, &pArgStruct->ATIndex, &pArgStruct->ATSize);
          
            Char = fgetc(pArgStruct->pFileStruct->Source);
          }
          
          /* Check For Numeric ID */
          if(isdigit(Char))
          {
             Token = INTLITERAL;
           
             while(Char != '\n' && Char != EOF && isdigit(Char))
             {
                AddToBuffer(&pArgStruct->ActualToken, Char, &pArgStruct->ATIndex, &pArgStruct->ATSize);     
                Char = fgetc(pArgStruct->pFileStruct->Source);
             }
           
             if(Char == '.')
             {
                Token = REALLITERAL;
               
                AddToBuffer(&pArgStruct->ActualToken, Char, &pArgStruct->ATIndex, &pArgStruct->ATSize);
                Char = fgetc(pArgStruct->pFileStruct->Source);
               
                
                while(Char != '\n' && Char != EOF && isdigit(Char))
                {
                   AddToBuffer(&pArgStruct->ActualToken, Char, &pArgStruct->ATIndex, &pArgStruct->ATSize);     
                   Char = fgetc(pArgStruct->pFileStruct->Source);
                }
             }
           
           
            
           }
           
           ungetc(Char, pArgStruct->pFileStruct->Source);
           Char = 0;
           
           Found = 1;
           
        }
        
        
        /* Check for Other IDs */
        switch(Char)
        {
            case '\n' :
              pArgStruct->LineCounter++;
              fprintf(pArgStruct->pFileStruct->List, "\nLine %i:", pArgStruct->LineCounter);
             
              break;
            case '~' :
              Token = CHRLITERAL;
              Found = 1;
              AddToBuffer(&pArgStruct->ActualToken, '"', &pArgStruct->ATIndex, &pArgStruct->ATSize);
              
              Char = getc(pArgStruct->pFileStruct->Source);
              
              while(Char != '\n' && Char != '~' && Char != EOF)
              {
                  if(Char == '"')
                  {
                    AddToBuffer(&pArgStruct->ActualToken, '\\', &pArgStruct->ATIndex, &pArgStruct->ATSize);
                    AddToBuffer(&pArgStruct->ActualToken, '"', &pArgStruct->ATIndex, &pArgStruct->ATSize);
                  }
                  else
                    AddToBuffer(&pArgStruct->ActualToken, Char, &pArgStruct->ATIndex, &pArgStruct->ATSize);
                  
                  Char = getc(pArgStruct->pFileStruct->Source);                                      
              }
              
              if(Char == '~')
                 AddToBuffer(&pArgStruct->ActualToken, '"', &pArgStruct->ATIndex, &pArgStruct->ATSize);
              else
                Token = UNKNOWN;

              break;
              
            case '{' : /*------------------------ LEFT BRACE --------------------*/
              Found = 1;
              Token = LBRACE;
              AddToBuffer(&pArgStruct->ActualToken, Char, &pArgStruct->ATIndex, &pArgStruct->ATSize);
              break;
              
            case '}' : /*------------------------ RIGHT BRACE --------------------*/
              Found = 1;
              Token = RBRACE;
              AddToBuffer(&pArgStruct->ActualToken, Char, &pArgStruct->ATIndex, &pArgStruct->ATSize);
              break;
              
            case '>' :  /*-------------------- GREATER -----------------------*/
              Found = 1;
              Token = GTR;
              AddToBuffer(&pArgStruct->ActualToken, Char, &pArgStruct->ATIndex, &pArgStruct->ATSize);
              Char = getc(pArgStruct->pFileStruct->Source);

              switch(Char)
              {
                 
                  case '=' :
                    Token = GTREQL;
                    AddToBuffer(&pArgStruct->ActualToken, Char, &pArgStruct->ATIndex, &pArgStruct->ATSize);
                    break;
                    
                  default:
                  ungetc(Char, pArgStruct->pFileStruct->Source);
              }

              break;
              
            case '<' :     /*---------------- Less Than -------------------*/
              Found = 1;
              Token = LESS;
              AddToBuffer(&pArgStruct->ActualToken, Char, &pArgStruct->ATIndex, &pArgStruct->ATSize);
              Char = getc(pArgStruct->pFileStruct->Source);

              switch(Char)
              {
                  case '>' :
                    Token = NOTEQL;
                    AddToBuffer(&pArgStruct->ActualToken, Char, &pArgStruct->ATIndex, &pArgStruct->ATSize);
                    break;
                    
                  case '=' :
                    Token = LESSEQL;
                    AddToBuffer(&pArgStruct->ActualToken, Char, &pArgStruct->ATIndex, &pArgStruct->ATSize);
                    break;
                    
                  default:
                  ungetc(Char, pArgStruct->pFileStruct->Source);
              }

              break;
              
            case '=' :  /*-----------------------EQUAL--------------------------*/
              Found = 1;
              Token = EQL;
              AddToBuffer(&pArgStruct->ActualToken, Char, &pArgStruct->ATIndex, &pArgStruct->ATSize);
              break;
            
                
            case EOF :  /*----------------  EOF ---------*/
              Found = 1;
              
              fprintf(pArgStruct->pFileStruct->List,"\n");
              
              Token = SCANEOF;
              break;
              
            case ';' :  /*------------- SEMI COLON ------*/
              Found = 1;
              Token = SEMICOLON;
              AddToBuffer(&pArgStruct->ActualToken, Char, &pArgStruct->ATIndex, &pArgStruct->ATSize);
              break;

            case ',' :  /*------------- COMMA -----------*/
              Found = 1;
              Token = COMMA;
              AddToBuffer(&pArgStruct->ActualToken, Char, &pArgStruct->ATIndex, &pArgStruct->ATSize);
              break;
               
            case '(' :  /*------------ LEFT PAREN -------*/
              Found = 1;
              Token = LPAREN;
              AddToBuffer(&pArgStruct->ActualToken, Char, &pArgStruct->ATIndex, &pArgStruct->ATSize);
              break;

            case ')' :  /*----------- RIGHT PAREN -------*/
              Found = 1;
              Token = RPAREN;
              AddToBuffer(&pArgStruct->ActualToken, Char, &pArgStruct->ATIndex, &pArgStruct->ATSize);
              break;
            
            case ':' :  /*---------- ASSIGN OP ----------*/
            
              Found = 1;
              AddToBuffer(&pArgStruct->ActualToken, Char, &pArgStruct->ATIndex, &pArgStruct->ATSize);
              Char = getc(pArgStruct->pFileStruct->Source);
              
              if(Char == ':')
              {
                  Token = ASSIGNOP;
                  AddToBuffer(&pArgStruct->ActualToken, Char, &pArgStruct->ATIndex, &pArgStruct->ATSize);
              }
              else
              {
                  ungetc(Char, pArgStruct->pFileStruct->Source);
                  Token = UNKNOWN;
              }
              break;
            
            case '+' : /*---------- PLUS    ----------*/
              Found = 1;
              Token = PLUSOP;
              AddToBuffer(&pArgStruct->ActualToken, Char, &pArgStruct->ATIndex, &pArgStruct->ATSize);
              break;
            

            case '*' : /*---------- MULTIPLICATION ---------*/
              Found = 1;
              Token = MULTOP;
              AddToBuffer(&pArgStruct->ActualToken, Char, &pArgStruct->ATIndex, &pArgStruct->ATSize);
              break;

            case '/' : /*---------- DIVISION ---------*/
              Found = 1;
              Token = DIVOP;
              AddToBuffer(&pArgStruct->ActualToken, Char, &pArgStruct->ATIndex, &pArgStruct->ATSize);
              break;

            
            case '?' : /*-------- COMMENT ----------*/
            
                 do {
                      fprintf(pArgStruct->pFileStruct->List, "%c", Char);
                      Char = fgetc(pArgStruct->pFileStruct->Source);
                  } while(Char != '\n' && Char != EOF) ;

                  pArgStruct->LineCounter++;
                  fprintf(pArgStruct->pFileStruct->List, "\nLine %i:", pArgStruct->LineCounter);
                  
                 break;

       }
    }

    /* Print Token To List File */
    fprintf(pArgStruct->pFileStruct->List, "%s ", pArgStruct->ActualToken);
    
    /* Check For Lexical Errors */
    if(Token == UNKNOWN)
       LexicalError(pArgStruct);
   
    return Token;
}      






/*-----------------------------------------------------------------------------------*
   LEXICAL ERROR ROUTINE
 *-----------------------------------------------------------------------------------*/
 void LexicalError(PARGSTRUCT pArgStruct)
{
    pArgStruct->pErrorStruct->LexicalErrors++;
    fprintf(pArgStruct->pFileStruct->List, " Lexical Error  %s\n", pArgStruct->ActualToken);
}



