/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*
  Toby Opferman




  http://www.opferman.com
  toby@opferman.com
 


  SCL (Simple Computer Language) Complier (R)

  C Source Code to be compiled with Watcom C/C++ 10.6 for DOS 32-Bit
  
      ---------------------------------------------------------------------
      
   Scanner Module Code
        
 *-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/


#ifndef __SCAN_H__
#define __SCAN_H__

/*-----------------------------------------------------------------------------------*
    HEADER  FILES
 *-----------------------------------------------------------------------------------*/
#include <stdio.h>
#include <string.h>
#include "main.h"
#include <ctype.h>

/*-----------------------------------------------------------------------------------*
    MACROS
 *-----------------------------------------------------------------------------------*/
#define ClearBuffer(x) x ? (x)[0] = 0 : 0

                       
/*-----------------------------------------------------------------------------------*
    CONSTANTS
 *-----------------------------------------------------------------------------------*/
typedef enum  { BEGIN, END, READ, WRITE, ID, INTLITERAL,
                            LPAREN, RPAREN, SEMICOLON, COMMA, ASSIGNOP,
                            PLUSOP, MINUSOP, DIVOP, MULTOP, EQL, LESSEQL,
                            NOTEQL, LESS, GTREQL, GTR, RBRACE, LBRACE,
                            CHRLITERAL, REALLITERAL, THEN, WEND, ELSE,
                            WHEN, CHR, DEC, INT, NL, D2I, I2C, C2I, I2D,
                            REPEAT, ENDR, OR, AND, SCANEOF, UNKNOWN } TOKEN;


/*-----------------------------------------------------------------------------------*
    PROTOTYPES
 *-----------------------------------------------------------------------------------*/
 TOKEN Scan(PARGSTRUCT);
 TOKEN RemoveScan(PARGSTRUCT);
 void AddToBuffer(char **, int, int *, int *);
 void CheckReserved(char *, TOKEN *);
 void LexicalError(PARGSTRUCT);
 
#endif


