/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*
  Toby Opferman



  http://www.opferman.com
  toby@opferman.com



  SCL (Simple Computer Language) Complier (R)

  C Source Code to be compiled with Watcom C/C++ 10.6 for DOS 32-Bit
  
      ---------------------------------------------------------------------
  
  Variable Structure Routines
   
 *-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/



/*-----------------------------------------------------------------------------------*
    HEADER FILES
 *-----------------------------------------------------------------------------------*/
#include "parser.h"

/*-----------------------------------------------------------------------------------*
   LOOKUP ID
 *-----------------------------------------------------------------------------------*/
 int Lookup(PARGSTRUCT pArgStruct)
{
   int Set = 0;
   int Eval;
   
   if(pArgStruct->pHeadNames)
   {
      Eval = strcmp(pArgStruct->pHeadNames->Name, pArgStruct->ActualToken);

      if(Eval > 0)
        Set = BranchCheck(pArgStruct, pArgStruct->pHeadNames->Right);
      else if(Eval < 0)
               Set = BranchCheck(pArgStruct, pArgStruct->pHeadNames->Left);
            else
            {
               pArgStruct->DataType = pArgStruct->pHeadNames->DataType;
               pArgStruct->Size = pArgStruct->pHeadNames->Size;
               Set = 1;
            }
   }

   return Set;
}


/*-----------------------------------------------------------------------------------*
   SET ARRAY
 *-----------------------------------------------------------------------------------*/
 void SetArray(PARGSTRUCT pArgStruct,  EXPRECSTRUCT Exp)
{
   int Eval;
   
   if(pArgStruct->pHeadNames)
   {
      Eval = strcmp(pArgStruct->pHeadNames->Name, Exp.Name);

      if(Eval > 0)
         BranchSet(Exp, pArgStruct->pHeadNames->Right);
      else if(Eval < 0)
               BranchSet(Exp, pArgStruct->pHeadNames->Left);
            else
               pArgStruct->pHeadNames->Size = 1;
   }

}

/*-----------------------------------------------------------------------------------*
   SET BRANCHES
 *-----------------------------------------------------------------------------------*/
 void BranchSet(EXPRECSTRUCT Exp, PNAMESTRUCT Head)
{
   int Eval;
   
   if(!Head)
     return;
     
   Eval = strcmp(Head->Name, Exp.Name);

   if(Eval > 0)
      BranchSet(Exp, Head->Right);
   else if(Eval < 0)
            BranchSet(Exp, Head->Left);
         else
            Head->Size = 1;
}



/*-----------------------------------------------------------------------------------*
   CHECK BRANCHES
 *-----------------------------------------------------------------------------------*/
 int BranchCheck(PARGSTRUCT pArgStruct, PNAMESTRUCT Head)
{
   int Set = 0;
   int Eval;
   
   if(!Head)
     return Set;
     
   Eval = strcmp(Head->Name, pArgStruct->ActualToken);

   if(Eval > 0)
      Set = BranchCheck(pArgStruct, Head->Right);
   else if(Eval < 0)
            Set = BranchCheck(pArgStruct, Head->Left);
         else
         {
            pArgStruct->DataType = Head->DataType;
            pArgStruct->Size = Head->Size;
            Set = 1;
         }
      
   return Set;
}



/*-----------------------------------------------------------------------------------*
   ENTER ID
 *-----------------------------------------------------------------------------------*/
 void Enter(PARGSTRUCT pArgStruct)
{
   int Eval;  
  
   if(pArgStruct->pHeadNames)
   {
      Eval = strcmp(pArgStruct->pHeadNames->Name, pArgStruct->ActualToken);

      if(Eval >= 0)
      {
          if(pArgStruct->pHeadNames->Right)
             BranchAdd(pArgStruct, pArgStruct->pHeadNames->Right);
          else
          {
             /* Allocate Token Name */
             if(!(pArgStruct->pHeadNames->Right = (PNAMESTRUCT)malloc(sizeof(NAMESTRUCT))))
             {
                /* Dispatch Error */
                DispatchMessage(DM_NOMEMORY);
                exit(ERROR_NOMEM);      
            }
       
            pArgStruct->pHeadNames->Right->Left = pArgStruct->pHeadNames->Right->Right = NULL;
  
            /* Allocate Token Name */
            if(!(pArgStruct->pHeadNames->Right->Name = (char *)malloc(strlen(pArgStruct->ActualToken)+1)))
            {
                /* Dispatch Error */
                DispatchMessage(DM_NOMEMORY);
                exit(ERROR_NOMEM);      
            }
       
            strcpy(pArgStruct->pHeadNames->Right->Name, pArgStruct->ActualToken);
            pArgStruct->pHeadNames->Right->DataType = pArgStruct->DataType;
            pArgStruct->pHeadNames->Right->Size = 0;
         }
          
      }
      else if(Eval < 0)
            {
               if(pArgStruct->pHeadNames->Left)
                 BranchAdd(pArgStruct, pArgStruct->pHeadNames->Left);
               else
               {  
                  /* Allocate Token Name */
                  if(!(pArgStruct->pHeadNames->Left = (PNAMESTRUCT)malloc(sizeof(NAMESTRUCT))))
                  {
                     /* Dispatch Error */
                     DispatchMessage(DM_NOMEMORY);
                     exit(ERROR_NOMEM);      
                 }
       
                 pArgStruct->pHeadNames->Left->Left = pArgStruct->pHeadNames->Left->Right = NULL;
  
                 /* Allocate Token Name */
                 if(!(pArgStruct->pHeadNames->Left->Name = (char *)malloc(strlen(pArgStruct->ActualToken)+1)))
                 {
                     /* Dispatch Error */
                     DispatchMessage(DM_NOMEMORY);
                     exit(ERROR_NOMEM);      
                 }
       
                 strcpy(pArgStruct->pHeadNames->Left->Name, pArgStruct->ActualToken);
                 pArgStruct->pHeadNames->Left->DataType = pArgStruct->DataType;
                 pArgStruct->pHeadNames->Left->Size = 0;
              }
          
            }
   }
   else
   {
       /* Allocate Token Name */
       if(!(pArgStruct->pHeadNames = (PNAMESTRUCT)malloc(sizeof(NAMESTRUCT))))
       {
           /* Dispatch Error */
           DispatchMessage(DM_NOMEMORY);
           exit(ERROR_NOMEM);      
       }
       
       pArgStruct->pHeadNames->Left = pArgStruct->pHeadNames->Right = NULL;

       /* Allocate Token Name */
       if(!(pArgStruct->pHeadNames->Name = (char *)malloc(strlen(pArgStruct->ActualToken)+1)))
       {
           /* Dispatch Error */
           DispatchMessage(DM_NOMEMORY);
           exit(ERROR_NOMEM);      
       }
       
       strcpy(pArgStruct->pHeadNames->Name, pArgStruct->ActualToken);
       pArgStruct->pHeadNames->DataType = pArgStruct->DataType;
       pArgStruct->pHeadNames->Size = 0;
   }


}


/*-----------------------------------------------------------------------------------*
   BRANCH ADD
 *-----------------------------------------------------------------------------------*/
 void BranchAdd(PARGSTRUCT pArgStruct, PNAMESTRUCT Head)
{
    int Eval;
      
    Eval = strcmp(Head->Name, pArgStruct->ActualToken);

    if(Eval >= 0)
      {
          if(Head->Right)
             BranchAdd(pArgStruct, Head->Right);
          else
          {
             /* Allocate Token Name */
             if(!(Head->Right = (PNAMESTRUCT)malloc(sizeof(NAMESTRUCT))))
             {
                /* Dispatch Error */
                DispatchMessage(DM_NOMEMORY);
                exit(ERROR_NOMEM);      
            }
       
            Head->Right->Left = Head->Right->Right = NULL;
  
            /* Allocate Token Name */
            if(!(Head->Right->Name = (char *)malloc(strlen(pArgStruct->ActualToken)+1)))
            {
                /* Dispatch Error */
                DispatchMessage(DM_NOMEMORY);
                exit(ERROR_NOMEM);      
            }
       
            strcpy(Head->Right->Name, pArgStruct->ActualToken);
            Head->Right->DataType = pArgStruct->DataType;
            Head->Right->Size = 0;
         }
          
      }
      else if(Eval < 0)
            {
               if(Head->Left)
                 BranchAdd(pArgStruct, Head->Left);
               else
               {  
                  /* Allocate Token Name */
                  if(!(Head->Left = (PNAMESTRUCT)malloc(sizeof(NAMESTRUCT))))
                  {
                     /* Dispatch Error */
                     DispatchMessage(DM_NOMEMORY);
                     exit(ERROR_NOMEM);      
                 }
       
                 Head->Left->Left = Head->Left->Right = NULL;
  
                 /* Allocate Token Name */
                 if(!(Head->Left->Name = (char *)malloc(strlen(pArgStruct->ActualToken)+1)))
                 {
                     /* Dispatch Error */
                     DispatchMessage(DM_NOMEMORY);
                     exit(ERROR_NOMEM);      
                 }
       
                 strcpy(Head->Left->Name, pArgStruct->ActualToken);
                 Head->Left->DataType = pArgStruct->DataType;
                 Head->Left->Size = 0;                 
              }
          
            }

}


/*-----------------------------------------------------------------------------------*
   GENERATE OUTPUT
 *-----------------------------------------------------------------------------------*/
 void Generate(short Count, PARGSTRUCT pArgStruct, ...)
{
    short X = 0;
    va_list TheList;

    va_start(TheList, pArgStruct);
    
    while(X < Count)
    {
       fprintf(pArgStruct->pFileStruct->Target, "%s", va_arg(TheList, char *));
       X++;
    }

    va_end(TheList);
    
    fprintf(pArgStruct->pFileStruct->Target, "\n");
}


