			/*-=-=-=-=-=-=-=-=-=-=-=-*
			      Toby Opferman
			    SPRITE Functions
			 *-=-=-=-=-=-=-=-=-=-=-=-*/


 /* Put Image On Buffer */
 void PutImage(char far *Image, SPRITE *S, char far *Buffer, int TRANS)
{
  int ClipX, ClipY, TempX;

  /* Clip The X & Y */
  ClipX = S->X + S->MaxX >= 320 ? 320 - S->X : S->MaxX;
  ClipY = S->Y + S->MaxY >= 200 ? 200 - S->Y : S->MaxY;

  if(ClipY <= 0 && ClipX <= 0)
    return;

  Buffer+= S->X + (S->Y*320);

  while(ClipY)
  {
    TempX = 0;

    while(TempX < ClipX)
    {
      if(!TRANS)
	Buffer[TempX] = Image[TempX];
      else if(Image[TempX])
	      Buffer[TempX] = Image[TempX];

      TempX++;
    }

    Buffer+= 320;
    Image+= S->MaxX;
    ClipY--;
  }
}

 /* Get Background */
 void GetBKG(SPRITE *S, char far *Buffer)
{
  int ClipX, ClipY, TempX;
  char far *Image;

  /* Clip The X & Y */
  ClipX = S->X + S->MaxX >= 320 ? 320 - S->X : S->MaxX;
  ClipY = S->Y + S->MaxY >= 200 ? 200 - S->Y : S->MaxY;

  if(ClipY <= 0 && ClipX <= 0)
    return;

  Buffer+= S->X + (S->Y*320);

  Image = S->Bkg;

  while(ClipY)
  {
    TempX = 0;

    while(TempX < ClipX)
    {
      Image[TempX] = Buffer[TempX];
      TempX++;
    }

    Buffer+= 320;
    Image+= S->MaxX;
    ClipY--;
  }

}

 /* Move The Sprite */
 void MoveSprite(SPRITE *S, char far *Buffer)
{

  PutImage(S->Bkg, S, Buffer, 0);

  S->X = S->NewX;
  S->Y = S->NewY;

  S->Counter++;

  if(S->Counter >= S->NCountF)
  {
    S->CurFrame++;
    S->Counter = 0;

    if(S->CurFrame >= S->MaxFrames)
       S->CurFrame = 0;
  }

  GetBKG(S, Buffer);

  PutImage(S->Image[S->CurFrame], S, Buffer, 1);

}
