                          /*-=-=-=-=-=-=-=-=-=-=-* 
                                 Toby Opferman
                                   3-D Wire
                                   Graphics 
                                    Library
                            *-=-=-=-=-=-=-=-=-=-=-*/



 /* Rotate an Object on X Axis */
 void ObjRotX(_3D_Obj *Object)
{
   int Points;

   Points = Object->Points;

   /* Rotate all points */
   do {

	Points--;
	Rotx(&Object->P[Points], Object->Radians);

       } while(Points) ;
}
 /* Rotate Object on Y Axis */
 void ObjRotY(_3D_Obj *Object)
{
   int Points;

   Points = Object->Points;

   /* Rotate all Points */
   do {

	Points--;
	Roty(&Object->P[Points], Object->Radians);

       } while(Points) ;
}
 /* Rotate Object on Z axis */
 void ObjRotZ(_3D_Obj * Object)
{
   int Points;

   Points = Object->Points;

   /* Rotate All Points */
   do {

	Points--;
	Rotz(&Object->P[Points], Object->Radians);

       } while(Points) ;
}

 /* Convert Degrees to Radians */
 float Rad(float Angle)
{
    return Angle * (PI/180);
}

 /* Rotate Point on X Axis */
 void Rotx(_3D_Point *P, float Rad)
{
   float ny, nz;

   ny = cos(Rad)*P->y - sin(Rad)*P->z;
   nz = sin(Rad)*P->y + cos(Rad)*P->z;

   P->y = ny;
   P->z = nz;
}

 /* Rotate Point on Y Axis */
 void Roty(_3D_Point *P, float Rad)
{
   float nx, nz;

   nx = cos(Rad)*P->x - sin(Rad)*P->z;
   nz = sin(Rad)*P->x + cos(Rad)*P->z;

   P->x = nx;
   P->z = nz;
}

 /* Rotate Point on Z Axis */
 void Rotz(_3D_Point *P, float Rad)
{
   float nx, ny;

   nx = cos(Rad)*P->x - sin(Rad)*P->y;
   ny = sin(Rad)*P->x + cos(Rad)*P->y;

   P->x = nx;
   P->y = ny;
}

 /* Draw 3D Object */
 void ObjDraw(_3D_Obj *Object, char far *Buffer)
{
    int x, y, x2, y2;
    int *Pairs, LineNum;

    LineNum = Object->MaxLines;

    Pairs = Object->LinePairs;

    /* While drawing lines */
    do {
	 LineNum--;

	 /*  Project X, Y, Z to 2D X, Y */
	 x = ((256*Object->P[*Pairs].x)/
	     (Object->P[*Pairs].z - Object->OffSets.z)) + Object->OffSets.x;

	 y = ((256*Object->P[*Pairs].y)/
	     (Object->P[*Pairs].z - Object->OffSets.z)) + Object->OffSets.y;


	 Pairs++;

	 x2 = ((256*Object->P[*Pairs].x)/
	      (Object->P[*Pairs].z - Object->OffSets.z)) + Object->OffSets.x;

	 y2 = ((256*Object->P[*Pairs].y)/
	      (Object->P[*Pairs].z - Object->OffSets.z)) + Object->OffSets.y;

	 Pairs++;

	 /* Draw Line */
	 Line(x, y, x2, y2, Object->Colour, Buffer);

       } while(LineNum) ;



}

 /* "Unbound" Line Draw Function */
 void Line(int x1, int y1, int x2, int y2, char Colour, char far *Buffer)
{
   int dx, dy, x_inc, y_inc, error = 0, index;

   char far *vb_start;

   /* Start of Line */
   vb_start = Buffer + ((y1<<6) + (y1<<8)) + x1;

   /* Calculate Delta X, Y */
   dx = x2 - x1;
   dy = y2 - y1;

   if (dx >= 0)
       x_inc = 1;
   else
   {
       x_inc = -1;
       dx = -dx;
   }

   if (dy >= 0)
       y_inc = 320;
   else
   {
       y_inc = -320;
       dy = -dy;
   }

   /* If Delta X > Delta Y */
   if (dx>dy)
   {
       for (index = 0; index <=dx; index++)
       {
	   /* Plot Point */
	   *vb_start = Colour;

	   error+=dy;

	   if(error>dx)
	   {
	       error-=dx;
	       vb_start+=y_inc;
	   }



	   vb_start+= x_inc;
       }
   }
   else
   {
       for (index = 0; index <= dy; index++)
       {
	   /* Plot Point */
	   *vb_start = Colour;

	   error+=dx;

	   if (error >0)
	   {
	       error-=dy;

	       vb_start+= x_inc;

	   }

	   vb_start += y_inc;
       }
   }


}





 
