/*-=-=-=-=-=-=-=-=-=-=-=-* 
    Towers Of Hanoi

      Toby Opferman
 *-=-=-=-=-=-=-=-=-=-=-=-*/


DataBase
 poles(Integer, Integer)

Predicates  
 Init
 MainProgram
 Perform(Char)
 Tower(Integer)
 PlantDisk(Integer, Integer, Integer)
 MakePoleOne(Integer)
 Go(Integer, Integer)
 Perform2(Integer, Integer)
 INC(Integer, Integer)
 DEC(Integer, Integer)
 GetTo(Integer)
 GetFrom(Integer)
 WritePoles(Integer, Integer, Integer, Integer)  
 PlantIt(Integer, Integer, Integer, Integer, Integer)
 GetSmall(Integer, Integer)
 CheckWinner(Integer, Integer) 
 DDisplay(Integer, Integer, Integer)
 DDisplayBeta(Integer, Integer, Integer, Integer)
 
Clauses

/*-=-=-=-=-=-=-=-=-=-=-=-* 
   Initialize Window 
 *-=-=-=-=-=-=-=-=-=-=-=-*/
 Init :-
  MakeWindow(1, 2, 3, "Towers Of Hanoi", 0, 0, 21, 80),
  MakeWindow(2, 2, 3, "Command Window", 21, 0, 4, 80). 

/*-=-=-=-=-=-=-=-=-=-*
    Main Menu 
 *-=-=-=-=-=-=-=-=-=-*/
 MainProgram :-
  retractall(poles(_, _)),
  GotoWindow(1),
  ClearWindow(),
  Write("\t\t\tTowers Menu"),
  Write("\n\t\t(1.) Run Towers"),
  Write("\n\t\t(2.) Help"),
  Write("\n\t\t(3.) Exit"),
  GotoWindow(2),
  ClearWindow(),
  Write("\n\t\t\tChoice> "),
  ReadChar(X),
  Perform(X).
  
 MainProgram :- MainProgram.
 
/*-=-=-=-=-=-=-=-=-=-=-* 
   Perform Operations 
 *-=-=-=-=-=-=-=-=-=-=-*/ 
 Perform('1') :- Write("\n\t\tEnter Number Of Blocks (1-12)> "),
		 Readint(X),
		 X < 13,
		 Tower(X),
		 GotoWindow(2),
		 ClearWindow(),
		 Write("\n\nPress Enter>"),
		 ReadChar(_),
		 MainProgram.
 
 Perform('2') :- GotoWindow(1),
		 ClearWindow(),
		 Write("\n\n\n\n"),
		 Write("\t\t\tAbout Towers Of Hanoi\n\n"),
		 Write("\t\t    Very Simple.  Move the disks from\n"),
		 Write("\t\t  one pole to another pole, making sure\n"),
		 Write("\t\t  to never put a larger disk on top of a\n"),
		 Write("\t\t  smaller disk.  The object is to stack\n"),
		 Write("\t\t  the disks from pole one to pole three\n"),
		 Write("\t\t  in as few moves as possible.\n"),
		 GotoWindow(2),
		 ClearWindow(),
		 Write("\t\t Press [Enter] "),
		 ReadChar(_),
		 MainProgram.
 
 Perform('3') :- !.
 
 Perform(_) :- Write("\n\t\t\tInvalid Choice"),
		   ReadChar(_),
		   MainProgram.
		   

/*-=-=-=-=-=-=-=-=-=-=-=-=-* 
     Tower Of Hanoi 
 *-=-=-=-=-=-=-=-=-=-=-=-=-*/ 
Tower(X) :- ClearWindow(),
	    MakePoleOne(X), fail.
	
Tower(X) :- Go(0, X).

  
/*-=-=-=-=-=-=-=-=-=-* 
    Make Moves 
 *-=-=-=-=-=-=-=-=-=-*/
Go(X, OP) :- 
  GotoWindow(1),
  ClearWindow(),
  WritePoles(18, 18, 18, 12),
  GotoWindow(2),
  ClearWindow(),
  GetFrom(N),
  N <= 1, Inc(X, Moves), 
  DDisplayBeta(N, OP, Moves, 1), !.

Go(X, OP) :- 
  Inc(X, NewX),
  Go(NewX, OP), !.
  
/*-=-=-=-=-=-=-=-=-=-=-=-=-*
       Display Status
 *-=-=-=-=-=-=-=-=-=-=-=-=-*/
DDisplayBeta(N, TotalDisks, X, OP) :-
 TotalDisks > 0,
 NewOP = OP*2,
 DEC(TotalDisks, NewTot),
 DDisplayBeta(N, NewTot, X, NewOP), !.

DDisplayBeta(N, _, X, OP) :-
 DEC(OP, NewOP),
 DDisplay(N, NewOP, X).
 
DDisplay(N, OP, X) :-
  GotoWindow(1),
  ClearWindow(),
  Cursor(10, 34),
  Write("Game  Over"),
  GotoWindow(2),
  N <> 1,   
  GotoWindow(1),
  ClearWindow(), 
  Write("\nYour Number Of Moves Was ", X),
  Write("\nOptimal Moves is ", OP),
  X = OP,
  Write("\nExcellent."), !.

DDisplay(_, _, _) :- Write("\nTry Again.").
             


/*-=-=-=-=-=-=-=-=-=-*
    User Input
    Get Poles
    To And From
    And Move Them
 *-=-=-=-=-=--=-=-=-*/
GetFrom(N) :-
 ClearWindow(),
 Write("\nEnter Pole To Move From [(1-3) 0 To Quit]> "),
 Readint(FROM),
 Perform2(FROM, Nx),
 Nx <> 3,
 CheckWinner(Nx, N),
 !.
 
GetFrom(N) :- GetFrom(N). 
 
Perform2(0, N) :- N = 1, !.

Perform2(FROM, N) :- 
     GetSmall(FROM, ST2),
     ST2 <> 20,
     GetTo(TO),
     TO <> FROM,
     GetSmall(TO, ST),
     ST > ST2,
     retractall(poles(FROM, ST2)),
     assertz(poles(TO, ST2)),
     N = 2.
     
    
Perform2(_, N) :- N = 3,
	       Write("\n Invalid Move.\n Press a Key> "),
	       ReadChar(_).


GetTo(TO) :-
 Write("\nEnter Pole To Move To [(1-3)]> "),
 Readint(TO),
 TO <= 3,
 TO >= 1, !.

/*-=-=-=-=-=-=-=-=-=-=-=-*
     Get Smallest
	Number
 *-=-=-=-=-=-=-=-=-=-=-=-*/

GetSmall(PoleNum, Disk) :-
 poles(PoleNum, 1),
 Disk = 1, !.
 
GetSmall(PoleNum, Disk) :-
 poles(PoleNum, 2),
 Disk = 2, !.

GetSmall(PoleNum, Disk) :-
 poles(PoleNum, 3),
 Disk = 3, !.

GetSmall(PoleNum, Disk) :-
 poles(PoleNum, 4),
 Disk = 4, !.

GetSmall(PoleNum, Disk) :-
 poles(PoleNum, 5),
 Disk = 5, !.

GetSmall(PoleNum, Disk) :-
 poles(PoleNum, 6),
 Disk = 6, !.

GetSmall(PoleNum, Disk) :-
 poles(PoleNum, 7),
 Disk = 7, !.

GetSmall(PoleNum, Disk) :-
 poles(PoleNum, 8),
 Disk = 8, !.

GetSmall(PoleNum, Disk) :-
 poles(PoleNum, 9),
 Disk = 9, !.

GetSmall(PoleNum, Disk) :-
 poles(PoleNum, 10),
 Disk = 10, !.

GetSmall(PoleNum, Disk) :-
 poles(PoleNum, 11),
 Disk = 11, !.

GetSmall(PoleNum, Disk) :-
 poles(PoleNum, 12),
 Disk = 12, !.
 
GetSmall(_, Disk) :-
 Disk = 20, !.

/*-=-=-=-=-=-=-=-=-=-=-=* 
   Make The First Pole 
 *-=-=-=-=-=-=-=-=-=-=-=*/
MakePoleOne(X) :-
   assertz(poles(1, X)),
   DEC(X, NewX),
   NewX <> 0,
   MakePoleOne(NewX), !.

MakePoleOne(_) :- !.


/*-=-=-=-=-=-=-=-=-=-=-*
   Check To See If
      Won Yet
 *-=-=-=-=-=-=-=-=-=-=-*/
 CheckWinner(Nx, N) :-
 Nx <> 1,
 GetSmall(3, Small3),
 Small3 = 1,
 GetSmall(2, Small2),
 Small2 = 20,
 GetSmall(1, Small1),
 Small1 = 20,
 N = 0, !.
 
 CheckWinner(Nx, N) :- 
     N = Nx.
 
/*-=-=-=-=-=-=-=-=-=-=-*
   Dec/Inc Var Funcs
 *-=-=-=-=-=-=-=-=-=-=-*/
DEC(Ox, Nx) :- Nx = Ox - 1.
INC(Ox, Nx) :- Nx = Ox + 1.


/*-=-=-=-=-=-=-=-=-=-=-=-=-* 
   Write The Poles Functions
 *-=-=-=-=-=-=-=-=-=-=-=-=-*/
WritePoles(Y1, Y2, Y3, PoleNum) :-
 PoleNum > 0,
 poles(P, PoleNum),
 Plantit(P, PoleNum, Y1, Y2, Y3), !.

WritePoles(Y1, Y2, Y3, PoleNum) :-
 PoleNum > 0, DEC(PoleNum, NewP),
 WritePoles(Y1, Y2, Y3, NewP), !.

WritePoles(_, _, _, _) :- !.

Plantit(P, PoleNum, Y1, Y2, Y3) :-
 not(free(P)),
 P = 1,
 PlantDisk(Y1, P, PoleNum),
 DEC(Y1, NewY),
 DEC(PoleNum, NewPole),
 WritePoles(NewY, Y2, Y3, NewPole), !.

Plantit(P, PoleNum, Y1, Y2, Y3) :-
 not(free(P)),
 P = 2,
 PlantDisk(Y2, P, PoleNum),
 DEC(Y2, NewY),
 DEC(PoleNum, NewPole),
 WritePoles(Y1, NewY, Y3, NewPole), !.

Plantit(P, PoleNum, Y1, Y2, Y3) :-
 not(free(P)),
 P = 3,
 PlantDisk(Y3, P, PoleNum),
 DEC(Y3, NewY),
 DEC(PoleNum, NewPole),
 WritePoles(Y1, Y2, NewY, NewPole), !.
 

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-* 
      Disk Drawing Functions
 *-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
PlantDisk(Y, 1, 1) :-
 Cursor(Y, 13),
 Write("1").
 
PlantDisk(Y, 1, 2) :-
 Cursor(Y, 12),
 Write("*2*").
 
PlantDisk(Y, 1, 3) :-
 Cursor(Y, 11), 
 Write("**3**").
 
PlantDisk(Y, 1, 4) :-
 Cursor(Y, 10), 
 Write("***4***").

PlantDisk(Y, 1, 5) :-
 Cursor(Y, 9), 
 Write("****5****").
 
PlantDisk(Y, 1, 6) :-
 Cursor(Y, 8), 
 Write("*****6*****").
 
PlantDisk(Y, 1, 7) :-
 Cursor(Y, 7), 
 Write("******7******").
 
PlantDisk(Y, 1, 8) :-
 Cursor(Y, 6), 
 Write("*******8*******").
 
PlantDisk(Y, 1, 9) :- 
 Cursor(Y, 5), 
 Write("********9********").
 
PlantDisk(Y, 1, 10) :-
 Cursor(Y, 4), 
 Write("********10*********").
 
PlantDisk(Y, 1, 11) :-
 Cursor(Y, 3), 
 Write("*********11**********").
 
PlantDisk(Y, 1, 12) :-
 Cursor(Y, 2), 
 Write("**********12***********").

PlantDisk(Y, 2, 1) :-
 Cursor(Y, 38),
 Write("1").
 
PlantDisk(Y, 2, 2) :-
 Cursor(Y, 37), 
 Write("*2*").
 
PlantDisk(Y, 2, 3) :-
 Cursor(Y, 36), 
 Write("**3**").
 
PlantDisk(Y, 2, 4) :-
 Cursor(Y, 35), 
 Write("***4***").

PlantDisk(Y, 2, 5) :-
 Cursor(Y, 34), 
 Write("****5****").
 
PlantDisk(Y, 2, 6) :-
 Cursor(Y, 33), 
 Write("*****6*****").
 
PlantDisk(Y, 2, 7) :-
 Cursor(Y, 32), 
 Write("******7******").
 
PlantDisk(Y, 2, 8) :-
 Cursor(Y, 31), 
 Write("*******8*******").
 
PlantDisk(Y, 2, 9) :- 
 Cursor(Y, 30), 
 Write("********9********").
 
PlantDisk(Y, 2, 10) :-
 Cursor(Y, 29), 
 Write("********10*********").
 
PlantDisk(Y, 2, 11) :-
 Cursor(Y, 28), 
 Write("*********11**********").
 
PlantDisk(Y, 2, 12) :-
 Cursor(Y, 27), 
 Write("**********12***********").
 
PlantDisk(Y, 3, 1) :-
 Cursor(Y, 63), 
 Write("1").
 
PlantDisk(Y, 3, 2) :-
 Cursor(Y, 62), 
 Write("*2*").
 
PlantDisk(Y, 3, 3) :-
 Cursor(Y, 61), 
 Write("**3**").
 
PlantDisk(Y, 3, 4) :-
 Cursor(Y, 60), 
 Write("***4***").

PlantDisk(Y, 3, 5) :-
 Cursor(Y, 59), 
 Write("****5****").
 
PlantDisk(Y, 3, 6) :-
 Cursor(Y, 58), 
 Write("*****6*****").
 
PlantDisk(Y, 3, 7) :-
 Cursor(Y, 57), 
 Write("******7******").
 
PlantDisk(Y, 3, 8) :-
 Cursor(Y, 56), 
 Write("*******8*******").
 
PlantDisk(Y, 3, 9) :- 
 Cursor(Y, 55), 
 Write("********9********").
 
PlantDisk(Y, 3, 10) :-
 Cursor(Y, 54), 
 Write("********10*********").
 
PlantDisk(Y, 3, 11) :-
 Cursor(Y, 53), 
 Write("*********11**********").
 
PlantDisk(Y, 3, 12) :-
 Cursor(Y, 52), 
 Write("**********12***********").

/*-=-=-=-=-=-=-=-=-=-=-=-*
     Start Module
 *-=-=-=-=-=-=-=-=-=-=-=-*/
Goal
 Init,
 MainProgram.
